// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/functions/v1beta2/functions.proto

package functions

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/serviceconfig"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Describes the current stage of a deployment.
type CloudFunctionStatus int32

const (
	// Status not specified.
	CloudFunctionStatus_STATUS_UNSPECIFIED CloudFunctionStatus = 0
	// Successfully deployed.
	CloudFunctionStatus_READY CloudFunctionStatus = 1
	// Not deployed correctly - behavior is undefined. The item should be updated
	// or deleted to move it out of this state.
	CloudFunctionStatus_FAILED CloudFunctionStatus = 2
	// Creation or update in progress.
	CloudFunctionStatus_DEPLOYING CloudFunctionStatus = 3
	// Deletion in progress.
	CloudFunctionStatus_DELETING CloudFunctionStatus = 4
)

var CloudFunctionStatus_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "READY",
	2: "FAILED",
	3: "DEPLOYING",
	4: "DELETING",
}

var CloudFunctionStatus_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"READY":              1,
	"FAILED":             2,
	"DEPLOYING":          3,
	"DELETING":           4,
}

func (x CloudFunctionStatus) String() string {
	return proto.EnumName(CloudFunctionStatus_name, int32(x))
}

func (CloudFunctionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{0}
}

// Describes a Cloud Function that contains user computation executed in
// response to an event. It encapsulate function and triggers configurations.
type CloudFunction struct {
	// A user-defined name of the function. Function names must be unique
	// globally and match pattern `projects/*/locations/*/functions/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The location of the function source code.
	//
	// Types that are valid to be assigned to SourceCode:
	//	*CloudFunction_SourceArchiveUrl
	//	*CloudFunction_SourceRepository
	SourceCode isCloudFunction_SourceCode `protobuf_oneof:"source_code"`
	// An event that triggers the function.
	//
	// Types that are valid to be assigned to Trigger:
	//	*CloudFunction_HttpsTrigger
	//	*CloudFunction_EventTrigger
	Trigger isCloudFunction_Trigger `protobuf_oneof:"trigger"`
	// Output only. Status of the function deployment.
	Status CloudFunctionStatus `protobuf:"varint,7,opt,name=status,proto3,enum=google.cloud.functions.v1beta2.CloudFunctionStatus" json:"status,omitempty"`
	// Output only. Name of the most recent operation modifying the function. If
	// the function status is `DEPLOYING` or `DELETING`, then it points to the
	// active operation.
	LatestOperation string `protobuf:"bytes,8,opt,name=latest_operation,json=latestOperation,proto3" json:"latest_operation,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named "function".
	// For Node.js this is name of a function exported by the module specified
	// in `source_location`.
	EntryPoint string `protobuf:"bytes,9,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// The function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	Timeout *duration.Duration `protobuf:"bytes,10,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The amount of memory in MB available for a function.
	// Defaults to 256MB.
	AvailableMemoryMb int32 `protobuf:"varint,11,opt,name=available_memory_mb,json=availableMemoryMb,proto3" json:"available_memory_mb,omitempty"`
	// Output only. The service account of the function.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The last update timestamp of a Cloud Function.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,15,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CloudFunction) Reset()         { *m = CloudFunction{} }
func (m *CloudFunction) String() string { return proto.CompactTextString(m) }
func (*CloudFunction) ProtoMessage()    {}
func (*CloudFunction) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{0}
}

func (m *CloudFunction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudFunction.Unmarshal(m, b)
}
func (m *CloudFunction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudFunction.Marshal(b, m, deterministic)
}
func (m *CloudFunction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudFunction.Merge(m, src)
}
func (m *CloudFunction) XXX_Size() int {
	return xxx_messageInfo_CloudFunction.Size(m)
}
func (m *CloudFunction) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudFunction.DiscardUnknown(m)
}

var xxx_messageInfo_CloudFunction proto.InternalMessageInfo

func (m *CloudFunction) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isCloudFunction_SourceCode interface {
	isCloudFunction_SourceCode()
}

type CloudFunction_SourceArchiveUrl struct {
	SourceArchiveUrl string `protobuf:"bytes,14,opt,name=source_archive_url,json=sourceArchiveUrl,proto3,oneof"`
}

type CloudFunction_SourceRepository struct {
	SourceRepository *SourceRepository `protobuf:"bytes,3,opt,name=source_repository,json=sourceRepository,proto3,oneof"`
}

func (*CloudFunction_SourceArchiveUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepository) isCloudFunction_SourceCode() {}

func (m *CloudFunction) GetSourceCode() isCloudFunction_SourceCode {
	if m != nil {
		return m.SourceCode
	}
	return nil
}

func (m *CloudFunction) GetSourceArchiveUrl() string {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceArchiveUrl); ok {
		return x.SourceArchiveUrl
	}
	return ""
}

func (m *CloudFunction) GetSourceRepository() *SourceRepository {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceRepository); ok {
		return x.SourceRepository
	}
	return nil
}

type isCloudFunction_Trigger interface {
	isCloudFunction_Trigger()
}

type CloudFunction_HttpsTrigger struct {
	HttpsTrigger *HTTPSTrigger `protobuf:"bytes,6,opt,name=https_trigger,json=httpsTrigger,proto3,oneof"`
}

type CloudFunction_EventTrigger struct {
	EventTrigger *EventTrigger `protobuf:"bytes,12,opt,name=event_trigger,json=eventTrigger,proto3,oneof"`
}

func (*CloudFunction_HttpsTrigger) isCloudFunction_Trigger() {}

func (*CloudFunction_EventTrigger) isCloudFunction_Trigger() {}

func (m *CloudFunction) GetTrigger() isCloudFunction_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *CloudFunction) GetHttpsTrigger() *HTTPSTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_HttpsTrigger); ok {
		return x.HttpsTrigger
	}
	return nil
}

func (m *CloudFunction) GetEventTrigger() *EventTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_EventTrigger); ok {
		return x.EventTrigger
	}
	return nil
}

func (m *CloudFunction) GetStatus() CloudFunctionStatus {
	if m != nil {
		return m.Status
	}
	return CloudFunctionStatus_STATUS_UNSPECIFIED
}

func (m *CloudFunction) GetLatestOperation() string {
	if m != nil {
		return m.LatestOperation
	}
	return ""
}

func (m *CloudFunction) GetEntryPoint() string {
	if m != nil {
		return m.EntryPoint
	}
	return ""
}

func (m *CloudFunction) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *CloudFunction) GetAvailableMemoryMb() int32 {
	if m != nil {
		return m.AvailableMemoryMb
	}
	return 0
}

func (m *CloudFunction) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *CloudFunction) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CloudFunction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CloudFunction_OneofMarshaler, _CloudFunction_OneofUnmarshaler, _CloudFunction_OneofSizer, []interface{}{
		(*CloudFunction_SourceArchiveUrl)(nil),
		(*CloudFunction_SourceRepository)(nil),
		(*CloudFunction_HttpsTrigger)(nil),
		(*CloudFunction_EventTrigger)(nil),
	}
}

func _CloudFunction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CloudFunction)
	// source_code
	switch x := m.SourceCode.(type) {
	case *CloudFunction_SourceArchiveUrl:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SourceArchiveUrl)
	case *CloudFunction_SourceRepository:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceRepository); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CloudFunction.SourceCode has unexpected type %T", x)
	}
	// trigger
	switch x := m.Trigger.(type) {
	case *CloudFunction_HttpsTrigger:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpsTrigger); err != nil {
			return err
		}
	case *CloudFunction_EventTrigger:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EventTrigger); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CloudFunction.Trigger has unexpected type %T", x)
	}
	return nil
}

func _CloudFunction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CloudFunction)
	switch tag {
	case 14: // source_code.source_archive_url
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.SourceCode = &CloudFunction_SourceArchiveUrl{x}
		return true, err
	case 3: // source_code.source_repository
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SourceRepository)
		err := b.DecodeMessage(msg)
		m.SourceCode = &CloudFunction_SourceRepository{msg}
		return true, err
	case 6: // trigger.https_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPSTrigger)
		err := b.DecodeMessage(msg)
		m.Trigger = &CloudFunction_HttpsTrigger{msg}
		return true, err
	case 12: // trigger.event_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventTrigger)
		err := b.DecodeMessage(msg)
		m.Trigger = &CloudFunction_EventTrigger{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CloudFunction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CloudFunction)
	// source_code
	switch x := m.SourceCode.(type) {
	case *CloudFunction_SourceArchiveUrl:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SourceArchiveUrl)))
		n += len(x.SourceArchiveUrl)
	case *CloudFunction_SourceRepository:
		s := proto.Size(x.SourceRepository)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// trigger
	switch x := m.Trigger.(type) {
	case *CloudFunction_HttpsTrigger:
		s := proto.Size(x.HttpsTrigger)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CloudFunction_EventTrigger:
		s := proto.Size(x.EventTrigger)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes HTTPSTrigger, could be used to connect web hooks to function.
type HTTPSTrigger struct {
	// Output only. The deployed url for the function.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPSTrigger) Reset()         { *m = HTTPSTrigger{} }
func (m *HTTPSTrigger) String() string { return proto.CompactTextString(m) }
func (*HTTPSTrigger) ProtoMessage()    {}
func (*HTTPSTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{1}
}

func (m *HTTPSTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPSTrigger.Unmarshal(m, b)
}
func (m *HTTPSTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPSTrigger.Marshal(b, m, deterministic)
}
func (m *HTTPSTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPSTrigger.Merge(m, src)
}
func (m *HTTPSTrigger) XXX_Size() int {
	return xxx_messageInfo_HTTPSTrigger.Size(m)
}
func (m *HTTPSTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPSTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPSTrigger proto.InternalMessageInfo

func (m *HTTPSTrigger) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Describes EventTrigger, used to request events be sent from another
// service.
type EventTrigger struct {
	// `event_type` names contain the service that is sending an event and the
	// kind of event that was fired. Must be of the form
	// `providers/*/eventTypes/*` e.g. Directly handle a Message published to
	// Google Cloud Pub/Sub `providers/cloud.pubsub/eventTypes/topic.publish`
	//
	//      Handle an object changing in Google Cloud Storage
	//      `providers/cloud.storage/eventTypes/object.change`
	//
	//      Handle a write to the Firebase Realtime Database
	//      `providers/firebase.database/eventTypes/data.write`
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Which instance of the source's service should send events. E.g. for Pub/Sub
	// this would be a Pub/Sub topic at `projects/*/topics/*`. For Google Cloud
	// Storage this would be a bucket at `projects/*/buckets/*`. For any source
	// that only supports one instance per-project, this should be the name of the
	// project (`projects/*`)
	Resource             string   `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventTrigger) Reset()         { *m = EventTrigger{} }
func (m *EventTrigger) String() string { return proto.CompactTextString(m) }
func (*EventTrigger) ProtoMessage()    {}
func (*EventTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{2}
}

func (m *EventTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventTrigger.Unmarshal(m, b)
}
func (m *EventTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventTrigger.Marshal(b, m, deterministic)
}
func (m *EventTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventTrigger.Merge(m, src)
}
func (m *EventTrigger) XXX_Size() int {
	return xxx_messageInfo_EventTrigger.Size(m)
}
func (m *EventTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_EventTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_EventTrigger proto.InternalMessageInfo

func (m *EventTrigger) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *EventTrigger) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

// Describes the location of the function source in a remote repository.
type SourceRepository struct {
	// URL to the hosted repository where the function is defined. Only paths in
	// https://source.developers.google.com domain are supported. The path should
	// contain the name of the repository.
	RepositoryUrl string `protobuf:"bytes,1,opt,name=repository_url,json=repositoryUrl,proto3" json:"repository_url,omitempty"`
	// The path within the repository where the function is defined. The path
	// should point to the directory where Cloud Functions files are located. Use
	// "/" if the function is defined directly in the root directory of a
	// repository.
	SourcePath string `protobuf:"bytes,2,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// The version of a function. Defaults to the latest version of the master
	// branch.
	//
	// Types that are valid to be assigned to Version:
	//	*SourceRepository_Branch
	//	*SourceRepository_Tag
	//	*SourceRepository_Revision
	Version isSourceRepository_Version `protobuf_oneof:"version"`
	// Output only. The id of the revision that was resolved at the moment of
	// function creation or update. For example when a user deployed from a
	// branch, it will be the revision id of the latest change on this branch at
	// that time. If user deployed from revision then this value will be always
	// equal to the revision specified by the user.
	DeployedRevision     string   `protobuf:"bytes,6,opt,name=deployed_revision,json=deployedRevision,proto3" json:"deployed_revision,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SourceRepository) Reset()         { *m = SourceRepository{} }
func (m *SourceRepository) String() string { return proto.CompactTextString(m) }
func (*SourceRepository) ProtoMessage()    {}
func (*SourceRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{3}
}

func (m *SourceRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceRepository.Unmarshal(m, b)
}
func (m *SourceRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceRepository.Marshal(b, m, deterministic)
}
func (m *SourceRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceRepository.Merge(m, src)
}
func (m *SourceRepository) XXX_Size() int {
	return xxx_messageInfo_SourceRepository.Size(m)
}
func (m *SourceRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceRepository.DiscardUnknown(m)
}

var xxx_messageInfo_SourceRepository proto.InternalMessageInfo

func (m *SourceRepository) GetRepositoryUrl() string {
	if m != nil {
		return m.RepositoryUrl
	}
	return ""
}

func (m *SourceRepository) GetSourcePath() string {
	if m != nil {
		return m.SourcePath
	}
	return ""
}

type isSourceRepository_Version interface {
	isSourceRepository_Version()
}

type SourceRepository_Branch struct {
	Branch string `protobuf:"bytes,3,opt,name=branch,proto3,oneof"`
}

type SourceRepository_Tag struct {
	Tag string `protobuf:"bytes,4,opt,name=tag,proto3,oneof"`
}

type SourceRepository_Revision struct {
	Revision string `protobuf:"bytes,5,opt,name=revision,proto3,oneof"`
}

func (*SourceRepository_Branch) isSourceRepository_Version() {}

func (*SourceRepository_Tag) isSourceRepository_Version() {}

func (*SourceRepository_Revision) isSourceRepository_Version() {}

func (m *SourceRepository) GetVersion() isSourceRepository_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *SourceRepository) GetBranch() string {
	if x, ok := m.GetVersion().(*SourceRepository_Branch); ok {
		return x.Branch
	}
	return ""
}

func (m *SourceRepository) GetTag() string {
	if x, ok := m.GetVersion().(*SourceRepository_Tag); ok {
		return x.Tag
	}
	return ""
}

func (m *SourceRepository) GetRevision() string {
	if x, ok := m.GetVersion().(*SourceRepository_Revision); ok {
		return x.Revision
	}
	return ""
}

func (m *SourceRepository) GetDeployedRevision() string {
	if m != nil {
		return m.DeployedRevision
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SourceRepository) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SourceRepository_OneofMarshaler, _SourceRepository_OneofUnmarshaler, _SourceRepository_OneofSizer, []interface{}{
		(*SourceRepository_Branch)(nil),
		(*SourceRepository_Tag)(nil),
		(*SourceRepository_Revision)(nil),
	}
}

func _SourceRepository_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SourceRepository)
	// version
	switch x := m.Version.(type) {
	case *SourceRepository_Branch:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Branch)
	case *SourceRepository_Tag:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Tag)
	case *SourceRepository_Revision:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Revision)
	case nil:
	default:
		return fmt.Errorf("SourceRepository.Version has unexpected type %T", x)
	}
	return nil
}

func _SourceRepository_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SourceRepository)
	switch tag {
	case 3: // version.branch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Branch{x}
		return true, err
	case 4: // version.tag
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Tag{x}
		return true, err
	case 5: // version.revision
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Revision{x}
		return true, err
	default:
		return false, nil
	}
}

func _SourceRepository_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SourceRepository)
	// version
	switch x := m.Version.(type) {
	case *SourceRepository_Branch:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Branch)))
		n += len(x.Branch)
	case *SourceRepository_Tag:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Tag)))
		n += len(x.Tag)
	case *SourceRepository_Revision:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Revision)))
		n += len(x.Revision)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request for the `CreateFunction` method.
type CreateFunctionRequest struct {
	// The project and location in which the function should be created, specified
	// in the format `projects/*/locations/*`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Function to be created.
	Function             *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateFunctionRequest) Reset()         { *m = CreateFunctionRequest{} }
func (m *CreateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFunctionRequest) ProtoMessage()    {}
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{4}
}

func (m *CreateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFunctionRequest.Unmarshal(m, b)
}
func (m *CreateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *CreateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFunctionRequest.Merge(m, src)
}
func (m *CreateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFunctionRequest.Size(m)
}
func (m *CreateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFunctionRequest proto.InternalMessageInfo

func (m *CreateFunctionRequest) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *CreateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the `UpdateFunction` method.
type UpdateFunctionRequest struct {
	// The name of the function to be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// New version of the function.
	Function             *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateFunctionRequest) Reset()         { *m = UpdateFunctionRequest{} }
func (m *UpdateFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFunctionRequest) ProtoMessage()    {}
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{5}
}

func (m *UpdateFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFunctionRequest.Unmarshal(m, b)
}
func (m *UpdateFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFunctionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFunctionRequest.Merge(m, src)
}
func (m *UpdateFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFunctionRequest.Size(m)
}
func (m *UpdateFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFunctionRequest proto.InternalMessageInfo

func (m *UpdateFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the `GetFunction` method.
type GetFunctionRequest struct {
	// The name of the function which details should be obtained.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFunctionRequest) Reset()         { *m = GetFunctionRequest{} }
func (m *GetFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*GetFunctionRequest) ProtoMessage()    {}
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{6}
}

func (m *GetFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFunctionRequest.Unmarshal(m, b)
}
func (m *GetFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFunctionRequest.Marshal(b, m, deterministic)
}
func (m *GetFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFunctionRequest.Merge(m, src)
}
func (m *GetFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_GetFunctionRequest.Size(m)
}
func (m *GetFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFunctionRequest proto.InternalMessageInfo

func (m *GetFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `ListFunctions` method.
type ListFunctionsRequest struct {
	// The project and location from which the function should be listed,
	// specified in the format `projects/*/locations/*`
	// If you want to list functions in all locations, use "-" in place of a
	// location.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Maximum number of functions to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListFunctionsResponse`; indicates that
	// this is a continuation of a prior `ListFunctions` call, and that the
	// system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsRequest) Reset()         { *m = ListFunctionsRequest{} }
func (m *ListFunctionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsRequest) ProtoMessage()    {}
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{7}
}

func (m *ListFunctionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsRequest.Unmarshal(m, b)
}
func (m *ListFunctionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsRequest.Marshal(b, m, deterministic)
}
func (m *ListFunctionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsRequest.Merge(m, src)
}
func (m *ListFunctionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsRequest.Size(m)
}
func (m *ListFunctionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsRequest proto.InternalMessageInfo

func (m *ListFunctionsRequest) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ListFunctionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFunctionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListFunctions` method.
type ListFunctionsResponse struct {
	// The functions that match the request.
	Functions []*CloudFunction `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// If not empty, indicates that there may be more functions that match
	// the request; this value should be passed in a new
	// [google.cloud.functions.v1beta2.ListFunctionsRequest][]
	// to get more functions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFunctionsResponse) Reset()         { *m = ListFunctionsResponse{} }
func (m *ListFunctionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFunctionsResponse) ProtoMessage()    {}
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{8}
}

func (m *ListFunctionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFunctionsResponse.Unmarshal(m, b)
}
func (m *ListFunctionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFunctionsResponse.Marshal(b, m, deterministic)
}
func (m *ListFunctionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFunctionsResponse.Merge(m, src)
}
func (m *ListFunctionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFunctionsResponse.Size(m)
}
func (m *ListFunctionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFunctionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFunctionsResponse proto.InternalMessageInfo

func (m *ListFunctionsResponse) GetFunctions() []*CloudFunction {
	if m != nil {
		return m.Functions
	}
	return nil
}

func (m *ListFunctionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `DeleteFunction` method.
type DeleteFunctionRequest struct {
	// The name of the function which should be deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFunctionRequest) Reset()         { *m = DeleteFunctionRequest{} }
func (m *DeleteFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFunctionRequest) ProtoMessage()    {}
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{9}
}

func (m *DeleteFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFunctionRequest.Unmarshal(m, b)
}
func (m *DeleteFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFunctionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFunctionRequest.Merge(m, src)
}
func (m *DeleteFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFunctionRequest.Size(m)
}
func (m *DeleteFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFunctionRequest proto.InternalMessageInfo

func (m *DeleteFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `CallFunction` method.
type CallFunctionRequest struct {
	// The name of the function to be called.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Input to be passed to the function.
	Data                 string   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CallFunctionRequest) Reset()         { *m = CallFunctionRequest{} }
func (m *CallFunctionRequest) String() string { return proto.CompactTextString(m) }
func (*CallFunctionRequest) ProtoMessage()    {}
func (*CallFunctionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{10}
}

func (m *CallFunctionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallFunctionRequest.Unmarshal(m, b)
}
func (m *CallFunctionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallFunctionRequest.Marshal(b, m, deterministic)
}
func (m *CallFunctionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallFunctionRequest.Merge(m, src)
}
func (m *CallFunctionRequest) XXX_Size() int {
	return xxx_messageInfo_CallFunctionRequest.Size(m)
}
func (m *CallFunctionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CallFunctionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CallFunctionRequest proto.InternalMessageInfo

func (m *CallFunctionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CallFunctionRequest) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

// Response of `CallFunction` method.
type CallFunctionResponse struct {
	// Execution id of function invocation.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// Result populated for successful execution of synchronous function. Will
	// not be populated if function does not return a result through context.
	Result string `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Either system or user-function generated error. Set if execution
	// was not successful.
	Error                string   `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CallFunctionResponse) Reset()         { *m = CallFunctionResponse{} }
func (m *CallFunctionResponse) String() string { return proto.CompactTextString(m) }
func (*CallFunctionResponse) ProtoMessage()    {}
func (*CallFunctionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_61af63f3568f8edb, []int{11}
}

func (m *CallFunctionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallFunctionResponse.Unmarshal(m, b)
}
func (m *CallFunctionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallFunctionResponse.Marshal(b, m, deterministic)
}
func (m *CallFunctionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallFunctionResponse.Merge(m, src)
}
func (m *CallFunctionResponse) XXX_Size() int {
	return xxx_messageInfo_CallFunctionResponse.Size(m)
}
func (m *CallFunctionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CallFunctionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CallFunctionResponse proto.InternalMessageInfo

func (m *CallFunctionResponse) GetExecutionId() string {
	if m != nil {
		return m.ExecutionId
	}
	return ""
}

func (m *CallFunctionResponse) GetResult() string {
	if m != nil {
		return m.Result
	}
	return ""
}

func (m *CallFunctionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func init() {
	proto.RegisterType((*CloudFunction)(nil), "google.cloud.functions.v1beta2.CloudFunction")
	proto.RegisterType((*HTTPSTrigger)(nil), "google.cloud.functions.v1beta2.HTTPSTrigger")
	proto.RegisterType((*EventTrigger)(nil), "google.cloud.functions.v1beta2.EventTrigger")
	proto.RegisterType((*SourceRepository)(nil), "google.cloud.functions.v1beta2.SourceRepository")
	proto.RegisterType((*CreateFunctionRequest)(nil), "google.cloud.functions.v1beta2.CreateFunctionRequest")
	proto.RegisterType((*UpdateFunctionRequest)(nil), "google.cloud.functions.v1beta2.UpdateFunctionRequest")
	proto.RegisterType((*GetFunctionRequest)(nil), "google.cloud.functions.v1beta2.GetFunctionRequest")
	proto.RegisterType((*ListFunctionsRequest)(nil), "google.cloud.functions.v1beta2.ListFunctionsRequest")
	proto.RegisterType((*ListFunctionsResponse)(nil), "google.cloud.functions.v1beta2.ListFunctionsResponse")
	proto.RegisterType((*DeleteFunctionRequest)(nil), "google.cloud.functions.v1beta2.DeleteFunctionRequest")
	proto.RegisterType((*CallFunctionRequest)(nil), "google.cloud.functions.v1beta2.CallFunctionRequest")
	proto.RegisterType((*CallFunctionResponse)(nil), "google.cloud.functions.v1beta2.CallFunctionResponse")
	proto.RegisterEnum("google.cloud.functions.v1beta2.CloudFunctionStatus", CloudFunctionStatus_name, CloudFunctionStatus_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudFunctionsServiceClient is the client API for CloudFunctionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Invokes synchronously deployed function. To be used for testing, very
	// limited traffic allowed.
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc *grpc.ClientConn
}

func NewCloudFunctionsServiceClient(cc *grpc.ClientConn) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFunctionsServiceServer is the server API for CloudFunctionsService service.
type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunning.Operation, error)
	// Invokes synchronously deployed function. To be used for testing, very
	// limited traffic allowed.
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
}

func RegisterCloudFunctionsServiceServer(s *grpc.Server, srv CloudFunctionsServiceServer) {
	s.RegisterService(&_CloudFunctionsService_serviceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFunctionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1beta2.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v1beta2/functions.proto",
}

func init() {
	proto.RegisterFile("google/cloud/functions/v1beta2/functions.proto", fileDescriptor_61af63f3568f8edb)
}

var fileDescriptor_61af63f3568f8edb = []byte{
	// 1216 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x4d, 0x73, 0xdb, 0x44,
	0x18, 0xae, 0xf2, 0xe1, 0xc6, 0xaf, 0x3f, 0xe2, 0x6e, 0x9b, 0x8e, 0x30, 0x2d, 0x0d, 0x62, 0x80,
	0x90, 0x82, 0x0d, 0x6e, 0x80, 0x99, 0x7e, 0x30, 0x24, 0xb1, 0x93, 0x78, 0x9a, 0xb6, 0x1e, 0xd9,
	0x39, 0x94, 0x8b, 0x66, 0x2d, 0x6f, 0x15, 0x81, 0xac, 0x15, 0xab, 0x95, 0xa7, 0x29, 0x53, 0x0e,
	0xcc, 0x70, 0xe3, 0xc6, 0x3f, 0xe8, 0x99, 0xe1, 0x07, 0x30, 0xc3, 0x9d, 0x3b, 0x57, 0x86, 0x13,
	0x3f, 0x84, 0xd9, 0xd5, 0x4a, 0x96, 0x93, 0x14, 0x25, 0x19, 0x6e, 0xda, 0xe7, 0xfd, 0x7a, 0x76,
	0xdf, 0x67, 0x5f, 0xaf, 0xa1, 0xe1, 0x50, 0xea, 0x78, 0xa4, 0x69, 0x7b, 0x34, 0x1a, 0x35, 0x9f,
	0x45, 0xbe, 0xcd, 0x5d, 0xea, 0x87, 0xcd, 0xc9, 0x27, 0x43, 0xc2, 0x71, 0x6b, 0x8a, 0x34, 0x02,
	0x46, 0x39, 0x45, 0x6f, 0xc5, 0xfe, 0x0d, 0xe9, 0xdf, 0x98, 0x5a, 0x95, 0x7f, 0xfd, 0x86, 0xca,
	0x87, 0x03, 0xb7, 0x89, 0x7d, 0x9f, 0x72, 0x9c, 0x89, 0xae, 0xaf, 0x64, 0xad, 0x11, 0x3f, 0x54,
	0x70, 0x33, 0x87, 0x04, 0x0d, 0x08, 0x9b, 0xc9, 0xf3, 0x8e, 0x0a, 0xf0, 0xa8, 0xef, 0xb0, 0xc8,
	0xf7, 0x5d, 0xdf, 0x39, 0xe9, 0xa4, 0xa8, 0x36, 0xe5, 0x6a, 0x18, 0x3d, 0x6b, 0x8e, 0xa2, 0xd8,
	0x41, 0xd9, 0x6f, 0x1d, 0xb7, 0x73, 0x77, 0x4c, 0x42, 0x8e, 0xc7, 0x41, 0xec, 0x60, 0xfc, 0xb5,
	0x08, 0x95, 0x6d, 0x41, 0x69, 0x47, 0x31, 0x42, 0x08, 0x16, 0x7c, 0x3c, 0x26, 0xba, 0xb6, 0xaa,
	0xad, 0x15, 0x4d, 0xf9, 0x8d, 0x1a, 0x80, 0x42, 0x1a, 0x31, 0x9b, 0x58, 0x98, 0xd9, 0x87, 0xee,
	0x84, 0x58, 0x11, 0xf3, 0xf4, 0xaa, 0xf0, 0xd8, 0xbb, 0x64, 0xd6, 0x62, 0xdb, 0x66, 0x6c, 0x3a,
	0x60, 0x1e, 0xb2, 0xe0, 0x8a, 0xf2, 0x67, 0x24, 0xa0, 0xa1, 0xcb, 0x29, 0x3b, 0xd2, 0xe7, 0x57,
	0xb5, 0xb5, 0x52, 0xeb, 0xe3, 0xc6, 0x7f, 0x9f, 0x6e, 0xa3, 0x2f, 0x03, 0xcd, 0x34, 0x6e, 0x5a,
	0x60, 0x8a, 0xa1, 0x3e, 0x54, 0x0e, 0x39, 0x0f, 0x42, 0x8b, 0x33, 0xd7, 0x71, 0x08, 0xd3, 0x0b,
	0x32, 0xf9, 0x87, 0x79, 0xc9, 0xf7, 0x06, 0x83, 0x5e, 0x7f, 0x10, 0xc7, 0xec, 0x69, 0x66, 0x59,
	0x26, 0x51, 0x6b, 0x91, 0x94, 0x4c, 0x88, 0xcf, 0xd3, 0xa4, 0xe5, 0xb3, 0x25, 0xed, 0x88, 0xa0,
	0x4c, 0x52, 0x92, 0x59, 0xa3, 0x87, 0x50, 0x08, 0x39, 0xe6, 0x51, 0xa8, 0x5f, 0x5e, 0xd5, 0xd6,
	0xaa, 0xad, 0x3b, 0x79, 0xd9, 0x66, 0xba, 0xd1, 0x97, 0xa1, 0xa6, 0x4a, 0x81, 0x3e, 0x80, 0x9a,
	0x87, 0x39, 0x09, 0xb9, 0x95, 0x2a, 0x41, 0x5f, 0x92, 0x7d, 0x5a, 0x8e, 0xf1, 0x27, 0x09, 0x8c,
	0x6e, 0x41, 0x89, 0xf8, 0x9c, 0x1d, 0x59, 0x01, 0x75, 0x7d, 0xae, 0x17, 0xa5, 0x17, 0x48, 0xa8,
	0x27, 0x10, 0x74, 0x07, 0x2e, 0x0b, 0x31, 0xd0, 0x88, 0xeb, 0x20, 0xf7, 0xf9, 0x46, 0xc2, 0x2c,
	0x11, 0x4b, 0xa3, 0xad, 0xc4, 0x64, 0x26, 0x9e, 0xa8, 0x01, 0x57, 0xf1, 0x04, 0xbb, 0x1e, 0x1e,
	0x7a, 0xc4, 0x1a, 0x93, 0x31, 0x65, 0x47, 0xd6, 0x78, 0xa8, 0x97, 0x56, 0xb5, 0xb5, 0x45, 0xf3,
	0x4a, 0x6a, 0x7a, 0x24, 0x2d, 0x8f, 0x86, 0xe8, 0x7d, 0x58, 0x0e, 0x09, 0x9b, 0xb8, 0x42, 0x39,
	0xb6, 0x4d, 0x23, 0x9f, 0xeb, 0x15, 0xc9, 0xa4, 0xaa, 0xe0, 0xcd, 0x18, 0x45, 0xf7, 0xa0, 0x14,
	0x05, 0x23, 0xcc, 0x89, 0x25, 0x4a, 0xe9, 0xcb, 0x92, 0x51, 0xfd, 0x04, 0xa3, 0x41, 0x22, 0x5f,
	0x13, 0x62, 0x77, 0x01, 0x6c, 0x55, 0xa0, 0xa4, 0xe4, 0x66, 0xd3, 0x11, 0xd9, 0x2a, 0xc2, 0x65,
	0xd5, 0x41, 0x63, 0x15, 0xca, 0xd9, 0x96, 0xa3, 0x1a, 0xcc, 0x0b, 0xe5, 0xc6, 0xda, 0x16, 0x9f,
	0x46, 0x17, 0xca, 0xd9, 0xfe, 0xa1, 0x9b, 0x00, 0x4a, 0x04, 0x47, 0x41, 0x72, 0x09, 0x8a, 0x71,
	0x47, 0x8f, 0x02, 0x82, 0xea, 0xb0, 0xc4, 0x48, 0x5c, 0x4c, 0x9f, 0x93, 0xc6, 0x74, 0x6d, 0xfc,
	0xad, 0x41, 0xed, 0xb8, 0x7a, 0xd1, 0xbb, 0x50, 0x9d, 0xde, 0x01, 0x6b, 0x5a, 0xbc, 0x32, 0x45,
	0xc5, 0x8d, 0xb9, 0x95, 0x6e, 0x21, 0xc0, 0xfc, 0x50, 0xa5, 0x86, 0x18, 0xea, 0x61, 0x7e, 0x88,
	0x74, 0x28, 0x0c, 0x19, 0xf6, 0xed, 0x43, 0x79, 0x8f, 0xc4, 0xb5, 0x53, 0x6b, 0x84, 0x60, 0x9e,
	0x63, 0x47, 0x5f, 0x50, 0xb0, 0x58, 0xa0, 0x1b, 0x82, 0xe6, 0xc4, 0x0d, 0x85, 0x40, 0x16, 0x95,
	0x21, 0x45, 0xd0, 0x6d, 0xb8, 0x32, 0x22, 0x81, 0x47, 0x8f, 0xc8, 0xc8, 0x4a, 0xdd, 0x0a, 0xb2,
	0x64, 0x2d, 0x31, 0x98, 0x0a, 0x17, 0xa7, 0x39, 0x21, 0x4c, 0x7c, 0x1a, 0xdf, 0xc3, 0xca, 0x36,
	0x23, 0x98, 0x93, 0x44, 0x9e, 0x26, 0xf9, 0x36, 0x22, 0x21, 0x17, 0xa7, 0xe2, 0x51, 0x3b, 0xd6,
	0x63, 0xbc, 0xbd, 0x74, 0x8d, 0xba, 0xb0, 0x94, 0x88, 0x5c, 0x6e, 0xab, 0xd4, 0xfa, 0xe8, 0x5c,
	0x57, 0xc0, 0x4c, 0xc3, 0x8d, 0x09, 0xac, 0x1c, 0xc8, 0xae, 0x1f, 0xaf, 0x7f, 0xda, 0xcc, 0xfa,
	0x1f, 0xeb, 0xae, 0x01, 0xda, 0x25, 0xfc, 0x0c, 0x45, 0x0d, 0x1f, 0xae, 0xed, 0xbb, 0x61, 0xea,
	0x1a, 0x9e, 0xe5, 0x80, 0xde, 0x84, 0x62, 0x80, 0x1d, 0x62, 0x85, 0xee, 0x8b, 0x58, 0x53, 0x8b,
	0xe6, 0x92, 0x00, 0xfa, 0xee, 0x0b, 0x22, 0xe4, 0x28, 0x8d, 0x9c, 0x7e, 0x43, 0xfc, 0xb8, 0xf5,
	0xa6, 0x74, 0x1f, 0x08, 0xc0, 0xf8, 0x49, 0x83, 0x95, 0x63, 0x05, 0xc3, 0x80, 0xfa, 0x21, 0x41,
	0x0f, 0xa1, 0x98, 0x6e, 0x50, 0xd7, 0x56, 0xe7, 0xcf, 0xbf, 0xff, 0x69, 0x3c, 0x7a, 0x0f, 0x96,
	0x7d, 0xf2, 0x9c, 0x5b, 0x19, 0x2a, 0xb1, 0x42, 0x2b, 0x02, 0xee, 0xa5, 0x74, 0x6e, 0xc3, 0x4a,
	0x9b, 0x78, 0xe4, 0x4c, 0x0d, 0x32, 0x1e, 0xc0, 0xd5, 0x6d, 0xec, 0x79, 0x67, 0xe9, 0x25, 0x82,
	0x85, 0x11, 0xe6, 0x58, 0x15, 0x95, 0xdf, 0x86, 0x03, 0xd7, 0x66, 0xc3, 0xd5, 0xc6, 0xdf, 0x86,
	0x32, 0x79, 0x4e, 0xec, 0x48, 0x80, 0x96, 0x3b, 0x52, 0x79, 0x4a, 0x29, 0xd6, 0x1d, 0xa1, 0xeb,
	0x50, 0x60, 0x24, 0x8c, 0x3c, 0xae, 0x12, 0xaa, 0x15, 0xba, 0x06, 0x8b, 0x84, 0x31, 0xca, 0xd4,
	0x39, 0xc7, 0x8b, 0x75, 0x0c, 0x57, 0x4f, 0x99, 0xc9, 0xe8, 0x3a, 0xa0, 0xfe, 0x60, 0x73, 0x70,
	0xd0, 0xb7, 0x0e, 0x1e, 0xf7, 0x7b, 0x9d, 0xed, 0xee, 0x4e, 0xb7, 0xd3, 0xae, 0x5d, 0x42, 0x45,
	0x58, 0x34, 0x3b, 0x9b, 0xed, 0xa7, 0x35, 0x0d, 0x01, 0x14, 0x76, 0x36, 0xbb, 0xfb, 0x9d, 0x76,
	0x6d, 0x0e, 0x55, 0xa0, 0xd8, 0xee, 0xf4, 0xf6, 0x9f, 0x3c, 0xed, 0x3e, 0xde, 0xad, 0xcd, 0xa3,
	0x32, 0x2c, 0xb5, 0x3b, 0xfb, 0x9d, 0x81, 0x58, 0x2d, 0xb4, 0xfe, 0x58, 0x82, 0x95, 0x99, 0x1a,
	0x61, 0x3f, 0x1e, 0x8f, 0xe8, 0x37, 0x0d, 0x2a, 0x33, 0x0d, 0x46, 0x1b, 0x79, 0x5d, 0x3c, 0x4d,
	0x80, 0xf5, 0x4f, 0xcf, 0x19, 0x15, 0x1f, 0xa6, 0x71, 0xff, 0x87, 0x3f, 0xff, 0xf9, 0x79, 0xee,
	0x33, 0xb4, 0x91, 0xbe, 0x53, 0xbe, 0x4b, 0x74, 0xfb, 0x20, 0x60, 0xf4, 0x6b, 0x62, 0xf3, 0xb0,
	0xb9, 0xde, 0x4c, 0xb0, 0xb0, 0xb9, 0xfe, 0x72, 0xfa, 0xb6, 0x41, 0xbf, 0x68, 0x50, 0xca, 0x5c,
	0x1c, 0xd4, 0xca, 0x23, 0x71, 0xf2, 0x96, 0xd5, 0xcf, 0x27, 0x5a, 0xe3, 0xae, 0x24, 0xbc, 0x81,
	0x5a, 0x53, 0xc2, 0x42, 0x41, 0xaf, 0x21, 0x9b, 0x79, 0x87, 0xad, 0xbf, 0x44, 0xbf, 0x6a, 0x50,
	0x9d, 0x9d, 0x6f, 0x28, 0xf7, 0xd8, 0x4e, 0x9d, 0x87, 0xf5, 0x9b, 0x49, 0x58, 0xe6, 0xf1, 0xd6,
	0x48, 0x7f, 0x9b, 0x8d, 0x1d, 0x49, 0xf2, 0x4b, 0xe3, 0x42, 0xa7, 0x7a, 0x37, 0x9d, 0x4b, 0xe2,
	0x7c, 0xab, 0xb3, 0x03, 0x31, 0x9f, 0xf0, 0xa9, 0x03, 0x34, 0x8f, 0x70, 0x5b, 0x12, 0xfe, 0xa2,
	0x7e, 0x81, 0x53, 0xcd, 0xd0, 0x7d, 0xa5, 0x41, 0x75, 0x76, 0x3c, 0xe4, 0xd3, 0x3d, 0x75, 0x9c,
	0xe4, 0xd1, 0x55, 0x22, 0x58, 0xbf, 0x88, 0x08, 0x7e, 0xd7, 0xa0, 0x9c, 0x9d, 0x2b, 0x28, 0xff,
	0xc1, 0x76, 0x72, 0x88, 0xd5, 0x37, 0xce, 0x17, 0xa4, 0x6e, 0xdb, 0x96, 0xe4, 0x7d, 0xdf, 0xf8,
	0xfc, 0x02, 0xc7, 0x6c, 0x63, 0xcf, 0xbb, 0xab, 0xad, 0x6f, 0xfd, 0xa8, 0x81, 0x61, 0xd3, 0x71,
	0x4e, 0xfd, 0xad, 0x6a, 0x7a, 0xd7, 0x7b, 0xe2, 0x6d, 0xd5, 0xd3, 0xbe, 0xda, 0x55, 0x11, 0x0e,
	0xf5, 0xb0, 0xef, 0x34, 0x28, 0x73, 0x9a, 0x0e, 0xf1, 0xe5, 0xcb, 0x4b, 0xfd, 0x77, 0xc1, 0x81,
	0x1b, 0xbe, 0xee, 0xff, 0xcb, 0xbd, 0x14, 0x79, 0x35, 0x37, 0xbf, 0xbb, 0xbd, 0x33, 0x2c, 0xc8,
	0xc8, 0x3b, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x22, 0xa1, 0xda, 0x9f, 0x7d, 0x0d, 0x00, 0x00,
}
