package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveMultipleStreamMixService invokes the live.RemoveMultipleStreamMixService API synchronously
// api document: https://help.aliyun.com/api/live/removemultiplestreammixservice.html
func (client *Client) RemoveMultipleStreamMixService(request *RemoveMultipleStreamMixServiceRequest) (response *RemoveMultipleStreamMixServiceResponse, err error) {
	response = CreateRemoveMultipleStreamMixServiceResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveMultipleStreamMixServiceWithChan invokes the live.RemoveMultipleStreamMixService API asynchronously
// api document: https://help.aliyun.com/api/live/removemultiplestreammixservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveMultipleStreamMixServiceWithChan(request *RemoveMultipleStreamMixServiceRequest) (<-chan *RemoveMultipleStreamMixServiceResponse, <-chan error) {
	responseChan := make(chan *RemoveMultipleStreamMixServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveMultipleStreamMixService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveMultipleStreamMixServiceWithCallback invokes the live.RemoveMultipleStreamMixService API asynchronously
// api document: https://help.aliyun.com/api/live/removemultiplestreammixservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveMultipleStreamMixServiceWithCallback(request *RemoveMultipleStreamMixServiceRequest, callback func(response *RemoveMultipleStreamMixServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveMultipleStreamMixServiceResponse
		var err error
		defer close(result)
		response, err = client.RemoveMultipleStreamMixService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveMultipleStreamMixServiceRequest is the request struct for api RemoveMultipleStreamMixService
type RemoveMultipleStreamMixServiceRequest struct {
	*requests.RpcRequest
	AppName       string           `position:"Query" name:"AppName"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	MixStreamName string           `position:"Query" name:"MixStreamName"`
	MixDomainName string           `position:"Query" name:"MixDomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	MixAppName    string           `position:"Query" name:"MixAppName"`
	StreamName    string           `position:"Query" name:"StreamName"`
}

// RemoveMultipleStreamMixServiceResponse is the response struct for api RemoveMultipleStreamMixService
type RemoveMultipleStreamMixServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveMultipleStreamMixServiceRequest creates a request to invoke RemoveMultipleStreamMixService API
func CreateRemoveMultipleStreamMixServiceRequest() (request *RemoveMultipleStreamMixServiceRequest) {
	request = &RemoveMultipleStreamMixServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RemoveMultipleStreamMixService", "live", "openAPI")
	return
}

// CreateRemoveMultipleStreamMixServiceResponse creates a response to parse from RemoveMultipleStreamMixService response
func CreateRemoveMultipleStreamMixServiceResponse() (response *RemoveMultipleStreamMixServiceResponse) {
	response = &RemoveMultipleStreamMixServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
