package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumConfig invokes the baas.DescribeConsortiumConfig API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumconfig.html
func (client *Client) DescribeConsortiumConfig(request *DescribeConsortiumConfigRequest) (response *DescribeConsortiumConfigResponse, err error) {
	response = CreateDescribeConsortiumConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumConfigWithChan invokes the baas.DescribeConsortiumConfig API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumConfigWithChan(request *DescribeConsortiumConfigRequest) (<-chan *DescribeConsortiumConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumConfigWithCallback invokes the baas.DescribeConsortiumConfig API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumConfigWithCallback(request *DescribeConsortiumConfigRequest, callback func(response *DescribeConsortiumConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumConfigRequest is the request struct for api DescribeConsortiumConfig
type DescribeConsortiumConfigRequest struct {
	*requests.RpcRequest
}

// DescribeConsortiumConfigResponse is the response struct for api DescribeConsortiumConfig
type DescribeConsortiumConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumConfigRequest creates a request to invoke DescribeConsortiumConfig API
func CreateDescribeConsortiumConfigRequest() (request *DescribeConsortiumConfigRequest) {
	request = &DescribeConsortiumConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumConfig", "", "")
	return
}

// CreateDescribeConsortiumConfigResponse creates a response to parse from DescribeConsortiumConfig response
func CreateDescribeConsortiumConfigResponse() (response *DescribeConsortiumConfigResponse) {
	response = &DescribeConsortiumConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
