package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySystemEventDetail invokes the cms.QuerySystemEventDetail API synchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdetail.html
func (client *Client) QuerySystemEventDetail(request *QuerySystemEventDetailRequest) (response *QuerySystemEventDetailResponse, err error) {
	response = CreateQuerySystemEventDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySystemEventDetailWithChan invokes the cms.QuerySystemEventDetail API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventDetailWithChan(request *QuerySystemEventDetailRequest) (<-chan *QuerySystemEventDetailResponse, <-chan error) {
	responseChan := make(chan *QuerySystemEventDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySystemEventDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySystemEventDetailWithCallback invokes the cms.QuerySystemEventDetail API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventDetailWithCallback(request *QuerySystemEventDetailRequest, callback func(response *QuerySystemEventDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySystemEventDetailResponse
		var err error
		defer close(result)
		response, err = client.QuerySystemEventDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySystemEventDetailRequest is the request struct for api QuerySystemEventDetail
type QuerySystemEventDetailRequest struct {
	*requests.RpcRequest
	QueryJson string `position:"Query" name:"QueryJson"`
}

// QuerySystemEventDetailResponse is the response struct for api QuerySystemEventDetail
type QuerySystemEventDetailResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateQuerySystemEventDetailRequest creates a request to invoke QuerySystemEventDetail API
func CreateQuerySystemEventDetailRequest() (request *QuerySystemEventDetailRequest) {
	request = &QuerySystemEventDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QuerySystemEventDetail", "cms", "openAPI")
	return
}

// CreateQuerySystemEventDetailResponse creates a response to parse from QuerySystemEventDetail response
func CreateQuerySystemEventDetailResponse() (response *QuerySystemEventDetailResponse) {
	response = &QuerySystemEventDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
