package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEnterpriseCustomInfo invokes the finmall.UpdateEnterpriseCustomInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/updateenterprisecustominfo.html
func (client *Client) UpdateEnterpriseCustomInfo(request *UpdateEnterpriseCustomInfoRequest) (response *UpdateEnterpriseCustomInfoResponse, err error) {
	response = CreateUpdateEnterpriseCustomInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEnterpriseCustomInfoWithChan invokes the finmall.UpdateEnterpriseCustomInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/updateenterprisecustominfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEnterpriseCustomInfoWithChan(request *UpdateEnterpriseCustomInfoRequest) (<-chan *UpdateEnterpriseCustomInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateEnterpriseCustomInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEnterpriseCustomInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEnterpriseCustomInfoWithCallback invokes the finmall.UpdateEnterpriseCustomInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/updateenterprisecustominfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEnterpriseCustomInfoWithCallback(request *UpdateEnterpriseCustomInfoRequest, callback func(response *UpdateEnterpriseCustomInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEnterpriseCustomInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateEnterpriseCustomInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEnterpriseCustomInfoRequest is the request struct for api UpdateEnterpriseCustomInfo
type UpdateEnterpriseCustomInfoRequest struct {
	*requests.RpcRequest
	IdCardNumber    string `position:"Query" name:"IdCardNumber"`
	Address         string `position:"Query" name:"Address"`
	IdCardFrontPage string `position:"Query" name:"IdCardFrontPage"`
	PhoneNumber     string `position:"Query" name:"PhoneNumber"`
	BusinessLicense string `position:"Query" name:"BusinessLicense"`
	IdCardBackPage  string `position:"Query" name:"IdCardBackPage"`
	LegalPersonName string `position:"Query" name:"LegalPersonName"`
	EnterpriseName  string `position:"Query" name:"EnterpriseName"`
	UserId          string `position:"Query" name:"UserId"`
	LoanSubject     string `position:"Query" name:"LoanSubject"`
	ZhimaReturnUrl  string `position:"Query" name:"ZhimaReturnUrl"`
	SmsIvToken      string `position:"Query" name:"SmsIvToken"`
	BankCard        string `position:"Query" name:"BankCard"`
	Email           string `position:"Query" name:"Email"`
}

// UpdateEnterpriseCustomInfoResponse is the response struct for api UpdateEnterpriseCustomInfo
type UpdateEnterpriseCustomInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUpdateEnterpriseCustomInfoRequest creates a request to invoke UpdateEnterpriseCustomInfo API
func CreateUpdateEnterpriseCustomInfoRequest() (request *UpdateEnterpriseCustomInfoRequest) {
	request = &UpdateEnterpriseCustomInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "UpdateEnterpriseCustomInfo", "finmall", "openAPI")
	return
}

// CreateUpdateEnterpriseCustomInfoResponse creates a response to parse from UpdateEnterpriseCustomInfo response
func CreateUpdateEnterpriseCustomInfoResponse() (response *UpdateEnterpriseCustomInfoResponse) {
	response = &UpdateEnterpriseCustomInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
