# vim:set ft= ts=4 sw=4 et fdm=marker:

use Test::Nginx::Socket::Lua::Stream;
repeat_each(2);

plan tests => repeat_each() * (blocks() * 3);

our $HtmlDir = html_dir;

#$ENV{TEST_NGINX_MEMCACHED_PORT} ||= 11211;

no_long_string();
#no_diff();
#log_level 'warn';

run_tests();

__DATA__

=== TEST 1: sanity
--- stream_server_config
    preread_by_lua_block {
        local sock, err = ngx.req.socket()
        if sock then
            ngx.say("got the request socket")
        else
            ngx.say("failed to get the request socket: ", err)
        end

        for i = 1, 2 do
            local data, err, part = sock:receive(5)
            if data then
                ngx.say("received: ", data)
            else
                ngx.say("failed to receive: ", err, " [", part, "]")
            end
        end

        local data, err, part = sock:receive(1)
        if data then
            ngx.say("received: ", data)
        else
            ngx.say("failed to receive: ", err, " [", part, "]")
            return
        end
    }
    content_by_lua return;
--- stream_request chop
hello world
--- stream_response
got the request socket
received: hello
received:  worl
received: d
--- no_error_log
[error]



=== TEST 4: attempt to use the req socket across request boundary
--- stream_config eval
    "lua_package_path '$::HtmlDir/?.lua;./?.lua';"
--- stream_server_config
    preread_by_lua_block {
        local test = require "test"
        test.go()
        ngx.say("done")
    }
    content_by_lua return;
--- user_files
>>> test.lua
module("test", package.seeall)

local sock, err

function go()
    if not sock then
        sock, err = ngx.req.socket()
        if sock then
            ngx.say("got the request socket")
        else
            ngx.say("failed to get the request socket: ", err)
        end
    else
        for i = 1, 3 do
            local data, err, part = sock:receive(5)
            if data then
                ngx.say("received: ", data)
            else
                ngx.say("failed to receive: ", err, " [", part, "]")
            end
        end
    end
end
--- stream_response_like
(?:got the request socket
|failed to receive: closed [d]
)?done
--- no_error_log
[alert]



=== TEST 5: receive until on request_body - receiveuntil(1) on the last byte of the body
See https://groups.google.com/group/openresty/browse_thread/thread/43cf01da3c681aba for details
--- stream_config eval
    "lua_package_path '$::HtmlDir/?.lua;./?.lua';"
--- stream_server_config
    preread_by_lua_block {
            local test = require "test"
            test.go()
            ngx.say("done")
    }
    content_by_lua return;
--- user_files
>>> test.lua
module("test", package.seeall)

function go()
   local sock, err = ngx.req.socket()
   if sock then
      ngx.say("got the request socket")
   else
      ngx.say("failed to get the request socket: ", err)
      return
   end

   local data, err, part = sock:receive(56)
   if data then
      ngx.say("received: ", data)
   else
      ngx.say("failed to receive: ", err, " [", part, "]")
   end

   local discard_line = sock:receiveuntil('\r\n')

   local data, err, part = discard_line(8192)
   if data then
      ngx.say("received len: ", #data)
   else
      ngx.say("failed to receive: ", err, " [", part, "]")
   end

   local data, err, part = discard_line(1)
   if data then
      ngx.say("received: ", data)
   else
      ngx.say("failed to receive: ", err, " [", part, "]")
   end
end
--- stream_request chop
-----------------------------820127721219505131303151179################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################$
--- stream_response
got the request socket
received: -----------------------------820127721219505131303151179
received len: 8192
received: $
done
--- no_error_log
[error]
--- timeout: 10



=== TEST 6: read from preread buffer
--- stream_server_config
    ssl_preread on;

    preread_by_lua_block {
        local sock, err = ngx.req.socket()
        if sock then
            ngx.say("got the request socket")
        else
            ngx.say("failed to get the request socket: ", err)
            return
        end

        for i = 1, 2 do
            local data, err, part = sock:receive(5)
            if data then
                ngx.say("received: ", data)
            else
                ngx.say("failed to receive: ", err, " [", part, "]")
                return
            end
        end

        local data, err, part = sock:receive(1)
        if data then
            ngx.say("received: ", data)
        else
            ngx.say("failed to receive: ", err, " [", part, "]")
            return
        end
    }
    content_by_lua return;
--- stream_request chop
hello world
--- stream_response
got the request socket
received: hello
received:  worl
received: d
--- no_error_log
[error]



=== TEST 7: small preread buffer
--- stream_server_config
    ssl_preread on;
    preread_buffer_size 5;

    preread_by_lua_block {
        local sock, err = ngx.req.socket()
        if sock then
            ngx.say("got the request socket")
        else
            ngx.say("failed to get the request socket: ", err)
            return
        end

        for i = 1, 2 do
            local data, err, part = sock:receive(5)
            if data then
                ngx.say("received: ", data)
            else
                ngx.say("failed to receive: ", err, " [", part, "]")
                return
            end
        end

        local data, err, part = sock:receive(1)
        if data then
            ngx.say("received: ", data)
        else
            ngx.say("failed to receive: ", err, " [", part, "]")
            return
        end
    }
    content_by_lua return;
--- stream_request chop
hello world
--- stream_response
got the request socket
received: hello
received:  worl
received: d
--- no_error_log
[error]
