// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/binaryauthorization/v1beta1/service.proto

package binaryauthorization

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [BinauthzManagementService.GetPolicy][].
type GetPolicyRequest struct {
	// Required. The resource name of the [policy][google.cloud.binaryauthorization.v1beta1.Policy] to retrieve,
	// in the format `projects/*/policy`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPolicyRequest) Reset()         { *m = GetPolicyRequest{} }
func (m *GetPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetPolicyRequest) ProtoMessage()    {}
func (*GetPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{0}
}

func (m *GetPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPolicyRequest.Unmarshal(m, b)
}
func (m *GetPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPolicyRequest.Merge(m, src)
}
func (m *GetPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetPolicyRequest.Size(m)
}
func (m *GetPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPolicyRequest proto.InternalMessageInfo

func (m *GetPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [BinauthzManagementService.UpdatePolicy][].
type UpdatePolicyRequest struct {
	// Required. A new or updated [policy][google.cloud.binaryauthorization.v1beta1.Policy] value. The service will
	// overwrite the [policy name][google.cloud.binaryauthorization.v1beta1.Policy.name] field with the resource name in
	// the request URL, in the format `projects/*/policy`.
	Policy               *Policy  `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdatePolicyRequest) Reset()         { *m = UpdatePolicyRequest{} }
func (m *UpdatePolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdatePolicyRequest) ProtoMessage()    {}
func (*UpdatePolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{1}
}

func (m *UpdatePolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatePolicyRequest.Unmarshal(m, b)
}
func (m *UpdatePolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatePolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdatePolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatePolicyRequest.Merge(m, src)
}
func (m *UpdatePolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdatePolicyRequest.Size(m)
}
func (m *UpdatePolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatePolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatePolicyRequest proto.InternalMessageInfo

func (m *UpdatePolicyRequest) GetPolicy() *Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// Request message for [BinauthzManagementService.CreateAttestor][].
type CreateAttestorRequest struct {
	// Required. The parent of this [attestor][google.cloud.binaryauthorization.v1beta1.Attestor].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [attestors][google.cloud.binaryauthorization.v1beta1.Attestor] ID.
	AttestorId string `protobuf:"bytes,2,opt,name=attestor_id,json=attestorId,proto3" json:"attestor_id,omitempty"`
	// Required. The initial [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] value. The service will
	// overwrite the [attestor name][google.cloud.binaryauthorization.v1beta1.Attestor.name] field with the resource name,
	// in the format `projects/*/attestors/*`.
	Attestor             *Attestor `protobuf:"bytes,3,opt,name=attestor,proto3" json:"attestor,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateAttestorRequest) Reset()         { *m = CreateAttestorRequest{} }
func (m *CreateAttestorRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAttestorRequest) ProtoMessage()    {}
func (*CreateAttestorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{2}
}

func (m *CreateAttestorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAttestorRequest.Unmarshal(m, b)
}
func (m *CreateAttestorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAttestorRequest.Marshal(b, m, deterministic)
}
func (m *CreateAttestorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAttestorRequest.Merge(m, src)
}
func (m *CreateAttestorRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAttestorRequest.Size(m)
}
func (m *CreateAttestorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAttestorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAttestorRequest proto.InternalMessageInfo

func (m *CreateAttestorRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAttestorRequest) GetAttestorId() string {
	if m != nil {
		return m.AttestorId
	}
	return ""
}

func (m *CreateAttestorRequest) GetAttestor() *Attestor {
	if m != nil {
		return m.Attestor
	}
	return nil
}

// Request message for [BinauthzManagementService.GetAttestor][].
type GetAttestorRequest struct {
	// Required. The name of the [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] to retrieve, in the format
	// `projects/*/attestors/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAttestorRequest) Reset()         { *m = GetAttestorRequest{} }
func (m *GetAttestorRequest) String() string { return proto.CompactTextString(m) }
func (*GetAttestorRequest) ProtoMessage()    {}
func (*GetAttestorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{3}
}

func (m *GetAttestorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAttestorRequest.Unmarshal(m, b)
}
func (m *GetAttestorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAttestorRequest.Marshal(b, m, deterministic)
}
func (m *GetAttestorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAttestorRequest.Merge(m, src)
}
func (m *GetAttestorRequest) XXX_Size() int {
	return xxx_messageInfo_GetAttestorRequest.Size(m)
}
func (m *GetAttestorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAttestorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAttestorRequest proto.InternalMessageInfo

func (m *GetAttestorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [BinauthzManagementService.UpdateAttestor][].
type UpdateAttestorRequest struct {
	// Required. The updated [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] value. The service will
	// overwrite the [attestor name][google.cloud.binaryauthorization.v1beta1.Attestor.name] field with the resource name
	// in the request URL, in the format `projects/*/attestors/*`.
	Attestor             *Attestor `protobuf:"bytes,1,opt,name=attestor,proto3" json:"attestor,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateAttestorRequest) Reset()         { *m = UpdateAttestorRequest{} }
func (m *UpdateAttestorRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAttestorRequest) ProtoMessage()    {}
func (*UpdateAttestorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{4}
}

func (m *UpdateAttestorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAttestorRequest.Unmarshal(m, b)
}
func (m *UpdateAttestorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAttestorRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAttestorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAttestorRequest.Merge(m, src)
}
func (m *UpdateAttestorRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAttestorRequest.Size(m)
}
func (m *UpdateAttestorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAttestorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAttestorRequest proto.InternalMessageInfo

func (m *UpdateAttestorRequest) GetAttestor() *Attestor {
	if m != nil {
		return m.Attestor
	}
	return nil
}

// Request message for [BinauthzManagementService.ListAttestors][].
type ListAttestorsRequest struct {
	// Required. The resource name of the project associated with the
	// [attestors][google.cloud.binaryauthorization.v1beta1.Attestor], in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server may return fewer results than requested. If
	// unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return. Typically,
	// this is the value of [ListAttestorsResponse.next_page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.next_page_token] returned
	// from the previous call to the `ListAttestors` method.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAttestorsRequest) Reset()         { *m = ListAttestorsRequest{} }
func (m *ListAttestorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAttestorsRequest) ProtoMessage()    {}
func (*ListAttestorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{5}
}

func (m *ListAttestorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAttestorsRequest.Unmarshal(m, b)
}
func (m *ListAttestorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAttestorsRequest.Marshal(b, m, deterministic)
}
func (m *ListAttestorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAttestorsRequest.Merge(m, src)
}
func (m *ListAttestorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAttestorsRequest.Size(m)
}
func (m *ListAttestorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAttestorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAttestorsRequest proto.InternalMessageInfo

func (m *ListAttestorsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAttestorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAttestorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [BinauthzManagementService.ListAttestors][].
type ListAttestorsResponse struct {
	// The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
	Attestors []*Attestor `protobuf:"bytes,1,rep,name=attestors,proto3" json:"attestors,omitempty"`
	// A token to retrieve the next page of results. Pass this value in the
	// [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
	// `ListAttestors` method to retrieve the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAttestorsResponse) Reset()         { *m = ListAttestorsResponse{} }
func (m *ListAttestorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAttestorsResponse) ProtoMessage()    {}
func (*ListAttestorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{6}
}

func (m *ListAttestorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAttestorsResponse.Unmarshal(m, b)
}
func (m *ListAttestorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAttestorsResponse.Marshal(b, m, deterministic)
}
func (m *ListAttestorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAttestorsResponse.Merge(m, src)
}
func (m *ListAttestorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAttestorsResponse.Size(m)
}
func (m *ListAttestorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAttestorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAttestorsResponse proto.InternalMessageInfo

func (m *ListAttestorsResponse) GetAttestors() []*Attestor {
	if m != nil {
		return m.Attestors
	}
	return nil
}

func (m *ListAttestorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [BinauthzManagementService.DeleteAttestor][].
type DeleteAttestorRequest struct {
	// Required. The name of the [attestors][google.cloud.binaryauthorization.v1beta1.Attestor] to delete, in the format
	// `projects/*/attestors/*`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAttestorRequest) Reset()         { *m = DeleteAttestorRequest{} }
func (m *DeleteAttestorRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAttestorRequest) ProtoMessage()    {}
func (*DeleteAttestorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5f16bed3f845be4, []int{7}
}

func (m *DeleteAttestorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAttestorRequest.Unmarshal(m, b)
}
func (m *DeleteAttestorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAttestorRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAttestorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAttestorRequest.Merge(m, src)
}
func (m *DeleteAttestorRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAttestorRequest.Size(m)
}
func (m *DeleteAttestorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAttestorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAttestorRequest proto.InternalMessageInfo

func (m *DeleteAttestorRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*GetPolicyRequest)(nil), "google.cloud.binaryauthorization.v1beta1.GetPolicyRequest")
	proto.RegisterType((*UpdatePolicyRequest)(nil), "google.cloud.binaryauthorization.v1beta1.UpdatePolicyRequest")
	proto.RegisterType((*CreateAttestorRequest)(nil), "google.cloud.binaryauthorization.v1beta1.CreateAttestorRequest")
	proto.RegisterType((*GetAttestorRequest)(nil), "google.cloud.binaryauthorization.v1beta1.GetAttestorRequest")
	proto.RegisterType((*UpdateAttestorRequest)(nil), "google.cloud.binaryauthorization.v1beta1.UpdateAttestorRequest")
	proto.RegisterType((*ListAttestorsRequest)(nil), "google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest")
	proto.RegisterType((*ListAttestorsResponse)(nil), "google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse")
	proto.RegisterType((*DeleteAttestorRequest)(nil), "google.cloud.binaryauthorization.v1beta1.DeleteAttestorRequest")
}

func init() {
	proto.RegisterFile("google/cloud/binaryauthorization/v1beta1/service.proto", fileDescriptor_b5f16bed3f845be4)
}

var fileDescriptor_b5f16bed3f845be4 = []byte{
	// 701 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0xcf, 0x4f, 0x13, 0x41,
	0x14, 0xc7, 0x33, 0xa0, 0x84, 0x3e, 0x04, 0xcd, 0x68, 0x49, 0xb3, 0x68, 0xc4, 0x35, 0x69, 0x2a,
	0x26, 0xbb, 0x52, 0x13, 0x43, 0x40, 0x24, 0xa0, 0x06, 0x4d, 0xd4, 0x90, 0xa2, 0x1e, 0xf4, 0x50,
	0xa7, 0xed, 0x73, 0x5d, 0x2c, 0x33, 0xeb, 0xce, 0x94, 0x48, 0x0d, 0x17, 0xff, 0x03, 0xe3, 0xc9,
	0x9b, 0x89, 0xde, 0x3d, 0x7b, 0xd2, 0xa3, 0x77, 0xff, 0x05, 0xff, 0x08, 0x8f, 0x66, 0x67, 0x7f,
	0xb0, 0xad, 0x0b, 0x6c, 0x1b, 0x6e, 0x9d, 0x1f, 0xef, 0xbd, 0xcf, 0x7b, 0xf3, 0xbe, 0x6f, 0x0b,
	0x37, 0x1c, 0x21, 0x9c, 0x36, 0xda, 0xcd, 0xb6, 0xe8, 0xb4, 0xec, 0x86, 0xcb, 0x99, 0xbf, 0xcb,
	0x3a, 0xea, 0x95, 0xf0, 0xdd, 0x2e, 0x53, 0xae, 0xe0, 0xf6, 0xce, 0x7c, 0x03, 0x15, 0x9b, 0xb7,
	0x25, 0xfa, 0x3b, 0x6e, 0x13, 0x2d, 0xcf, 0x17, 0x4a, 0xd0, 0x4a, 0x68, 0x67, 0x69, 0x3b, 0x2b,
	0xc3, 0xce, 0x8a, 0xec, 0x8c, 0xf3, 0x51, 0x04, 0xe6, 0xb9, 0x36, 0xe3, 0x5c, 0x28, 0x7d, 0x2c,
	0x43, 0x3f, 0xc6, 0x42, 0xee, 0xf8, 0x3e, 0x4a, 0xd1, 0xf1, 0x9b, 0x18, 0x5b, 0xce, 0x44, 0x96,
	0x7a, 0xd5, 0xe8, 0xbc, 0xb4, 0x71, 0xdb, 0x53, 0xbb, 0xe1, 0xa1, 0x59, 0x86, 0x33, 0xeb, 0xa8,
	0x36, 0x44, 0xdb, 0x6d, 0xee, 0xd6, 0xf0, 0x4d, 0x07, 0xa5, 0xa2, 0x14, 0x4e, 0x70, 0xb6, 0x8d,
	0x25, 0x32, 0x4b, 0x2a, 0x85, 0x9a, 0xfe, 0x6d, 0xd6, 0xe1, 0xec, 0x13, 0xaf, 0xc5, 0x14, 0xf6,
	0x5e, 0xbd, 0x07, 0x63, 0x9e, 0xde, 0xd0, 0x97, 0x27, 0xaa, 0xd7, 0xac, 0xbc, 0xe9, 0x5a, 0x91,
	0xa3, 0xc8, 0xde, 0xfc, 0x4c, 0xa0, 0x78, 0xdb, 0x47, 0xa6, 0x70, 0x55, 0x29, 0x94, 0x4a, 0xf8,
	0x71, 0x8c, 0x69, 0x18, 0xf3, 0x98, 0x8f, 0x5c, 0x45, 0x40, 0xd1, 0x8a, 0x5e, 0x84, 0x09, 0x16,
	0x5d, 0xad, 0xbb, 0xad, 0xd2, 0x88, 0x3e, 0x84, 0x78, 0xeb, 0x7e, 0x8b, 0x3e, 0x82, 0xf1, 0x78,
	0x55, 0x1a, 0xd5, 0x78, 0xd5, 0xfc, 0x78, 0x09, 0x45, 0xe2, 0xc3, 0xac, 0x00, 0x5d, 0x47, 0xd5,
	0x8f, 0x97, 0x55, 0x2d, 0x07, 0x8a, 0x61, 0xb5, 0xfa, 0x2f, 0xa7, 0x91, 0xc8, 0x31, 0x20, 0x6d,
	0xc1, 0xb9, 0x07, 0xae, 0x4c, 0x98, 0xe4, 0x51, 0x35, 0x9b, 0x81, 0x82, 0xc7, 0x1c, 0xac, 0x4b,
	0xb7, 0x8b, 0xba, 0x62, 0x27, 0x6b, 0xe3, 0xc1, 0xc6, 0xa6, 0xdb, 0x45, 0x7a, 0x01, 0x40, 0x1f,
	0x2a, 0xf1, 0x1a, 0xb9, 0xae, 0x58, 0xa1, 0xa6, 0xaf, 0x3f, 0x0e, 0x36, 0xcc, 0x0f, 0x04, 0x8a,
	0x7d, 0xc1, 0xa4, 0x27, 0xb8, 0x44, 0xba, 0x01, 0x85, 0x98, 0x48, 0x96, 0xc8, 0xec, 0xe8, 0x90,
	0x69, 0xed, 0x3b, 0xa1, 0x65, 0x38, 0xcd, 0xf1, 0xad, 0xaa, 0xa7, 0x78, 0xc2, 0xf7, 0x9d, 0x0c,
	0xb6, 0x37, 0x12, 0xa6, 0xab, 0x50, 0xbc, 0x83, 0x6d, 0xfc, 0xbf, 0xd0, 0x19, 0xaf, 0x52, 0xfd,
	0x02, 0x30, 0xbb, 0xe6, 0xf2, 0x80, 0xa2, 0xfb, 0x90, 0x71, 0xe6, 0xe0, 0x36, 0x72, 0xb5, 0x19,
	0xca, 0xf5, 0xe9, 0xfc, 0x5a, 0x40, 0x43, 0xbf, 0x12, 0x28, 0x24, 0x8a, 0xa0, 0x8b, 0xf9, 0xd3,
	0xe8, 0x97, 0x91, 0x31, 0xb0, 0x16, 0xcc, 0x2b, 0xef, 0x7f, 0xff, 0xf9, 0x38, 0x72, 0x99, 0x5e,
	0x4a, 0xb4, 0xfc, 0x2e, 0x00, 0x5f, 0xf6, 0x7c, 0xb1, 0x85, 0x4d, 0x25, 0xed, 0x39, 0x3b, 0x54,
	0xcb, 0x1e, 0xfd, 0x4e, 0xe0, 0x54, 0x5a, 0x90, 0x74, 0x39, 0x7f, 0xb4, 0x0c, 0x21, 0x0f, 0x01,
	0xbb, 0xa0, 0x61, 0xab, 0x46, 0x65, 0x1f, 0x36, 0x84, 0xb3, 0x0e, 0x60, 0x5e, 0x8c, 0xa4, 0x4e,
	0x7f, 0x10, 0x98, 0xea, 0x95, 0x3a, 0x5d, 0xc9, 0x1f, 0x3e, 0x73, 0x48, 0x18, 0x43, 0xf4, 0x5b,
	0x9c, 0x81, 0x59, 0x4e, 0x65, 0xa0, 0x65, 0x92, 0x82, 0xdf, 0xb3, 0x93, 0xa6, 0x5c, 0x4c, 0x64,
	0x47, 0xbf, 0x11, 0x98, 0x48, 0x8d, 0x02, 0x7a, 0x73, 0xa0, 0x36, 0x39, 0x0e, 0x76, 0x4b, 0xb3,
	0x57, 0x68, 0xf9, 0xe0, 0x56, 0x49, 0xc0, 0xed, 0xb9, 0x3d, 0xfa, 0x8b, 0xc0, 0x54, 0xef, 0x48,
	0x1a, 0xa4, 0xe6, 0x99, 0xc3, 0x6c, 0x28, 0xee, 0x55, 0xcd, 0xbd, 0x64, 0xd8, 0xfb, 0xdc, 0x31,
	0xa7, 0x75, 0x58, 0x02, 0xa9, 0xe2, 0xff, 0x24, 0x30, 0xd9, 0x33, 0x87, 0xe8, 0xad, 0xfc, 0x20,
	0x59, 0xd3, 0xd2, 0x58, 0x19, 0xda, 0x3e, 0x1c, 0x80, 0x59, 0xaf, 0x71, 0x58, 0x27, 0xd1, 0x4f,
	0x04, 0xa6, 0x7a, 0xe7, 0xd6, 0x20, 0xaf, 0x91, 0x39, 0xf1, 0x8c, 0xe9, 0xd8, 0x41, 0xfc, 0x9d,
	0xb7, 0xee, 0x06, 0xdf, 0xf9, 0x98, 0x6d, 0x2e, 0x67, 0xa7, 0xac, 0xbd, 0x78, 0xf6, 0x3c, 0x72,
	0xe4, 0x88, 0x36, 0xe3, 0x8e, 0x25, 0x7c, 0xc7, 0x76, 0x90, 0x6b, 0xb7, 0x76, 0x78, 0xc4, 0x3c,
	0x57, 0x1e, 0xfd, 0x4f, 0x64, 0x29, 0xe3, 0xec, 0x2f, 0x21, 0x8d, 0x31, 0xed, 0xea, 0xfa, 0xbf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0xda, 0x4c, 0x49, 0x53, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BinauthzManagementServiceV1Beta1Client is the client API for BinauthzManagementServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BinauthzManagementServiceV1Beta1Client interface {
	// Gets the [policy][google.cloud.binaryauthorization.v1beta1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1beta1.Policy] if the project does not have one.
	GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1beta1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1beta1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] already exists.
	CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type binauthzManagementServiceV1Beta1Client struct {
	cc *grpc.ClientConn
}

func NewBinauthzManagementServiceV1Beta1Client(cc *grpc.ClientConn) BinauthzManagementServiceV1Beta1Client {
	return &binauthzManagementServiceV1Beta1Client{cc}
}

func (c *binauthzManagementServiceV1Beta1Client) GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/GetPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/UpdatePolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) CreateAttestor(ctx context.Context, in *CreateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/CreateAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) GetAttestor(ctx context.Context, in *GetAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/GetAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) UpdateAttestor(ctx context.Context, in *UpdateAttestorRequest, opts ...grpc.CallOption) (*Attestor, error) {
	out := new(Attestor)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/UpdateAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) ListAttestors(ctx context.Context, in *ListAttestorsRequest, opts ...grpc.CallOption) (*ListAttestorsResponse, error) {
	out := new(ListAttestorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/ListAttestors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *binauthzManagementServiceV1Beta1Client) DeleteAttestor(ctx context.Context, in *DeleteAttestorRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/DeleteAttestor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BinauthzManagementServiceV1Beta1Server is the server API for BinauthzManagementServiceV1Beta1 service.
type BinauthzManagementServiceV1Beta1Server interface {
	// Gets the [policy][google.cloud.binaryauthorization.v1beta1.Policy] for this project. Returns a default
	// [policy][google.cloud.binaryauthorization.v1beta1.Policy] if the project does not have one.
	GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error)
	// Creates or updates a project's [policy][google.cloud.binaryauthorization.v1beta1.Policy], and returns a copy of the
	// new [policy][google.cloud.binaryauthorization.v1beta1.Policy]. A policy is always updated as a whole, to avoid race
	// conditions with concurrent policy enforcement (or management!)
	// requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
	// if the request is malformed.
	UpdatePolicy(context.Context, *UpdatePolicyRequest) (*Policy, error)
	// Creates an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor], and returns a copy of the new
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor]. Returns NOT_FOUND if the project does not exist,
	// INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] already exists.
	CreateAttestor(context.Context, *CreateAttestorRequest) (*Attestor, error)
	// Gets an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	GetAttestor(context.Context, *GetAttestorRequest) (*Attestor, error)
	// Updates an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns NOT_FOUND if the [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	UpdateAttestor(context.Context, *UpdateAttestorRequest) (*Attestor, error)
	// Lists [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
	// Returns INVALID_ARGUMENT if the project does not exist.
	ListAttestors(context.Context, *ListAttestorsRequest) (*ListAttestorsResponse, error)
	// Deletes an [attestor][google.cloud.binaryauthorization.v1beta1.Attestor]. Returns NOT_FOUND if the
	// [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] does not exist.
	DeleteAttestor(context.Context, *DeleteAttestorRequest) (*empty.Empty, error)
}

func RegisterBinauthzManagementServiceV1Beta1Server(s *grpc.Server, srv BinauthzManagementServiceV1Beta1Server) {
	s.RegisterService(&_BinauthzManagementServiceV1Beta1_serviceDesc, srv)
}

func _BinauthzManagementServiceV1Beta1_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/GetPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).GetPolicy(ctx, req.(*GetPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_UpdatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).UpdatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/UpdatePolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).UpdatePolicy(ctx, req.(*UpdatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_CreateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).CreateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/CreateAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).CreateAttestor(ctx, req.(*CreateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_GetAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).GetAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/GetAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).GetAttestor(ctx, req.(*GetAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_UpdateAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).UpdateAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/UpdateAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).UpdateAttestor(ctx, req.(*UpdateAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_ListAttestors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttestorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).ListAttestors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/ListAttestors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).ListAttestors(ctx, req.(*ListAttestorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BinauthzManagementServiceV1Beta1_DeleteAttestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BinauthzManagementServiceV1Beta1Server).DeleteAttestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1/DeleteAttestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BinauthzManagementServiceV1Beta1Server).DeleteAttestor(ctx, req.(*DeleteAttestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BinauthzManagementServiceV1Beta1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.binaryauthorization.v1beta1.BinauthzManagementServiceV1Beta1",
	HandlerType: (*BinauthzManagementServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPolicy",
			Handler:    _BinauthzManagementServiceV1Beta1_GetPolicy_Handler,
		},
		{
			MethodName: "UpdatePolicy",
			Handler:    _BinauthzManagementServiceV1Beta1_UpdatePolicy_Handler,
		},
		{
			MethodName: "CreateAttestor",
			Handler:    _BinauthzManagementServiceV1Beta1_CreateAttestor_Handler,
		},
		{
			MethodName: "GetAttestor",
			Handler:    _BinauthzManagementServiceV1Beta1_GetAttestor_Handler,
		},
		{
			MethodName: "UpdateAttestor",
			Handler:    _BinauthzManagementServiceV1Beta1_UpdateAttestor_Handler,
		},
		{
			MethodName: "ListAttestors",
			Handler:    _BinauthzManagementServiceV1Beta1_ListAttestors_Handler,
		},
		{
			MethodName: "DeleteAttestor",
			Handler:    _BinauthzManagementServiceV1Beta1_DeleteAttestor_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/binaryauthorization/v1beta1/service.proto",
}
