// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeletePartnerEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the AWS customer that the event source was created
	// for.
	//
	// Account is a required field
	Account *string `min:"12" type:"string" required:"true"`

	// The name of the event source to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePartnerEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePartnerEventSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePartnerEventSourceInput"}

	if s.Account == nil {
		invalidParams.Add(aws.NewErrParamRequired("Account"))
	}
	if s.Account != nil && len(*s.Account) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("Account", 12))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePartnerEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePartnerEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePartnerEventSource = "DeletePartnerEventSource"

// DeletePartnerEventSourceRequest returns a request value for making API operation for
// Amazon CloudWatch Events.
//
// This operation is used by SaaS partners to delete a partner event source.
// AWS customers don't use this operation.
//
// When you delete an event source, the status of the corresponding partner
// event bus in the AWS customer account becomes DELETED.
//
//    // Example sending a request using DeletePartnerEventSourceRequest.
//    req := client.DeletePartnerEventSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeletePartnerEventSource
func (c *Client) DeletePartnerEventSourceRequest(input *DeletePartnerEventSourceInput) DeletePartnerEventSourceRequest {
	op := &aws.Operation{
		Name:       opDeletePartnerEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartnerEventSourceInput{}
	}

	req := c.newRequest(op, input, &DeletePartnerEventSourceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePartnerEventSourceRequest{Request: req, Input: input, Copy: c.DeletePartnerEventSourceRequest}
}

// DeletePartnerEventSourceRequest is the request type for the
// DeletePartnerEventSource API operation.
type DeletePartnerEventSourceRequest struct {
	*aws.Request
	Input *DeletePartnerEventSourceInput
	Copy  func(*DeletePartnerEventSourceInput) DeletePartnerEventSourceRequest
}

// Send marshals and sends the DeletePartnerEventSource API request.
func (r DeletePartnerEventSourceRequest) Send(ctx context.Context) (*DeletePartnerEventSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePartnerEventSourceResponse{
		DeletePartnerEventSourceOutput: r.Request.Data.(*DeletePartnerEventSourceOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePartnerEventSourceResponse is the response type for the
// DeletePartnerEventSource API operation.
type DeletePartnerEventSourceResponse struct {
	*DeletePartnerEventSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePartnerEventSource request.
func (r *DeletePartnerEventSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
