// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRoleAliasInput struct {
	_ struct{} `type:"structure"`

	// The number of seconds the credential will be valid.
	CredentialDurationSeconds *int64 `locationName:"credentialDurationSeconds" min:"900" type:"integer"`

	// The role alias to update.
	//
	// RoleAlias is a required field
	RoleAlias *string `location:"uri" locationName:"roleAlias" min:"1" type:"string" required:"true"`

	// The role ARN.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateRoleAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoleAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRoleAliasInput"}
	if s.CredentialDurationSeconds != nil && *s.CredentialDurationSeconds < 900 {
		invalidParams.Add(aws.NewErrParamMinValue("CredentialDurationSeconds", 900))
	}

	if s.RoleAlias == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleAlias"))
	}
	if s.RoleAlias != nil && len(*s.RoleAlias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleAlias", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoleAliasInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CredentialDurationSeconds != nil {
		v := *s.CredentialDurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "credentialDurationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleAlias != nil {
		v := *s.RoleAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roleAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRoleAliasOutput struct {
	_ struct{} `type:"structure"`

	// The role alias.
	RoleAlias *string `locationName:"roleAlias" min:"1" type:"string"`

	// The role alias ARN.
	RoleAliasArn *string `locationName:"roleAliasArn" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRoleAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoleAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoleAlias != nil {
		v := *s.RoleAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleAliasArn != nil {
		v := *s.RoleAliasArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleAliasArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateRoleAlias = "UpdateRoleAlias"

// UpdateRoleAliasRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates a role alias.
//
//    // Example sending a request using UpdateRoleAliasRequest.
//    req := client.UpdateRoleAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateRoleAliasRequest(input *UpdateRoleAliasInput) UpdateRoleAliasRequest {
	op := &aws.Operation{
		Name:       opUpdateRoleAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/role-aliases/{roleAlias}",
	}

	if input == nil {
		input = &UpdateRoleAliasInput{}
	}

	req := c.newRequest(op, input, &UpdateRoleAliasOutput{})
	return UpdateRoleAliasRequest{Request: req, Input: input, Copy: c.UpdateRoleAliasRequest}
}

// UpdateRoleAliasRequest is the request type for the
// UpdateRoleAlias API operation.
type UpdateRoleAliasRequest struct {
	*aws.Request
	Input *UpdateRoleAliasInput
	Copy  func(*UpdateRoleAliasInput) UpdateRoleAliasRequest
}

// Send marshals and sends the UpdateRoleAlias API request.
func (r UpdateRoleAliasRequest) Send(ctx context.Context) (*UpdateRoleAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRoleAliasResponse{
		UpdateRoleAliasOutput: r.Request.Data.(*UpdateRoleAliasOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRoleAliasResponse is the response type for the
// UpdateRoleAlias API operation.
type UpdateRoleAliasResponse struct {
	*UpdateRoleAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRoleAlias request.
func (r *UpdateRoleAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
