// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sts

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAccessKeyInfoInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an access key.
	//
	// This parameter allows (through its regex pattern) a string of characters
	// that can consist of any upper- or lowercase letter or digit.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessKeyInfoInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessKeyInfoInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAccessKeyInfoInput"}

	if s.AccessKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessKeyId"))
	}
	if s.AccessKeyId != nil && len(*s.AccessKeyId) < 16 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessKeyId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetAccessKeyInfoOutput struct {
	_ struct{} `type:"structure"`

	// The number used to identify the AWS account.
	Account *string `type:"string"`
}

// String returns the string representation
func (s GetAccessKeyInfoOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAccessKeyInfo = "GetAccessKeyInfo"

// GetAccessKeyInfoRequest returns a request value for making API operation for
// AWS Security Token Service.
//
// Returns the account identifier for the specified access key ID.
//
// Access keys consist of two parts: an access key ID (for example, AKIAIOSFODNN7EXAMPLE)
// and a secret access key (for example, wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY).
// For more information about access keys, see Managing Access Keys for IAM
// Users (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html)
// in the IAM User Guide.
//
// When you pass an access key ID to this operation, it returns the ID of the
// AWS account to which the keys belong. Access key IDs beginning with AKIA
// are long-term credentials for an IAM user or the AWS account root user. Access
// key IDs beginning with ASIA are temporary credentials that are created using
// STS operations. If the account in the response belongs to you, you can sign
// in as the root user and review your root user access keys. Then, you can
// pull a credentials report (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html)
// to learn which IAM user owns the keys. To learn who requested the temporary
// credentials for an ASIA access key, view the STS events in your CloudTrail
// logs (https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html)
// in the IAM User Guide.
//
// This operation does not indicate the state of the access key. The key might
// be active, inactive, or deleted. Active keys might not have permissions to
// perform an operation. Providing a deleted access key might return an error
// that the key doesn't exist.
//
//    // Example sending a request using GetAccessKeyInfoRequest.
//    req := client.GetAccessKeyInfoRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/GetAccessKeyInfo
func (c *Client) GetAccessKeyInfoRequest(input *GetAccessKeyInfoInput) GetAccessKeyInfoRequest {
	op := &aws.Operation{
		Name:       opGetAccessKeyInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessKeyInfoInput{}
	}

	req := c.newRequest(op, input, &GetAccessKeyInfoOutput{})
	return GetAccessKeyInfoRequest{Request: req, Input: input, Copy: c.GetAccessKeyInfoRequest}
}

// GetAccessKeyInfoRequest is the request type for the
// GetAccessKeyInfo API operation.
type GetAccessKeyInfoRequest struct {
	*aws.Request
	Input *GetAccessKeyInfoInput
	Copy  func(*GetAccessKeyInfoInput) GetAccessKeyInfoRequest
}

// Send marshals and sends the GetAccessKeyInfo API request.
func (r GetAccessKeyInfoRequest) Send(ctx context.Context) (*GetAccessKeyInfoResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccessKeyInfoResponse{
		GetAccessKeyInfoOutput: r.Request.Data.(*GetAccessKeyInfoOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAccessKeyInfoResponse is the response type for the
// GetAccessKeyInfo API operation.
type GetAccessKeyInfoResponse struct {
	*GetAccessKeyInfoOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccessKeyInfo request.
func (r *GetAccessKeyInfoResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
