// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The member ID (user ID or bot ID).
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" type:"string" required:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomMembershipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRoomMembershipInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.MemberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberId"))
	}

	if s.RoomId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRoomMembershipInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "memberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRoomMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRoomMembershipOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteRoomMembership = "DeleteRoomMembership"

// DeleteRoomMembershipRequest returns a request value for making API operation for
// Amazon Chime.
//
// Removes a member from a chat room.
//
//    // Example sending a request using DeleteRoomMembershipRequest.
//    req := client.DeleteRoomMembershipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership
func (c *Client) DeleteRoomMembershipRequest(input *DeleteRoomMembershipInput) DeleteRoomMembershipRequest {
	op := &aws.Operation{
		Name:       opDeleteRoomMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &DeleteRoomMembershipInput{}
	}

	req := c.newRequest(op, input, &DeleteRoomMembershipOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteRoomMembershipRequest{Request: req, Input: input, Copy: c.DeleteRoomMembershipRequest}
}

// DeleteRoomMembershipRequest is the request type for the
// DeleteRoomMembership API operation.
type DeleteRoomMembershipRequest struct {
	*aws.Request
	Input *DeleteRoomMembershipInput
	Copy  func(*DeleteRoomMembershipInput) DeleteRoomMembershipRequest
}

// Send marshals and sends the DeleteRoomMembership API request.
func (r DeleteRoomMembershipRequest) Send(ctx context.Context) (*DeleteRoomMembershipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRoomMembershipResponse{
		DeleteRoomMembershipOutput: r.Request.Data.(*DeleteRoomMembershipOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRoomMembershipResponse is the response type for the
// DeleteRoomMembership API operation.
type DeleteRoomMembershipResponse struct {
	*DeleteRoomMembershipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRoomMembership request.
func (r *DeleteRoomMembershipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
