// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SetTypeDefaultVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the type for which you want version summary
	// information.
	//
	// Conditional: You must specify TypeName or Arn.
	Arn *string `type:"string"`

	// The kind of type.
	Type RegistryType `type:"string" enum:"true"`

	// The name of the type.
	//
	// Conditional: You must specify TypeName or Arn.
	TypeName *string `min:"10" type:"string"`

	// The ID of a specific version of the type. The version ID is the value at
	// the end of the Amazon Resource Name (ARN) assigned to the type version when
	// it is registered.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SetTypeDefaultVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTypeDefaultVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetTypeDefaultVersionInput"}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 10))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetTypeDefaultVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTypeDefaultVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetTypeDefaultVersion = "SetTypeDefaultVersion"

// SetTypeDefaultVersionRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Specify the default version of a type. The default version of a type will
// be used in CloudFormation operations.
//
//    // Example sending a request using SetTypeDefaultVersionRequest.
//    req := client.SetTypeDefaultVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion
func (c *Client) SetTypeDefaultVersionRequest(input *SetTypeDefaultVersionInput) SetTypeDefaultVersionRequest {
	op := &aws.Operation{
		Name:       opSetTypeDefaultVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTypeDefaultVersionInput{}
	}

	req := c.newRequest(op, input, &SetTypeDefaultVersionOutput{})
	return SetTypeDefaultVersionRequest{Request: req, Input: input, Copy: c.SetTypeDefaultVersionRequest}
}

// SetTypeDefaultVersionRequest is the request type for the
// SetTypeDefaultVersion API operation.
type SetTypeDefaultVersionRequest struct {
	*aws.Request
	Input *SetTypeDefaultVersionInput
	Copy  func(*SetTypeDefaultVersionInput) SetTypeDefaultVersionRequest
}

// Send marshals and sends the SetTypeDefaultVersion API request.
func (r SetTypeDefaultVersionRequest) Send(ctx context.Context) (*SetTypeDefaultVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetTypeDefaultVersionResponse{
		SetTypeDefaultVersionOutput: r.Request.Data.(*SetTypeDefaultVersionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetTypeDefaultVersionResponse is the response type for the
// SetTypeDefaultVersion API operation.
type SetTypeDefaultVersionResponse struct {
	*SetTypeDefaultVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetTypeDefaultVersion request.
func (r *SetTypeDefaultVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
