// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for AttachLoaBalancerToSubnets.
type AttachLoadBalancerToSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the subnets to add. You can add only one subnet per Availability
	// Zone.
	//
	// Subnets is a required field
	Subnets []string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancerToSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancerToSubnetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachLoadBalancerToSubnetsInput"}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of AttachLoadBalancerToSubnets.
type AttachLoadBalancerToSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the subnets attached to the load balancer.
	Subnets []string `type:"list"`
}

// String returns the string representation
func (s AttachLoadBalancerToSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachLoadBalancerToSubnets = "AttachLoadBalancerToSubnets"

// AttachLoadBalancerToSubnetsRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Adds one or more subnets to the set of configured subnets for the specified
// load balancer.
//
// The load balancer evenly distributes requests across all registered subnets.
// For more information, see Add or Remove Subnets for Your Load Balancer in
// a VPC (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using AttachLoadBalancerToSubnetsRequest.
//    req := client.AttachLoadBalancerToSubnetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AttachLoadBalancerToSubnets
func (c *Client) AttachLoadBalancerToSubnetsRequest(input *AttachLoadBalancerToSubnetsInput) AttachLoadBalancerToSubnetsRequest {
	op := &aws.Operation{
		Name:       opAttachLoadBalancerToSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerToSubnetsInput{}
	}

	req := c.newRequest(op, input, &AttachLoadBalancerToSubnetsOutput{})
	return AttachLoadBalancerToSubnetsRequest{Request: req, Input: input, Copy: c.AttachLoadBalancerToSubnetsRequest}
}

// AttachLoadBalancerToSubnetsRequest is the request type for the
// AttachLoadBalancerToSubnets API operation.
type AttachLoadBalancerToSubnetsRequest struct {
	*aws.Request
	Input *AttachLoadBalancerToSubnetsInput
	Copy  func(*AttachLoadBalancerToSubnetsInput) AttachLoadBalancerToSubnetsRequest
}

// Send marshals and sends the AttachLoadBalancerToSubnets API request.
func (r AttachLoadBalancerToSubnetsRequest) Send(ctx context.Context) (*AttachLoadBalancerToSubnetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachLoadBalancerToSubnetsResponse{
		AttachLoadBalancerToSubnetsOutput: r.Request.Data.(*AttachLoadBalancerToSubnetsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachLoadBalancerToSubnetsResponse is the response type for the
// AttachLoadBalancerToSubnets API operation.
type AttachLoadBalancerToSubnetsResponse struct {
	*AttachLoadBalancerToSubnetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachLoadBalancerToSubnets request.
func (r *AttachLoadBalancerToSubnetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
