// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source to describe.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDataSourceInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Information that describes where the data source is located and how the data
	// source is configured. The specific information in the description depends
	// on the data source provider.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The Unix timestamp of when the data source was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the data source.
	Description *string `min:"1" type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// description of the error that caused the data source to fail.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the data source.
	Id *string `min:"1" type:"string"`

	// The identifier of the index that contains the data source.
	IndexId *string `min:"36" type:"string"`

	// The name that you gave the data source when it was created.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that enables the data source to
	// access its resources.
	RoleArn *string `min:"1" type:"string"`

	// The schedule that Amazon Kendra will update the data source.
	Schedule *string `type:"string"`

	// The current status of the data source. When the status is ACTIVE the data
	// source is ready to use. When the status is FAILED, the ErrorMessage field
	// contains the reason that the data source failed.
	Status DataSourceStatus `type:"string" enum:"true"`

	// The type of the data source.
	Type DataSourceType `type:"string" enum:"true"`

	// The Unix timestamp of when the data source was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Gets information about a Amazon Kendra data source.
//
//    // Example sending a request using DescribeDataSourceRequest.
//    req := client.DescribeDataSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/DescribeDataSource
func (c *Client) DescribeDataSourceRequest(input *DescribeDataSourceInput) DescribeDataSourceRequest {
	op := &aws.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	req := c.newRequest(op, input, &DescribeDataSourceOutput{})
	return DescribeDataSourceRequest{Request: req, Input: input, Copy: c.DescribeDataSourceRequest}
}

// DescribeDataSourceRequest is the request type for the
// DescribeDataSource API operation.
type DescribeDataSourceRequest struct {
	*aws.Request
	Input *DescribeDataSourceInput
	Copy  func(*DescribeDataSourceInput) DescribeDataSourceRequest
}

// Send marshals and sends the DescribeDataSource API request.
func (r DescribeDataSourceRequest) Send(ctx context.Context) (*DescribeDataSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDataSourceResponse{
		DescribeDataSourceOutput: r.Request.Data.(*DescribeDataSourceOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDataSourceResponse is the response type for the
// DescribeDataSource API operation.
type DescribeDataSourceResponse struct {
	*DescribeDataSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDataSource request.
func (r *DescribeDataSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
