// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// The SSL/TLS certificate name.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// When true, forces the deletion of an SSL/TLS certificate.
	//
	// There can be two certificates associated with a Lightsail load balancer:
	// the primary and the backup. The force parameter is required when the primary
	// SSL/TLS certificate is in use by an instance attached to the load balancer.
	Force *bool `locationName:"force" type:"boolean"`

	// The load balancer name.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLoadBalancerTlsCertificateInput"}

	if s.CertificateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateName"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLoadBalancerTlsCertificate = "DeleteLoadBalancerTlsCertificate"

// DeleteLoadBalancerTlsCertificateRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
//
// The delete load balancer tls certificate operation supports tag-based access
// control via resource tags applied to the resource identified by load balancer
// name. For more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using DeleteLoadBalancerTlsCertificateRequest.
//    req := client.DeleteLoadBalancerTlsCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate
func (c *Client) DeleteLoadBalancerTlsCertificateRequest(input *DeleteLoadBalancerTlsCertificateInput) DeleteLoadBalancerTlsCertificateRequest {
	op := &aws.Operation{
		Name:       opDeleteLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerTlsCertificateInput{}
	}

	req := c.newRequest(op, input, &DeleteLoadBalancerTlsCertificateOutput{})
	return DeleteLoadBalancerTlsCertificateRequest{Request: req, Input: input, Copy: c.DeleteLoadBalancerTlsCertificateRequest}
}

// DeleteLoadBalancerTlsCertificateRequest is the request type for the
// DeleteLoadBalancerTlsCertificate API operation.
type DeleteLoadBalancerTlsCertificateRequest struct {
	*aws.Request
	Input *DeleteLoadBalancerTlsCertificateInput
	Copy  func(*DeleteLoadBalancerTlsCertificateInput) DeleteLoadBalancerTlsCertificateRequest
}

// Send marshals and sends the DeleteLoadBalancerTlsCertificate API request.
func (r DeleteLoadBalancerTlsCertificateRequest) Send(ctx context.Context) (*DeleteLoadBalancerTlsCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLoadBalancerTlsCertificateResponse{
		DeleteLoadBalancerTlsCertificateOutput: r.Request.Data.(*DeleteLoadBalancerTlsCertificateOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLoadBalancerTlsCertificateResponse is the response type for the
// DeleteLoadBalancerTlsCertificate API operation.
type DeleteLoadBalancerTlsCertificateResponse struct {
	*DeleteLoadBalancerTlsCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLoadBalancerTlsCertificate request.
func (r *DeleteLoadBalancerTlsCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
