// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateLagInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	//
	// LagId is a required field
	LagId *string `locationName:"lagId" type:"string" required:"true"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`
}

// String returns the string representation
func (s UpdateLagInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLagInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateLagInput"}

	if s.LagId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LagId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a link aggregation group (LAG).
type UpdateLagOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the LAG can host other connections.
	AllowsHostedConnections *bool `locationName:"allowsHostedConnections" type:"boolean"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDevice *string `locationName:"awsDevice" deprecated:"true" type:"string"`

	// The AWS Direct Connect endpoint that hosts the LAG.
	AwsDeviceV2 *string `locationName:"awsDeviceV2" type:"string"`

	// The connections bundled by the LAG.
	Connections []Connection `locationName:"connections" type:"list"`

	// The individual bandwidth of the physical connections bundled by the LAG.
	// The possible values are 1Gbps and 10Gbps.
	ConnectionsBandwidth *string `locationName:"connectionsBandwidth" type:"string"`

	// Indicates whether the LAG supports a secondary BGP peer in the same address
	// family (IPv4/IPv6).
	HasLogicalRedundancy HasLogicalRedundancy `locationName:"hasLogicalRedundancy" type:"string" enum:"true"`

	// Indicates whether jumbo frames (9001 MTU) are supported.
	JumboFrameCapable *bool `locationName:"jumboFrameCapable" type:"boolean"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`

	// The name of the LAG.
	LagName *string `locationName:"lagName" type:"string"`

	// The state of the LAG. The following are the possible values:
	//
	//    * requested: The initial state of a LAG. The LAG stays in the requested
	//    state until the Letter of Authorization (LOA) is available.
	//
	//    * pending: The LAG has been approved and is being initialized.
	//
	//    * available: The network link is established and the LAG is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The LAG is being deleted.
	//
	//    * deleted: The LAG is deleted.
	//
	//    * unknown: The state of the LAG is not available.
	LagState LagState `locationName:"lagState" type:"string" enum:"true"`

	// The location of the LAG.
	Location *string `locationName:"location" type:"string"`

	// The minimum number of physical connections that must be operational for the
	// LAG itself to be operational.
	MinimumLinks *int64 `locationName:"minimumLinks" type:"integer"`

	// The number of physical connections bundled by the LAG, up to a maximum of
	// 10.
	NumberOfConnections *int64 `locationName:"numberOfConnections" type:"integer"`

	// The ID of the AWS account that owns the LAG.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the service provider associated with the LAG.
	ProviderName *string `locationName:"providerName" type:"string"`

	// The AWS Region where the connection is located.
	Region *string `locationName:"region" type:"string"`

	// The tags associated with the LAG.
	Tags []Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateLagOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateLag = "UpdateLag"

// UpdateLagRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Updates the attributes of the specified link aggregation group (LAG).
//
// You can update the following attributes:
//
//    * The name of the LAG.
//
//    * The value for the minimum number of connections that must be operational
//    for the LAG itself to be operational.
//
// When you create a LAG, the default value for the minimum number of operational
// connections is zero (0). If you update this value and the number of operational
// connections falls below the specified value, the LAG automatically goes down
// to avoid over-utilization of the remaining connections. Adjust this value
// with care, as it could force the LAG down if it is set higher than the current
// number of operational connections.
//
//    // Example sending a request using UpdateLagRequest.
//    req := client.UpdateLagRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag
func (c *Client) UpdateLagRequest(input *UpdateLagInput) UpdateLagRequest {
	op := &aws.Operation{
		Name:       opUpdateLag,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLagInput{}
	}

	req := c.newRequest(op, input, &UpdateLagOutput{})
	return UpdateLagRequest{Request: req, Input: input, Copy: c.UpdateLagRequest}
}

// UpdateLagRequest is the request type for the
// UpdateLag API operation.
type UpdateLagRequest struct {
	*aws.Request
	Input *UpdateLagInput
	Copy  func(*UpdateLagInput) UpdateLagRequest
}

// Send marshals and sends the UpdateLag API request.
func (r UpdateLagRequest) Send(ctx context.Context) (*UpdateLagResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateLagResponse{
		UpdateLagOutput: r.Request.Data.(*UpdateLagOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateLagResponse is the response type for the
// UpdateLag API operation.
type UpdateLagResponse struct {
	*UpdateLagOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateLag request.
func (r *UpdateLagResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
