// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyTargetGroupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes.
	//
	// Attributes is a required field
	Attributes []TargetGroupAttribute `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyTargetGroupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyTargetGroupAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyTargetGroupAttributesInput"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}

	if s.TargetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyTargetGroupAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attributes.
	Attributes []TargetGroupAttribute `type:"list"`
}

// String returns the string representation
func (s ModifyTargetGroupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyTargetGroupAttributes = "ModifyTargetGroupAttributes"

// ModifyTargetGroupAttributesRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Modifies the specified attributes of the specified target group.
//
//    // Example sending a request using ModifyTargetGroupAttributesRequest.
//    req := client.ModifyTargetGroupAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes
func (c *Client) ModifyTargetGroupAttributesRequest(input *ModifyTargetGroupAttributesInput) ModifyTargetGroupAttributesRequest {
	op := &aws.Operation{
		Name:       opModifyTargetGroupAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyTargetGroupAttributesInput{}
	}

	req := c.newRequest(op, input, &ModifyTargetGroupAttributesOutput{})
	return ModifyTargetGroupAttributesRequest{Request: req, Input: input, Copy: c.ModifyTargetGroupAttributesRequest}
}

// ModifyTargetGroupAttributesRequest is the request type for the
// ModifyTargetGroupAttributes API operation.
type ModifyTargetGroupAttributesRequest struct {
	*aws.Request
	Input *ModifyTargetGroupAttributesInput
	Copy  func(*ModifyTargetGroupAttributesInput) ModifyTargetGroupAttributesRequest
}

// Send marshals and sends the ModifyTargetGroupAttributes API request.
func (r ModifyTargetGroupAttributesRequest) Send(ctx context.Context) (*ModifyTargetGroupAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyTargetGroupAttributesResponse{
		ModifyTargetGroupAttributesOutput: r.Request.Data.(*ModifyTargetGroupAttributesOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyTargetGroupAttributesResponse is the response type for the
// ModifyTargetGroupAttributes API operation.
type ModifyTargetGroupAttributesResponse struct {
	*ModifyTargetGroupAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyTargetGroupAttributes request.
func (r *ModifyTargetGroupAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
