// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the QualificationType.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQualificationTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetQualificationTypeInput"}

	if s.QualificationTypeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// The returned Qualification Type
	QualificationType *QualificationType `type:"structure"`
}

// String returns the string representation
func (s GetQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetQualificationType = "GetQualificationType"

// GetQualificationTypeRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The GetQualificationTypeoperation retrieves information about a Qualification
// type using its ID.
//
//    // Example sending a request using GetQualificationTypeRequest.
//    req := client.GetQualificationTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationType
func (c *Client) GetQualificationTypeRequest(input *GetQualificationTypeInput) GetQualificationTypeRequest {
	op := &aws.Operation{
		Name:       opGetQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQualificationTypeInput{}
	}

	req := c.newRequest(op, input, &GetQualificationTypeOutput{})
	return GetQualificationTypeRequest{Request: req, Input: input, Copy: c.GetQualificationTypeRequest}
}

// GetQualificationTypeRequest is the request type for the
// GetQualificationType API operation.
type GetQualificationTypeRequest struct {
	*aws.Request
	Input *GetQualificationTypeInput
	Copy  func(*GetQualificationTypeInput) GetQualificationTypeRequest
}

// Send marshals and sends the GetQualificationType API request.
func (r GetQualificationTypeRequest) Send(ctx context.Context) (*GetQualificationTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetQualificationTypeResponse{
		GetQualificationTypeOutput: r.Request.Data.(*GetQualificationTypeOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetQualificationTypeResponse is the response type for the
// GetQualificationType API operation.
type GetQualificationTypeResponse struct {
	*GetQualificationTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetQualificationType request.
func (r *GetQualificationTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
