// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package simpledb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAttributesInput struct {
	_ struct{} `type:"structure"`

	// The names of the attributes.
	AttributeNames []string `locationNameList:"AttributeName" type:"list" flattened:"true"`

	// Determines whether or not strong consistency should be enforced when data
	// is read from SimpleDB. If
	//    true
	// , any data previously written to SimpleDB will be returned. Otherwise, results
	// will be consistent eventually, and the client may not see data that was written
	// immediately before your read.
	ConsistentRead *bool `type:"boolean"`

	// The name of the domain in which to perform the operation.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The name of the item.
	//
	// ItemName is a required field
	ItemName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAttributesInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.ItemName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ItemName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The list of attributes returned by the operation.
	Attributes []Attribute `locationNameList:"Attribute" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAttributes = "GetAttributes"

// GetAttributesRequest returns a request value for making API operation for
// Amazon SimpleDB.
//
// Returns all of the attributes associated with the specified item. Optionally,
// the attributes returned can be limited to one or more attributes by specifying
// an attribute name parameter.
//
// If the item does not exist on the replica that was accessed for this operation,
// an empty set is returned. The system does not return an error as it cannot
// guarantee the item does not exist on other replicas.
//   If GetAttributes is called without being passed any attribute names, all
//   the attributes for the item are returned.
//
//    // Example sending a request using GetAttributesRequest.
//    req := client.GetAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetAttributesRequest(input *GetAttributesInput) GetAttributesRequest {
	op := &aws.Operation{
		Name:       opGetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAttributesInput{}
	}

	req := c.newRequest(op, input, &GetAttributesOutput{})
	return GetAttributesRequest{Request: req, Input: input, Copy: c.GetAttributesRequest}
}

// GetAttributesRequest is the request type for the
// GetAttributes API operation.
type GetAttributesRequest struct {
	*aws.Request
	Input *GetAttributesInput
	Copy  func(*GetAttributesInput) GetAttributesRequest
}

// Send marshals and sends the GetAttributes API request.
func (r GetAttributesRequest) Send(ctx context.Context) (*GetAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAttributesResponse{
		GetAttributesOutput: r.Request.Data.(*GetAttributesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAttributesResponse is the response type for the
// GetAttributes API operation.
type GetAttributesResponse struct {
	*GetAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAttributes request.
func (r *GetAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
