// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a PutApprovalResult action.
type PutApprovalResultInput struct {
	_ struct{} `type:"structure"`

	// The name of the action for which approval is requested.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The name of the pipeline that contains the action.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Represents information about the result of the approval request.
	//
	// Result is a required field
	Result *ApprovalResult `locationName:"result" type:"structure" required:"true"`

	// The name of the stage that contains the action.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// action. It is used to validate that the approval request corresponding to
	// this token is still valid.
	//
	// Token is a required field
	Token *string `locationName:"token" type:"string" required:"true"`
}

// String returns the string representation
func (s PutApprovalResultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApprovalResultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutApprovalResultInput"}

	if s.ActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActionName", 1))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if s.Result == nil {
		invalidParams.Add(aws.NewErrParamRequired("Result"))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StageName", 1))
	}

	if s.Token == nil {
		invalidParams.Add(aws.NewErrParamRequired("Token"))
	}
	if s.Result != nil {
		if err := s.Result.Validate(); err != nil {
			invalidParams.AddNested("Result", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a PutApprovalResult action.
type PutApprovalResultOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp showing when the approval or rejection was submitted.
	ApprovedAt *time.Time `locationName:"approvedAt" type:"timestamp"`
}

// String returns the string representation
func (s PutApprovalResultOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutApprovalResult = "PutApprovalResult"

// PutApprovalResultRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Provides the response to a manual approval request to AWS CodePipeline. Valid
// responses include Approved and Rejected.
//
//    // Example sending a request using PutApprovalResultRequest.
//    req := client.PutApprovalResultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult
func (c *Client) PutApprovalResultRequest(input *PutApprovalResultInput) PutApprovalResultRequest {
	op := &aws.Operation{
		Name:       opPutApprovalResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApprovalResultInput{}
	}

	req := c.newRequest(op, input, &PutApprovalResultOutput{})
	return PutApprovalResultRequest{Request: req, Input: input, Copy: c.PutApprovalResultRequest}
}

// PutApprovalResultRequest is the request type for the
// PutApprovalResult API operation.
type PutApprovalResultRequest struct {
	*aws.Request
	Input *PutApprovalResultInput
	Copy  func(*PutApprovalResultInput) PutApprovalResultRequest
}

// Send marshals and sends the PutApprovalResult API request.
func (r PutApprovalResultRequest) Send(ctx context.Context) (*PutApprovalResultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutApprovalResultResponse{
		PutApprovalResultOutput: r.Request.Data.(*PutApprovalResultOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutApprovalResultResponse is the response type for the
// PutApprovalResult API operation.
type PutApprovalResultResponse struct {
	*PutApprovalResultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutApprovalResult request.
func (r *PutApprovalResultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
