// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDetectorVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The new status.
	//
	// Status is a required field
	Status DetectorVersionStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDetectorVersionStatusInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.DetectorVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDetectorVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDetectorVersionStatus = "UpdateDetectorVersionStatus"

// UpdateDetectorVersionStatusRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates the detector version’s status. You can perform the following promotions
// or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to
// INACTIVE, and INACTIVE to ACTIVE.
//
//    // Example sending a request using UpdateDetectorVersionStatusRequest.
//    req := client.UpdateDetectorVersionStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *Client) UpdateDetectorVersionStatusRequest(input *UpdateDetectorVersionStatusInput) UpdateDetectorVersionStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateDetectorVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateDetectorVersionStatusOutput{})
	return UpdateDetectorVersionStatusRequest{Request: req, Input: input, Copy: c.UpdateDetectorVersionStatusRequest}
}

// UpdateDetectorVersionStatusRequest is the request type for the
// UpdateDetectorVersionStatus API operation.
type UpdateDetectorVersionStatusRequest struct {
	*aws.Request
	Input *UpdateDetectorVersionStatusInput
	Copy  func(*UpdateDetectorVersionStatusInput) UpdateDetectorVersionStatusRequest
}

// Send marshals and sends the UpdateDetectorVersionStatus API request.
func (r UpdateDetectorVersionStatusRequest) Send(ctx context.Context) (*UpdateDetectorVersionStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDetectorVersionStatusResponse{
		UpdateDetectorVersionStatusOutput: r.Request.Data.(*UpdateDetectorVersionStatusOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDetectorVersionStatusResponse is the response type for the
// UpdateDetectorVersionStatus API operation.
type UpdateDetectorVersionStatusResponse struct {
	*UpdateDetectorVersionStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDetectorVersionStatus request.
func (r *UpdateDetectorVersionStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
