// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEmailTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEmailTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteEmailTemplateOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEmailTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opDeleteEmailTemplate = "DeleteEmailTemplate"

// DeleteEmailTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Deletes a message template that was designed for use in messages that were
// sent through the email channel.
//
//    // Example sending a request using DeleteEmailTemplateRequest.
//    req := client.DeleteEmailTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate
func (c *Client) DeleteEmailTemplateRequest(input *DeleteEmailTemplateInput) DeleteEmailTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteEmailTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/templates/{template-name}/email",
	}

	if input == nil {
		input = &DeleteEmailTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteEmailTemplateOutput{})
	return DeleteEmailTemplateRequest{Request: req, Input: input, Copy: c.DeleteEmailTemplateRequest}
}

// DeleteEmailTemplateRequest is the request type for the
// DeleteEmailTemplate API operation.
type DeleteEmailTemplateRequest struct {
	*aws.Request
	Input *DeleteEmailTemplateInput
	Copy  func(*DeleteEmailTemplateInput) DeleteEmailTemplateRequest
}

// Send marshals and sends the DeleteEmailTemplate API request.
func (r DeleteEmailTemplateRequest) Send(ctx context.Context) (*DeleteEmailTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEmailTemplateResponse{
		DeleteEmailTemplateOutput: r.Request.Data.(*DeleteEmailTemplateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEmailTemplateResponse is the response type for the
// DeleteEmailTemplate API operation.
type DeleteEmailTemplateResponse struct {
	*DeleteEmailTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEmailTemplate request.
func (r *DeleteEmailTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
