// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ebsiface provides an interface to enable mocking the Amazon Elastic Block Store service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ebsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/ebs"
)

// ClientAPI provides an interface to enable mocking the
// ebs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon EBS.
//    func myFunc(svc ebsiface.ClientAPI) bool {
//        // Make svc.GetSnapshotBlock request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ebs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ebsiface.ClientPI
//    }
//    func (m *mockClientClient) GetSnapshotBlock(input *ebs.GetSnapshotBlockInput) (*ebs.GetSnapshotBlockOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	GetSnapshotBlockRequest(*ebs.GetSnapshotBlockInput) ebs.GetSnapshotBlockRequest

	ListChangedBlocksRequest(*ebs.ListChangedBlocksInput) ebs.ListChangedBlocksRequest

	ListSnapshotBlocksRequest(*ebs.ListSnapshotBlocksInput) ebs.ListSnapshotBlocksRequest
}

var _ ClientAPI = (*ebs.Client)(nil)
