// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request object for DescribeFileSystems operation.
type DescribeFileSystemsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) IDs of the file systems whose descriptions you want to retrieve
	// (String).
	FileSystemIds []string `type:"list"`

	// (Optional) Maximum number of file systems to return in the response (integer).
	// This parameter value must be greater than 0. The number of items that Amazon
	// FSx returns is the minimum of the MaxResults parameter specified in the request
	// and the service's internal maximum number of items per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) Opaque pagination token returned from a previous DescribeFileSystems
	// operation (String). If a token present, the action continues the list from
	// where the returning call left off.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFileSystemsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFileSystemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for DescribeFileSystems operation.
type DescribeFileSystemsOutput struct {
	_ struct{} `type:"structure"`

	// An array of file system descriptions.
	FileSystems []FileSystem `type:"list"`

	// Present if there are more file systems than returned in the response (String).
	// You can use the NextToken value in the later request to fetch the descriptions.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFileSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFileSystems = "DescribeFileSystems"

// DescribeFileSystemsRequest returns a request value for making API operation for
// Amazon FSx.
//
// Returns the description of specific Amazon FSx file systems, if a FileSystemIds
// value is provided for that file system. Otherwise, it returns descriptions
// of all file systems owned by your AWS account in the AWS Region of the endpoint
// that you're calling.
//
// When retrieving all file system descriptions, you can optionally specify
// the MaxResults parameter to limit the number of descriptions in a response.
// If more file system descriptions remain, Amazon FSx returns a NextToken value
// in the response. In this case, send a later request with the NextToken request
// parameter set to the value of NextToken from the last response.
//
// This action is used in an iterative process to retrieve a list of your file
// system descriptions. DescribeFileSystems is called first without a NextTokenvalue.
// Then the action continues to be called with the NextToken parameter set to
// the value of the last NextToken value until a response has no NextToken.
//
// When using this action, keep the following in mind:
//
//    * The implementation might return fewer than MaxResults file system descriptions
//    while still including a NextToken value.
//
//    * The order of file systems returned in the response of one DescribeFileSystems
//    call and the order of file systems returned across the responses of a
//    multicall iteration is unspecified.
//
//    // Example sending a request using DescribeFileSystemsRequest.
//    req := client.DescribeFileSystemsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DescribeFileSystems
func (c *Client) DescribeFileSystemsRequest(input *DescribeFileSystemsInput) DescribeFileSystemsRequest {
	op := &aws.Operation{
		Name:       opDescribeFileSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFileSystemsInput{}
	}

	req := c.newRequest(op, input, &DescribeFileSystemsOutput{})
	return DescribeFileSystemsRequest{Request: req, Input: input, Copy: c.DescribeFileSystemsRequest}
}

// DescribeFileSystemsRequest is the request type for the
// DescribeFileSystems API operation.
type DescribeFileSystemsRequest struct {
	*aws.Request
	Input *DescribeFileSystemsInput
	Copy  func(*DescribeFileSystemsInput) DescribeFileSystemsRequest
}

// Send marshals and sends the DescribeFileSystems API request.
func (r DescribeFileSystemsRequest) Send(ctx context.Context) (*DescribeFileSystemsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFileSystemsResponse{
		DescribeFileSystemsOutput: r.Request.Data.(*DescribeFileSystemsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeFileSystemsRequestPaginator returns a paginator for DescribeFileSystems.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeFileSystemsRequest(input)
//   p := fsx.NewDescribeFileSystemsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeFileSystemsPaginator(req DescribeFileSystemsRequest) DescribeFileSystemsPaginator {
	return DescribeFileSystemsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeFileSystemsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeFileSystemsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeFileSystemsPaginator struct {
	aws.Pager
}

func (p *DescribeFileSystemsPaginator) CurrentPage() *DescribeFileSystemsOutput {
	return p.Pager.CurrentPage().(*DescribeFileSystemsOutput)
}

// DescribeFileSystemsResponse is the response type for the
// DescribeFileSystems API operation.
type DescribeFileSystemsResponse struct {
	*DescribeFileSystemsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFileSystems request.
func (r *DescribeFileSystemsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
