// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/codebuild"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To get information about builds
//
// The following example gets information about builds with the specified build IDs.
func ExampleCodeBuild_BatchGetBuilds_shared00() {
	svc := codebuild.New(session.New())
	input := &codebuild.BatchGetBuildsInput{
		Ids: []*string{
			aws.String("codebuild-demo-project:9b0ac37f-d19e-4254-9079-f47e9a389eEX"),
			aws.String("codebuild-demo-project:b79a46f7-1473-4636-a23f-da9c45c208EX"),
		},
	}

	result, err := svc.BatchGetBuilds(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case codebuild.ErrCodeInvalidInputException:
				fmt.Println(codebuild.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
