// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Requests API Gateway to delete a Deployment resource.
type DeleteDeploymentInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the Deployment resource to delete.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeploymentInput"}

	if s.DeploymentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeploymentId"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeploymentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deployment_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeploymentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Deletes a Deployment resource. Deleting a deployment will only succeed if
// there are no Stage resources associated with it.
//
//    // Example sending a request using DeleteDeploymentRequest.
//    req := client.DeleteDeploymentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteDeploymentRequest(input *DeleteDeploymentInput) DeleteDeploymentRequest {
	op := &aws.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	req := c.newRequest(op, input, &DeleteDeploymentOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteDeploymentRequest{Request: req, Input: input, Copy: c.DeleteDeploymentRequest}
}

// DeleteDeploymentRequest is the request type for the
// DeleteDeployment API operation.
type DeleteDeploymentRequest struct {
	*aws.Request
	Input *DeleteDeploymentInput
	Copy  func(*DeleteDeploymentInput) DeleteDeploymentRequest
}

// Send marshals and sends the DeleteDeployment API request.
func (r DeleteDeploymentRequest) Send(ctx context.Context) (*DeleteDeploymentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeploymentResponse{
		DeleteDeploymentOutput: r.Request.Data.(*DeleteDeploymentOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeploymentResponse is the response type for the
// DeleteDeployment API operation.
type DeleteDeploymentResponse struct {
	*DeleteDeploymentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDeployment request.
func (r *DeleteDeploymentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
