// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetModelInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// ModelId is a required field
	ModelId *string `location:"uri" locationName:"modelId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetModelInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelId != nil {
		v := *s.ModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "modelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetModelOutput struct {
	_ struct{} `type:"structure"`

	// A string with a length between [1-256].
	ContentType *string `locationName:"contentType" type:"string"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	// The identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// A string with a length between [0-32768].
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s GetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelId != nil {
		v := *s.ModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetModel = "GetModel"

// GetModelRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Gets a Model.
//
//    // Example sending a request using GetModelRequest.
//    req := client.GetModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModel
func (c *Client) GetModelRequest(input *GetModelInput) GetModelRequest {
	op := &aws.Operation{
		Name:       opGetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/models/{modelId}",
	}

	if input == nil {
		input = &GetModelInput{}
	}

	req := c.newRequest(op, input, &GetModelOutput{})
	return GetModelRequest{Request: req, Input: input, Copy: c.GetModelRequest}
}

// GetModelRequest is the request type for the
// GetModel API operation.
type GetModelRequest struct {
	*aws.Request
	Input *GetModelInput
	Copy  func(*GetModelInput) GetModelRequest
}

// Send marshals and sends the GetModel API request.
func (r GetModelRequest) Send(ctx context.Context) (*GetModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetModelResponse{
		GetModelOutput: r.Request.Data.(*GetModelOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetModelResponse is the response type for the
// GetModel API operation.
type GetModelResponse struct {
	*GetModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetModel request.
func (r *GetModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
