// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeImageBuildersInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The names of the image builders to describe.
	Names []string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageBuildersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeImageBuildersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeImageBuildersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builders.
	ImageBuilders []ImageBuilder `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeImageBuilders = "DescribeImageBuilders"

// DescribeImageBuildersRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes one or more specified image builders, if
// the image builder names are provided. Otherwise, all image builders in the
// account are described.
//
//    // Example sending a request using DescribeImageBuildersRequest.
//    req := client.DescribeImageBuildersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders
func (c *Client) DescribeImageBuildersRequest(input *DescribeImageBuildersInput) DescribeImageBuildersRequest {
	op := &aws.Operation{
		Name:       opDescribeImageBuilders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageBuildersInput{}
	}

	req := c.newRequest(op, input, &DescribeImageBuildersOutput{})
	return DescribeImageBuildersRequest{Request: req, Input: input, Copy: c.DescribeImageBuildersRequest}
}

// DescribeImageBuildersRequest is the request type for the
// DescribeImageBuilders API operation.
type DescribeImageBuildersRequest struct {
	*aws.Request
	Input *DescribeImageBuildersInput
	Copy  func(*DescribeImageBuildersInput) DescribeImageBuildersRequest
}

// Send marshals and sends the DescribeImageBuilders API request.
func (r DescribeImageBuildersRequest) Send(ctx context.Context) (*DescribeImageBuildersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeImageBuildersResponse{
		DescribeImageBuildersOutput: r.Request.Data.(*DescribeImageBuildersOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeImageBuildersResponse is the response type for the
// DescribeImageBuilders API operation.
type DescribeImageBuildersResponse struct {
	*DescribeImageBuildersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeImageBuilders request.
func (r *DescribeImageBuildersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
