// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DetachSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The security profile that is detached.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`

	// The ARN of the thing group from which the security profile is detached.
	//
	// SecurityProfileTargetArn is a required field
	SecurityProfileTargetArn *string `location:"querystring" locationName:"securityProfileTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachSecurityProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachSecurityProfileInput"}

	if s.SecurityProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if s.SecurityProfileTargetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileTargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachSecurityProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityProfileTargetArn != nil {
		v := *s.SecurityProfileTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "securityProfileTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DetachSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachSecurityProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDetachSecurityProfile = "DetachSecurityProfile"

// DetachSecurityProfileRequest returns a request value for making API operation for
// AWS IoT.
//
// Disassociates a Device Defender security profile from a thing group or from
// this account.
//
//    // Example sending a request using DetachSecurityProfileRequest.
//    req := client.DetachSecurityProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetachSecurityProfileRequest(input *DetachSecurityProfileInput) DetachSecurityProfileRequest {
	op := &aws.Operation{
		Name:       opDetachSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}/targets",
	}

	if input == nil {
		input = &DetachSecurityProfileInput{}
	}

	req := c.newRequest(op, input, &DetachSecurityProfileOutput{})
	return DetachSecurityProfileRequest{Request: req, Input: input, Copy: c.DetachSecurityProfileRequest}
}

// DetachSecurityProfileRequest is the request type for the
// DetachSecurityProfile API operation.
type DetachSecurityProfileRequest struct {
	*aws.Request
	Input *DetachSecurityProfileInput
	Copy  func(*DetachSecurityProfileInput) DetachSecurityProfileRequest
}

// Send marshals and sends the DetachSecurityProfile API request.
func (r DetachSecurityProfileRequest) Send(ctx context.Context) (*DetachSecurityProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachSecurityProfileResponse{
		DetachSecurityProfileOutput: r.Request.Data.(*DetachSecurityProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachSecurityProfileResponse is the response type for the
// DetachSecurityProfile API operation.
type DetachSecurityProfileResponse struct {
	*DetachSecurityProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachSecurityProfile request.
func (r *DetachSecurityProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
