// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetPermissionInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the permission.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// The identifier for the version of the permission.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`
}

// String returns the string representation
func (s GetPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPermissionInput"}

	if s.PermissionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPermissionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PermissionArn != nil {
		v := *s.PermissionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "permissionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PermissionVersion != nil {
		v := *s.PermissionVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "permissionVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

type GetPermissionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the permission.
	Permission *ResourceSharePermissionDetail `locationName:"permission" type:"structure"`
}

// String returns the string representation
func (s GetPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetPermissionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Permission != nil {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "permission", v, metadata)
	}
	return nil
}

const opGetPermission = "GetPermission"

// GetPermissionRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Gets the contents of an AWS RAM permission in JSON format.
//
//    // Example sending a request using GetPermissionRequest.
//    req := client.GetPermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission
func (c *Client) GetPermissionRequest(input *GetPermissionInput) GetPermissionRequest {
	op := &aws.Operation{
		Name:       opGetPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/getpermission",
	}

	if input == nil {
		input = &GetPermissionInput{}
	}

	req := c.newRequest(op, input, &GetPermissionOutput{})
	return GetPermissionRequest{Request: req, Input: input, Copy: c.GetPermissionRequest}
}

// GetPermissionRequest is the request type for the
// GetPermission API operation.
type GetPermissionRequest struct {
	*aws.Request
	Input *GetPermissionInput
	Copy  func(*GetPermissionInput) GetPermissionRequest
}

// Send marshals and sends the GetPermission API request.
func (r GetPermissionRequest) Send(ctx context.Context) (*GetPermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPermissionResponse{
		GetPermissionOutput: r.Request.Data.(*GetPermissionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPermissionResponse is the response type for the
// GetPermission API operation.
type GetPermissionResponse struct {
	*GetPermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPermission request.
func (r *GetPermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
