// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Input for SetSubscriptionAttributes action.
type SetSubscriptionAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of attributes with their corresponding values.
	//
	// The following lists the names, descriptions, and values of the special request
	// parameters that the SetTopicAttributes action uses:
	//
	//    * DeliveryPolicy – The policy that defines how Amazon SNS retries failed
	//    deliveries to HTTP/S endpoints.
	//
	//    * FilterPolicy – The simple JSON object that lets your subscriber receive
	//    only a subset of messages, rather than receiving every message published
	//    to the topic.
	//
	//    * RawMessageDelivery – When set to true, enables raw message delivery
	//    to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints
	//    to process JSON formatting, which is otherwise created for Amazon SNS
	//    metadata.
	//
	//    * RedrivePolicy – When specified, sends undeliverable messages to the
	//    specified Amazon SQS dead-letter queue. Messages that can't be delivered
	//    due to client errors (for example, when the subscribed endpoint is unreachable)
	//    or server errors (for example, when the service that powers the subscribed
	//    endpoint becomes unavailable) are held in the dead-letter queue for further
	//    analysis or reprocessing.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute in JSON format.
	AttributeValue *string `type:"string"`

	// The ARN of the subscription to modify.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetSubscriptionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSubscriptionAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetSubscriptionAttributesInput"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}

	if s.SubscriptionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetSubscriptionAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetSubscriptionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetSubscriptionAttributes = "SetSubscriptionAttributes"

// SetSubscriptionAttributesRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Allows a subscription owner to set an attribute of the subscription to a
// new value.
//
//    // Example sending a request using SetSubscriptionAttributesRequest.
//    req := client.SetSubscriptionAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes
func (c *Client) SetSubscriptionAttributesRequest(input *SetSubscriptionAttributesInput) SetSubscriptionAttributesRequest {
	op := &aws.Operation{
		Name:       opSetSubscriptionAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSubscriptionAttributesInput{}
	}

	req := c.newRequest(op, input, &SetSubscriptionAttributesOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetSubscriptionAttributesRequest{Request: req, Input: input, Copy: c.SetSubscriptionAttributesRequest}
}

// SetSubscriptionAttributesRequest is the request type for the
// SetSubscriptionAttributes API operation.
type SetSubscriptionAttributesRequest struct {
	*aws.Request
	Input *SetSubscriptionAttributesInput
	Copy  func(*SetSubscriptionAttributesInput) SetSubscriptionAttributesRequest
}

// Send marshals and sends the SetSubscriptionAttributes API request.
func (r SetSubscriptionAttributesRequest) Send(ctx context.Context) (*SetSubscriptionAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetSubscriptionAttributesResponse{
		SetSubscriptionAttributesOutput: r.Request.Data.(*SetSubscriptionAttributesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetSubscriptionAttributesResponse is the response type for the
// SetSubscriptionAttributes API operation.
type SetSubscriptionAttributesResponse struct {
	*SetSubscriptionAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetSubscriptionAttributes request.
func (r *SetSubscriptionAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
