// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Creates a new documentation part of a given API.
type CreateDocumentationPartInput struct {
	_ struct{} `type:"structure"`

	// [Required] The location of the targeted API entity of the to-be-created documentation
	// part.
	//
	// Location is a required field
	Location *DocumentationPartLocation `locationName:"location" type:"structure" required:"true"`

	// [Required] The new documentation content map of the targeted API entity.
	// Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value
	// pairs can be exported and, hence, published.
	//
	// Properties is a required field
	Properties *string `locationName:"properties" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDocumentationPartInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentationPartInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDocumentationPartInput"}

	if s.Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("Location"))
	}

	if s.Properties == nil {
		invalidParams.Add(aws.NewErrParamRequired("Properties"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDocumentationPartInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "location", v, metadata)
	}
	if s.Properties != nil {
		v := *s.Properties

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "properties", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A documentation part for a targeted API entity.
//
// A documentation part consists of a content map (properties) and a target
// (location). The target specifies an API entity to which the documentation
// content applies. The supported API entity types are API, AUTHORIZER, MODEL,
// RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY,
// RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. Valid location fields depend
// on the API entity type. All valid fields are not required.
//
// The content map is a JSON string of API-specific key-value pairs. Although
// an API can use any shape for the content map, only the OpenAPI-compliant
// documentation fields will be injected into the associated API entity definition
// in the exported OpenAPI definition file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationParts
type CreateDocumentationPartOutput struct {
	_ struct{} `type:"structure"`

	// The DocumentationPart identifier, generated by API Gateway when the DocumentationPart
	// is created.
	Id *string `locationName:"id" type:"string"`

	// The location of the API entity to which the documentation applies. Valid
	// fields depend on the targeted API entity type. All the valid location fields
	// are not required. If not explicitly specified, a valid location field is
	// treated as a wildcard and associated documentation content may be inherited
	// by matching entities, unless overridden.
	Location *DocumentationPartLocation `locationName:"location" type:"structure"`

	// A content map of API-specific key-value pairs describing the targeted API
	// entity. The map must be encoded as a JSON string, e.g., "{ \"description\":
	// \"The API does ...\" }". Only OpenAPI-compliant documentation-related fields
	// from the properties map are exported and, hence, published as part of the
	// API entity definitions, while the original documentation parts are exported
	// in a OpenAPI extension of x-amazon-apigateway-documentation.
	Properties *string `locationName:"properties" type:"string"`
}

// String returns the string representation
func (s CreateDocumentationPartOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDocumentationPartOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "location", v, metadata)
	}
	if s.Properties != nil {
		v := *s.Properties

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "properties", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateDocumentationPart = "CreateDocumentationPart"

// CreateDocumentationPartRequest returns a request value for making API operation for
// Amazon API Gateway.
//
//    // Example sending a request using CreateDocumentationPartRequest.
//    req := client.CreateDocumentationPartRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateDocumentationPartRequest(input *CreateDocumentationPartInput) CreateDocumentationPartRequest {
	op := &aws.Operation{
		Name:       opCreateDocumentationPart,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts",
	}

	if input == nil {
		input = &CreateDocumentationPartInput{}
	}

	req := c.newRequest(op, input, &CreateDocumentationPartOutput{})
	return CreateDocumentationPartRequest{Request: req, Input: input, Copy: c.CreateDocumentationPartRequest}
}

// CreateDocumentationPartRequest is the request type for the
// CreateDocumentationPart API operation.
type CreateDocumentationPartRequest struct {
	*aws.Request
	Input *CreateDocumentationPartInput
	Copy  func(*CreateDocumentationPartInput) CreateDocumentationPartRequest
}

// Send marshals and sends the CreateDocumentationPart API request.
func (r CreateDocumentationPartRequest) Send(ctx context.Context) (*CreateDocumentationPartResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDocumentationPartResponse{
		CreateDocumentationPartOutput: r.Request.Data.(*CreateDocumentationPartOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDocumentationPartResponse is the response type for the
// CreateDocumentationPart API operation.
type CreateDocumentationPartResponse struct {
	*CreateDocumentationPartOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDocumentationPart request.
func (r *CreateDocumentationPartResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
