// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for DescribeStackResources action.
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// The output for a DescribeStackResources action.
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of StackResource structures.
	StackResources []StackResource `type:"list"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead.
//
// For deleted stacks, DescribeStackResources returns resource information for
// up to 90 days after the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
//
//    // Example sending a request using DescribeStackResourcesRequest.
//    req := client.DescribeStackResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *Client) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) DescribeStackResourcesRequest {
	op := &aws.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	req := c.newRequest(op, input, &DescribeStackResourcesOutput{})
	return DescribeStackResourcesRequest{Request: req, Input: input, Copy: c.DescribeStackResourcesRequest}
}

// DescribeStackResourcesRequest is the request type for the
// DescribeStackResources API operation.
type DescribeStackResourcesRequest struct {
	*aws.Request
	Input *DescribeStackResourcesInput
	Copy  func(*DescribeStackResourcesInput) DescribeStackResourcesRequest
}

// Send marshals and sends the DescribeStackResources API request.
func (r DescribeStackResourcesRequest) Send(ctx context.Context) (*DescribeStackResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStackResourcesResponse{
		DescribeStackResourcesOutput: r.Request.Data.(*DescribeStackResourcesOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeStackResourcesResponse is the response type for the
// DescribeStackResources API operation.
type DescribeStackResourcesResponse struct {
	*DescribeStackResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStackResources request.
func (r *DescribeStackResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
