// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type OverridePullRequestApprovalRulesInput struct {
	_ struct{} `type:"structure"`

	// Whether you want to set aside approval rule requirements for the pull request
	// (OVERRIDE) or revoke a previous override and apply approval rule requirements
	// (REVOKE). REVOKE status is not stored.
	//
	// OverrideStatus is a required field
	OverrideStatus OverrideStatus `locationName:"overrideStatus" type:"string" required:"true" enum:"true"`

	// The system-generated ID of the pull request for which you want to override
	// all approval rule requirements. To get this information, use GetPullRequest.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The system-generated ID of the most recent revision of the pull request.
	// You cannot override approval rules for anything but the most recent revision
	// of a pull request. To get the revision ID, use GetPullRequest.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s OverridePullRequestApprovalRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OverridePullRequestApprovalRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OverridePullRequestApprovalRulesInput"}
	if len(s.OverrideStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OverrideStatus"))
	}

	if s.PullRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PullRequestId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type OverridePullRequestApprovalRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s OverridePullRequestApprovalRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opOverridePullRequestApprovalRules = "OverridePullRequestApprovalRules"

// OverridePullRequestApprovalRulesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Sets aside (overrides) all approval rule requirements for a specified pull
// request.
//
//    // Example sending a request using OverridePullRequestApprovalRulesRequest.
//    req := client.OverridePullRequestApprovalRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/OverridePullRequestApprovalRules
func (c *Client) OverridePullRequestApprovalRulesRequest(input *OverridePullRequestApprovalRulesInput) OverridePullRequestApprovalRulesRequest {
	op := &aws.Operation{
		Name:       opOverridePullRequestApprovalRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OverridePullRequestApprovalRulesInput{}
	}

	req := c.newRequest(op, input, &OverridePullRequestApprovalRulesOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return OverridePullRequestApprovalRulesRequest{Request: req, Input: input, Copy: c.OverridePullRequestApprovalRulesRequest}
}

// OverridePullRequestApprovalRulesRequest is the request type for the
// OverridePullRequestApprovalRules API operation.
type OverridePullRequestApprovalRulesRequest struct {
	*aws.Request
	Input *OverridePullRequestApprovalRulesInput
	Copy  func(*OverridePullRequestApprovalRulesInput) OverridePullRequestApprovalRulesRequest
}

// Send marshals and sends the OverridePullRequestApprovalRules API request.
func (r OverridePullRequestApprovalRulesRequest) Send(ctx context.Context) (*OverridePullRequestApprovalRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &OverridePullRequestApprovalRulesResponse{
		OverridePullRequestApprovalRulesOutput: r.Request.Data.(*OverridePullRequestApprovalRulesOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// OverridePullRequestApprovalRulesResponse is the response type for the
// OverridePullRequestApprovalRules API operation.
type OverridePullRequestApprovalRulesResponse struct {
	*OverridePullRequestApprovalRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// OverridePullRequestApprovalRules request.
func (r *OverridePullRequestApprovalRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
