// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateWorkerBlockInput struct {
	_ struct{} `type:"structure"`

	// A message explaining the reason for blocking the Worker. This parameter enables
	// you to keep track of your Workers. The Worker does not see this message.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true"`

	// The ID of the Worker to block.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWorkerBlockInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerBlockInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateWorkerBlockInput"}

	if s.Reason == nil {
		invalidParams.Add(aws.NewErrParamRequired("Reason"))
	}

	if s.WorkerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateWorkerBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateWorkerBlockOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateWorkerBlock = "CreateWorkerBlock"

// CreateWorkerBlockRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The CreateWorkerBlock operation allows you to prevent a Worker from working
// on your HITs. For example, you can block a Worker who is producing poor quality
// work. You can block up to 100,000 Workers.
//
//    // Example sending a request using CreateWorkerBlockRequest.
//    req := client.CreateWorkerBlockRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateWorkerBlock
func (c *Client) CreateWorkerBlockRequest(input *CreateWorkerBlockInput) CreateWorkerBlockRequest {
	op := &aws.Operation{
		Name:       opCreateWorkerBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkerBlockInput{}
	}

	req := c.newRequest(op, input, &CreateWorkerBlockOutput{})
	return CreateWorkerBlockRequest{Request: req, Input: input, Copy: c.CreateWorkerBlockRequest}
}

// CreateWorkerBlockRequest is the request type for the
// CreateWorkerBlock API operation.
type CreateWorkerBlockRequest struct {
	*aws.Request
	Input *CreateWorkerBlockInput
	Copy  func(*CreateWorkerBlockInput) CreateWorkerBlockRequest
}

// Send marshals and sends the CreateWorkerBlock API request.
func (r CreateWorkerBlockRequest) Send(ctx context.Context) (*CreateWorkerBlockResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateWorkerBlockResponse{
		CreateWorkerBlockOutput: r.Request.Data.(*CreateWorkerBlockOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateWorkerBlockResponse is the response type for the
// CreateWorkerBlock API operation.
type CreateWorkerBlockResponse struct {
	*CreateWorkerBlockOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateWorkerBlock request.
func (r *CreateWorkerBlockResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
