// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeMaintenanceWindowScheduleInput struct {
	_ struct{} `type:"structure"`

	// Filters used to limit the range of results. For example, you can limit maintenance
	// window executions to only those scheduled before or after a certain date
	// and time.
	Filters []PatchOrchestratorFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The type of resource you want to retrieve information about. For example,
	// "INSTANCE".
	ResourceType MaintenanceWindowResourceType `type:"string" enum:"true"`

	// The instance ID or key/value pair to retrieve information about.
	Targets []Target `type:"list"`

	// The ID of the maintenance window to retrieve information about.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMaintenanceWindowScheduleInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeMaintenanceWindowScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. (You use this token in the
	// next call.)
	NextToken *string `type:"string"`

	// Information about maintenance window executions scheduled for the specified
	// time range.
	ScheduledWindowExecutions []ScheduledWindowExecution `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMaintenanceWindowSchedule = "DescribeMaintenanceWindowSchedule"

// DescribeMaintenanceWindowScheduleRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Retrieves information about upcoming executions of a maintenance window.
//
//    // Example sending a request using DescribeMaintenanceWindowScheduleRequest.
//    req := client.DescribeMaintenanceWindowScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule
func (c *Client) DescribeMaintenanceWindowScheduleRequest(input *DescribeMaintenanceWindowScheduleInput) DescribeMaintenanceWindowScheduleRequest {
	op := &aws.Operation{
		Name:       opDescribeMaintenanceWindowSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowScheduleInput{}
	}

	req := c.newRequest(op, input, &DescribeMaintenanceWindowScheduleOutput{})
	return DescribeMaintenanceWindowScheduleRequest{Request: req, Input: input, Copy: c.DescribeMaintenanceWindowScheduleRequest}
}

// DescribeMaintenanceWindowScheduleRequest is the request type for the
// DescribeMaintenanceWindowSchedule API operation.
type DescribeMaintenanceWindowScheduleRequest struct {
	*aws.Request
	Input *DescribeMaintenanceWindowScheduleInput
	Copy  func(*DescribeMaintenanceWindowScheduleInput) DescribeMaintenanceWindowScheduleRequest
}

// Send marshals and sends the DescribeMaintenanceWindowSchedule API request.
func (r DescribeMaintenanceWindowScheduleRequest) Send(ctx context.Context) (*DescribeMaintenanceWindowScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMaintenanceWindowScheduleResponse{
		DescribeMaintenanceWindowScheduleOutput: r.Request.Data.(*DescribeMaintenanceWindowScheduleOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMaintenanceWindowScheduleResponse is the response type for the
// DescribeMaintenanceWindowSchedule API operation.
type DescribeMaintenanceWindowScheduleResponse struct {
	*DescribeMaintenanceWindowScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMaintenanceWindowSchedule request.
func (r *DescribeMaintenanceWindowScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
