// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Deletes an analyzer.
type DeleteAnalyzerInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to delete.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// A client token.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteAnalyzerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalyzerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAnalyzerInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAnalyzerInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAnalyzerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAnalyzerOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAnalyzerOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteAnalyzer = "DeleteAnalyzer"

// DeleteAnalyzerRequest returns a request value for making API operation for
// Access Analyzer.
//
// Deletes the specified analyzer. When you delete an analyzer, Access Analyzer
// is disabled for the account in the current or specific Region. All findings
// that were generated by the analyzer are deleted. You cannot undo this action.
//
//    // Example sending a request using DeleteAnalyzerRequest.
//    req := client.DeleteAnalyzerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/DeleteAnalyzer
func (c *Client) DeleteAnalyzerRequest(input *DeleteAnalyzerInput) DeleteAnalyzerRequest {
	op := &aws.Operation{
		Name:       opDeleteAnalyzer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/analyzer/{analyzerName}",
	}

	if input == nil {
		input = &DeleteAnalyzerInput{}
	}

	req := c.newRequest(op, input, &DeleteAnalyzerOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAnalyzerRequest{Request: req, Input: input, Copy: c.DeleteAnalyzerRequest}
}

// DeleteAnalyzerRequest is the request type for the
// DeleteAnalyzer API operation.
type DeleteAnalyzerRequest struct {
	*aws.Request
	Input *DeleteAnalyzerInput
	Copy  func(*DeleteAnalyzerInput) DeleteAnalyzerRequest
}

// Send marshals and sends the DeleteAnalyzer API request.
func (r DeleteAnalyzerRequest) Send(ctx context.Context) (*DeleteAnalyzerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAnalyzerResponse{
		DeleteAnalyzerOutput: r.Request.Data.(*DeleteAnalyzerOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAnalyzerResponse is the response type for the
// DeleteAnalyzer API operation.
type DeleteAnalyzerResponse struct {
	*DeleteAnalyzerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAnalyzer request.
func (r *DeleteAnalyzerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
