// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lakeformation

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGrantPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string `min:"1" type:"string"`

	// A list of up to 20 entries for resource permissions to be granted by batch
	// operation to the principal.
	//
	// Entries is a required field
	Entries []BatchPermissionsRequestEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGrantPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGrantPermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGrantPermissionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.Entries == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGrantPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of failures to grant permissions to the resources.
	Failures []BatchPermissionsFailureEntry `type:"list"`
}

// String returns the string representation
func (s BatchGrantPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGrantPermissions = "BatchGrantPermissions"

// BatchGrantPermissionsRequest returns a request value for making API operation for
// AWS Lake Formation.
//
// Batch operation to grant permissions to the principal.
//
//    // Example sending a request using BatchGrantPermissionsRequest.
//    req := client.BatchGrantPermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions
func (c *Client) BatchGrantPermissionsRequest(input *BatchGrantPermissionsInput) BatchGrantPermissionsRequest {
	op := &aws.Operation{
		Name:       opBatchGrantPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGrantPermissionsInput{}
	}

	req := c.newRequest(op, input, &BatchGrantPermissionsOutput{})
	return BatchGrantPermissionsRequest{Request: req, Input: input, Copy: c.BatchGrantPermissionsRequest}
}

// BatchGrantPermissionsRequest is the request type for the
// BatchGrantPermissions API operation.
type BatchGrantPermissionsRequest struct {
	*aws.Request
	Input *BatchGrantPermissionsInput
	Copy  func(*BatchGrantPermissionsInput) BatchGrantPermissionsRequest
}

// Send marshals and sends the BatchGrantPermissions API request.
func (r BatchGrantPermissionsRequest) Send(ctx context.Context) (*BatchGrantPermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGrantPermissionsResponse{
		BatchGrantPermissionsOutput: r.Request.Data.(*BatchGrantPermissionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGrantPermissionsResponse is the response type for the
// BatchGrantPermissions API operation.
type BatchGrantPermissionsResponse struct {
	*BatchGrantPermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGrantPermissions request.
func (r *BatchGrantPermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
