// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetJourneyExecutionMetricsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JourneyId is a required field
	JourneyId *string `location:"uri" locationName:"journey-id" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`
}

// String returns the string representation
func (s GetJourneyExecutionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJourneyExecutionMetricsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJourneyExecutionMetricsInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.JourneyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JourneyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyExecutionMetricsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JourneyId != nil {
		v := *s.JourneyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "journey-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetJourneyExecutionMetricsOutput struct {
	_ struct{} `type:"structure" payload:"JourneyExecutionMetricsResponse"`

	// Provides the results of a query that retrieved the data for a standard execution
	// metric that applies to a journey.
	//
	// JourneyExecutionMetricsResponse is a required field
	JourneyExecutionMetricsResponse *JourneyExecutionMetricsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJourneyExecutionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetJourneyExecutionMetricsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JourneyExecutionMetricsResponse != nil {
		v := s.JourneyExecutionMetricsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "JourneyExecutionMetricsResponse", v, metadata)
	}
	return nil
}

const opGetJourneyExecutionMetrics = "GetJourneyExecutionMetrics"

// GetJourneyExecutionMetricsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard execution metric that
// applies to a journey.
//
//    // Example sending a request using GetJourneyExecutionMetricsRequest.
//    req := client.GetJourneyExecutionMetricsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics
func (c *Client) GetJourneyExecutionMetricsRequest(input *GetJourneyExecutionMetricsInput) GetJourneyExecutionMetricsRequest {
	op := &aws.Operation{
		Name:       opGetJourneyExecutionMetrics,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/journeys/{journey-id}/execution-metrics",
	}

	if input == nil {
		input = &GetJourneyExecutionMetricsInput{}
	}

	req := c.newRequest(op, input, &GetJourneyExecutionMetricsOutput{})
	return GetJourneyExecutionMetricsRequest{Request: req, Input: input, Copy: c.GetJourneyExecutionMetricsRequest}
}

// GetJourneyExecutionMetricsRequest is the request type for the
// GetJourneyExecutionMetrics API operation.
type GetJourneyExecutionMetricsRequest struct {
	*aws.Request
	Input *GetJourneyExecutionMetricsInput
	Copy  func(*GetJourneyExecutionMetricsInput) GetJourneyExecutionMetricsRequest
}

// Send marshals and sends the GetJourneyExecutionMetrics API request.
func (r GetJourneyExecutionMetricsRequest) Send(ctx context.Context) (*GetJourneyExecutionMetricsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJourneyExecutionMetricsResponse{
		GetJourneyExecutionMetricsOutput: r.Request.Data.(*GetJourneyExecutionMetricsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetJourneyExecutionMetricsResponse is the response type for the
// GetJourneyExecutionMetrics API operation.
type GetJourneyExecutionMetricsResponse struct {
	*GetJourneyExecutionMetricsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJourneyExecutionMetrics request.
func (r *GetJourneyExecutionMetricsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
