// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the resources exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token used to paginate through all the organization's resources. While
	// results are still available, it has an associated value. When the last page
	// is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`

	// One page of the organization's resource representation.
	Resources []Resource `type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResources = "ListResources"

// ListResourcesRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Returns summaries of the organization's resources.
//
//    // Example sending a request using ListResourcesRequest.
//    req := client.ListResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources
func (c *Client) ListResourcesRequest(input *ListResourcesInput) ListResourcesRequest {
	op := &aws.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	req := c.newRequest(op, input, &ListResourcesOutput{})
	return ListResourcesRequest{Request: req, Input: input, Copy: c.ListResourcesRequest}
}

// ListResourcesRequest is the request type for the
// ListResources API operation.
type ListResourcesRequest struct {
	*aws.Request
	Input *ListResourcesInput
	Copy  func(*ListResourcesInput) ListResourcesRequest
}

// Send marshals and sends the ListResources API request.
func (r ListResourcesRequest) Send(ctx context.Context) (*ListResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourcesResponse{
		ListResourcesOutput: r.Request.Data.(*ListResourcesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListResourcesRequestPaginator returns a paginator for ListResources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListResourcesRequest(input)
//   p := workmail.NewListResourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListResourcesPaginator(req ListResourcesRequest) ListResourcesPaginator {
	return ListResourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListResourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListResourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListResourcesPaginator struct {
	aws.Pager
}

func (p *ListResourcesPaginator) CurrentPage() *ListResourcesOutput {
	return p.Pager.CurrentPage().(*ListResourcesOutput)
}

// ListResourcesResponse is the response type for the
// ListResources API operation.
type ListResourcesResponse struct {
	*ListResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResources request.
func (r *ListResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
