// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request to update an existing model in an existing RestApi resource.
type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// [Required] The name of the model to update.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateModelInput"}

	if s.ModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelName"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PatchOperations != nil {
		v := s.PatchOperations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "patchOperations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ModelName != nil {
		v := *s.ModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "model_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the data structure of a method's request or response payload.
//
// A request model defines the data structure of the client-supplied request
// payload. A response model defines the data structure of the response payload
// returned by the back end. Although not required, models are useful for mapping
// payloads between the front end and back end.
//
// A model is used for generating an API's SDK, validating the input request
// body, and creating a skeletal mapping template.
//
// Method, MethodResponse, Models and Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html)
type UpdateModelOutput struct {
	_ struct{} `type:"structure"`

	// The content-type for the model.
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the model resource.
	Id *string `locationName:"id" type:"string"`

	// The name of the model. Must be an alphanumeric string.
	Name *string `locationName:"name" type:"string"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 (https://tools.ietf.org/html/draft-zyp-json-schema-04) model.
	// Do not include "\*/" characters in the description of any properties because
	// such "\*/" characters may be interpreted as the closing marker for comments
	// in some languages, such as Java or JavaScript, causing the installation of
	// your API's SDK generated by API Gateway to fail.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s UpdateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Changes information about a model.
//
//    // Example sending a request using UpdateModelRequest.
//    req := client.UpdateModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateModelRequest(input *UpdateModelInput) UpdateModelRequest {
	op := &aws.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	req := c.newRequest(op, input, &UpdateModelOutput{})
	return UpdateModelRequest{Request: req, Input: input, Copy: c.UpdateModelRequest}
}

// UpdateModelRequest is the request type for the
// UpdateModel API operation.
type UpdateModelRequest struct {
	*aws.Request
	Input *UpdateModelInput
	Copy  func(*UpdateModelInput) UpdateModelRequest
}

// Send marshals and sends the UpdateModel API request.
func (r UpdateModelRequest) Send(ctx context.Context) (*UpdateModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateModelResponse{
		UpdateModelOutput: r.Request.Data.(*UpdateModelOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateModelResponse is the response type for the
// UpdateModel API operation.
type UpdateModelResponse struct {
	*UpdateModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateModel request.
func (r *UpdateModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
