// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGraphqlApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGraphqlApiInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteGraphqlApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteGraphqlApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteGraphqlApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteGraphqlApi = "DeleteGraphqlApi"

// DeleteGraphqlApiRequest returns a request value for making API operation for
// AWS AppSync.
//
// Deletes a GraphqlApi object.
//
//    // Example sending a request using DeleteGraphqlApiRequest.
//    req := client.DeleteGraphqlApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi
func (c *Client) DeleteGraphqlApiRequest(input *DeleteGraphqlApiInput) DeleteGraphqlApiRequest {
	op := &aws.Operation{
		Name:       opDeleteGraphqlApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}",
	}

	if input == nil {
		input = &DeleteGraphqlApiInput{}
	}

	req := c.newRequest(op, input, &DeleteGraphqlApiOutput{})
	return DeleteGraphqlApiRequest{Request: req, Input: input, Copy: c.DeleteGraphqlApiRequest}
}

// DeleteGraphqlApiRequest is the request type for the
// DeleteGraphqlApi API operation.
type DeleteGraphqlApiRequest struct {
	*aws.Request
	Input *DeleteGraphqlApiInput
	Copy  func(*DeleteGraphqlApiInput) DeleteGraphqlApiRequest
}

// Send marshals and sends the DeleteGraphqlApi API request.
func (r DeleteGraphqlApiRequest) Send(ctx context.Context) (*DeleteGraphqlApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGraphqlApiResponse{
		DeleteGraphqlApiOutput: r.Request.Data.(*DeleteGraphqlApiOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGraphqlApiResponse is the response type for the
// DeleteGraphqlApi API operation.
type DeleteGraphqlApiResponse struct {
	*DeleteGraphqlApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGraphqlApi request.
func (r *DeleteGraphqlApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
