// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DefineIndexField operation. Specifies
// the name of the domain you want to update and the index field configuration.
type DefineIndexFieldInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The index field and field options you want to configure.
	//
	// IndexField is a required field
	IndexField *IndexField `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineIndexFieldInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DefineIndexFieldInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if s.IndexField == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexField"))
	}
	if s.IndexField != nil {
		if err := s.IndexField.Validate(); err != nil {
			invalidParams.AddNested("IndexField", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineIndexField request. Contains the status of the newly-configured
// index field.
type DefineIndexFieldOutput struct {
	_ struct{} `type:"structure"`

	// The value of an IndexField and its current status.
	//
	// IndexField is a required field
	IndexField *IndexFieldStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

const opDefineIndexField = "DefineIndexField"

// DefineIndexFieldRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Configures an IndexField for the search domain. Used to create new fields
// and modify existing ones. You must specify the name of the domain you are
// configuring and an index field configuration. The index field configuration
// specifies a unique name, the index field type, and the options you want to
// configure for the field. The options you can specify depend on the IndexFieldType.
// If the field exists, the new configuration replaces the old one. For more
// information, see Configuring Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DefineIndexFieldRequest.
//    req := client.DefineIndexFieldRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DefineIndexFieldRequest(input *DefineIndexFieldInput) DefineIndexFieldRequest {
	op := &aws.Operation{
		Name:       opDefineIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineIndexFieldInput{}
	}

	req := c.newRequest(op, input, &DefineIndexFieldOutput{})
	return DefineIndexFieldRequest{Request: req, Input: input, Copy: c.DefineIndexFieldRequest}
}

// DefineIndexFieldRequest is the request type for the
// DefineIndexField API operation.
type DefineIndexFieldRequest struct {
	*aws.Request
	Input *DefineIndexFieldInput
	Copy  func(*DefineIndexFieldInput) DefineIndexFieldRequest
}

// Send marshals and sends the DefineIndexField API request.
func (r DefineIndexFieldRequest) Send(ctx context.Context) (*DefineIndexFieldResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DefineIndexFieldResponse{
		DefineIndexFieldOutput: r.Request.Data.(*DefineIndexFieldOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DefineIndexFieldResponse is the response type for the
// DefineIndexField API operation.
type DefineIndexFieldResponse struct {
	*DefineIndexFieldOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DefineIndexField request.
func (r *DefineIndexFieldResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
