// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the Elasticsearch domain. Access policies
	// may be resource-based, IP-based, or IAM-based. See Configuring Access Policies
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessPoliciesStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := *s.Options

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Options", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// List of limits that are specific to a given InstanceType and for each of
// it's InstanceRole .
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	// Name of Additional Limit is specific to a given InstanceType and for each
	// of it's InstanceRole etc. Attributes and their details:
	//    * MaximumNumberOfDataNodesSupported
	//
	//    * MaximumNumberOfDataNodesWithoutMasterNode
	LimitName *string `type:"string"`

	// Value for given AdditionalLimit$LimitName .
	LimitValues []string `type:"list"`
}

// String returns the string representation
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdditionalLimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.LimitName != nil {
		v := *s.LimitName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LimitName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LimitValues != nil {
		v := s.LimitValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LimitValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Status of the advanced options for the specified Elasticsearch domain. Currently,
// the following advanced options are available:
//
//    * Option to allow references to indices in an HTTP request body. Must
//    be false when configuring access to individual sub-resources. By default,
//    the value is true. See Configuration Advanced Options for more information.
//
//    * Option to specify the percentage of heap space that is allocated to
//    field data. By default, this setting is unbounded.
//
// For more information, see Configuring Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options map[string]string `type:"map" required:"true"`

	// Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdvancedOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Options", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Options to specify the Cognito user and identity pools for Kibana authentication.
// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
type CognitoOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Cognito for Kibana authentication.
	Enabled *bool `type:"boolean"`

	// Specifies the Cognito identity pool ID for Kibana authentication.
	IdentityPoolId *string `min:"1" type:"string"`

	// Specifies the role ARN that provides Elasticsearch permissions for accessing
	// Cognito resources.
	RoleArn *string `min:"20" type:"string"`

	// Specifies the Cognito user pool ID for Kibana authentication.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CognitoOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoOptions"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CognitoOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserPoolId != nil {
		v := *s.UserPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Status of the Cognito options for the specified Elasticsearch domain.
type CognitoOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Cognito options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *CognitoOptions `type:"structure" required:"true"`

	// Specifies the status of the Cognito options for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s CognitoOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CognitoOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// A map from an ElasticsearchVersion to a list of compatible ElasticsearchVersion
// s to which the domain can be upgraded.
type CompatibleVersionsMap struct {
	_ struct{} `type:"structure"`

	// The current version of Elasticsearch on which a domain is.
	SourceVersion *string `type:"string"`

	// List of supported elastic search versions.
	TargetVersions []string `type:"list"`
}

// String returns the string representation
func (s CompatibleVersionsMap) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompatibleVersionsMap) MarshalFields(e protocol.FieldEncoder) error {
	if s.SourceVersion != nil {
		v := *s.SourceVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TargetVersions != nil {
		v := s.TargetVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TargetVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Options to configure endpoint for the Elasticsearch domain.
type DomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.
	EnforceHTTPS *bool `type:"boolean"`

	// Specify the TLS security policy that needs to be applied to the HTTPS endpoint
	// of Elasticsearch domain. It can be one of the following values:
	//    * Policy-Min-TLS-1-0-2019-07: TLS security policy which supports TLSv1.0
	//    and higher.
	//
	//    * Policy-Min-TLS-1-2-2019-07: TLS security policy which supports only
	//    TLSv1.2
	TLSSecurityPolicy TLSSecurityPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s DomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainEndpointOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.EnforceHTTPS != nil {
		v := *s.EnforceHTTPS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnforceHTTPS", protocol.BoolValue(v), metadata)
	}
	if len(s.TLSSecurityPolicy) > 0 {
		v := s.TLSSecurityPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TLSSecurityPolicy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The configured endpoint options for the domain and their current status.
type DomainEndpointOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Options to configure endpoint for the Elasticsearch domain.
	//
	// Options is a required field
	Options *DomainEndpointOptions `type:"structure" required:"true"`

	// The status of the endpoint options for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DomainEndpointOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainEndpointOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the DomainName.
	DomainName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see Configuring EBS-based Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// Specifies the volume type for EBS-based storage.
	VolumeType VolumeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EBSOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.EBSEnabled != nil {
		v := *s.EBSEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EBSEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Iops != nil {
		v := *s.Iops

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Iops", protocol.Int64Value(v), metadata)
	}
	if s.VolumeSize != nil {
		v := *s.VolumeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VolumeSize", protocol.Int64Value(v), metadata)
	}
	if len(s.VolumeType) > 0 {
		v := s.VolumeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VolumeType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Status of the EBS options for the specified Elasticsearch domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the EBS options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EBSOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies the configuration for the domain cluster, such as the type and
// number of instances.
type ElasticsearchClusterConfig struct {
	_ struct{} `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// About Dedicated Master Nodes (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType ESPartitionInstanceType `type:"string" enum:"true"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an Elasticsearch cluster. UltraWarm instance types
	// are not supported for data instances.
	InstanceType ESPartitionInstanceType `type:"string" enum:"true"`

	// The number of warm nodes in the cluster.
	WarmCount *int64 `type:"integer"`

	// True to enable warm storage.
	WarmEnabled *bool `type:"boolean"`

	// The instance type for the Elasticsearch cluster's warm nodes.
	WarmType ESWarmPartitionInstanceType `type:"string" enum:"true"`

	// Specifies the zone awareness configuration for a domain when zone awareness
	// is enabled.
	ZoneAwarenessConfig *ZoneAwarenessConfig `type:"structure"`

	// A boolean value to indicate whether zone awareness is enabled. See About
	// Zone Awareness (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ElasticsearchClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchClusterConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.DedicatedMasterCount != nil {
		v := *s.DedicatedMasterCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DedicatedMasterCount", protocol.Int64Value(v), metadata)
	}
	if s.DedicatedMasterEnabled != nil {
		v := *s.DedicatedMasterEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DedicatedMasterEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.DedicatedMasterType) > 0 {
		v := s.DedicatedMasterType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DedicatedMasterType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.InstanceCount != nil {
		v := *s.InstanceCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceCount", protocol.Int64Value(v), metadata)
	}
	if len(s.InstanceType) > 0 {
		v := s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.WarmCount != nil {
		v := *s.WarmCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarmCount", protocol.Int64Value(v), metadata)
	}
	if s.WarmEnabled != nil {
		v := *s.WarmEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarmEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.WarmType) > 0 {
		v := s.WarmType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WarmType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ZoneAwarenessConfig != nil {
		v := s.ZoneAwarenessConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ZoneAwarenessConfig", v, metadata)
	}
	if s.ZoneAwarenessEnabled != nil {
		v := *s.ZoneAwarenessEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZoneAwarenessEnabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Specifies the configuration status for the specified Elasticsearch domain.
type ElasticsearchClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *ElasticsearchClusterConfig `type:"structure" required:"true"`

	// Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchClusterConfigStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// The configuration of an Elasticsearch domain.
type ElasticsearchDomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Specifies the AdvancedOptions for the domain. See Configuring Advanced Options
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptionsStatus `type:"structure"`

	// Specifies the DomainEndpointOptions for the Elasticsearch domain.
	DomainEndpointOptions *DomainEndpointOptionsStatus `type:"structure"`

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus `type:"structure"`

	// Specifies the EncryptionAtRestOptions for the Elasticsearch domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus `type:"structure"`

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus `type:"structure"`

	// Specifies the NodeToNodeEncryptionOptions for the Elasticsearch domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus `type:"structure"`

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfoStatus `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchDomainConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPolicies != nil {
		v := s.AccessPolicies

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessPolicies", v, metadata)
	}
	if s.AdvancedOptions != nil {
		v := s.AdvancedOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AdvancedOptions", v, metadata)
	}
	if s.CognitoOptions != nil {
		v := s.CognitoOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CognitoOptions", v, metadata)
	}
	if s.DomainEndpointOptions != nil {
		v := s.DomainEndpointOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainEndpointOptions", v, metadata)
	}
	if s.EBSOptions != nil {
		v := s.EBSOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EBSOptions", v, metadata)
	}
	if s.ElasticsearchClusterConfig != nil {
		v := s.ElasticsearchClusterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ElasticsearchClusterConfig", v, metadata)
	}
	if s.ElasticsearchVersion != nil {
		v := s.ElasticsearchVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ElasticsearchVersion", v, metadata)
	}
	if s.EncryptionAtRestOptions != nil {
		v := s.EncryptionAtRestOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionAtRestOptions", v, metadata)
	}
	if s.LogPublishingOptions != nil {
		v := s.LogPublishingOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LogPublishingOptions", v, metadata)
	}
	if s.NodeToNodeEncryptionOptions != nil {
		v := s.NodeToNodeEncryptionOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NodeToNodeEncryptionOptions", v, metadata)
	}
	if s.SnapshotOptions != nil {
		v := s.SnapshotOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SnapshotOptions", v, metadata)
	}
	if s.VPCOptions != nil {
		v := s.VPCOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VPCOptions", v, metadata)
	}
	return nil
}

// The current status of an Elasticsearch domain.
type ElasticsearchDomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of an Elasticsearch domain. See Identifiers
	// for IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]string `type:"map"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The domain creation status. True if the creation of an Elasticsearch domain
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The current status of the Elasticsearch domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptions `type:"structure"`

	// The unique identifier for the specified Elasticsearch domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain. See Configuring EBS-based Storage
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
	// for more information.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances in the domain cluster.
	//
	// ElasticsearchClusterConfig is a required field
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure" required:"true"`

	ElasticsearchVersion *string `type:"string"`

	// Specifies the status of the EncryptionAtRestOptions.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string `type:"string"`

	// Map containing the Elasticsearch domain endpoints used to submit index and
	// search requests. Example key, value: 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]string `type:"map"`

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]LogPublishingOption `type:"map"`

	// Specifies the status of the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// The status of the Elasticsearch domain configuration. True if Amazon Elasticsearch
	// Service is processing configuration changes. False if the configuration is
	// active.
	Processing *bool `type:"boolean"`

	// The current status of the Elasticsearch domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// The status of an Elasticsearch domain version upgrade. True if Amazon Elasticsearch
	// Service is undergoing a version upgrade. False if the configuration is active.
	UpgradeProcessing *bool `type:"boolean"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchDomainStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccessPolicies != nil {
		v := *s.AccessPolicies

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessPolicies", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AdvancedOptions != nil {
		v := s.AdvancedOptions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "AdvancedOptions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.CognitoOptions != nil {
		v := s.CognitoOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CognitoOptions", v, metadata)
	}
	if s.Created != nil {
		v := *s.Created

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Created", protocol.BoolValue(v), metadata)
	}
	if s.Deleted != nil {
		v := *s.Deleted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Deleted", protocol.BoolValue(v), metadata)
	}
	if s.DomainEndpointOptions != nil {
		v := s.DomainEndpointOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainEndpointOptions", v, metadata)
	}
	if s.DomainId != nil {
		v := *s.DomainId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EBSOptions != nil {
		v := s.EBSOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EBSOptions", v, metadata)
	}
	if s.ElasticsearchClusterConfig != nil {
		v := s.ElasticsearchClusterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ElasticsearchClusterConfig", v, metadata)
	}
	if s.ElasticsearchVersion != nil {
		v := *s.ElasticsearchVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ElasticsearchVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EncryptionAtRestOptions != nil {
		v := s.EncryptionAtRestOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionAtRestOptions", v, metadata)
	}
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Endpoints != nil {
		v := s.Endpoints

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Endpoints", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LogPublishingOptions != nil {
		v := s.LogPublishingOptions

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "LogPublishingOptions", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.NodeToNodeEncryptionOptions != nil {
		v := s.NodeToNodeEncryptionOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NodeToNodeEncryptionOptions", v, metadata)
	}
	if s.Processing != nil {
		v := *s.Processing

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Processing", protocol.BoolValue(v), metadata)
	}
	if s.ServiceSoftwareOptions != nil {
		v := s.ServiceSoftwareOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ServiceSoftwareOptions", v, metadata)
	}
	if s.SnapshotOptions != nil {
		v := s.SnapshotOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SnapshotOptions", v, metadata)
	}
	if s.UpgradeProcessing != nil {
		v := *s.UpgradeProcessing

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpgradeProcessing", protocol.BoolValue(v), metadata)
	}
	if s.VPCOptions != nil {
		v := s.VPCOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VPCOptions", v, metadata)
	}
	return nil
}

// Status of the Elasticsearch version options for the specified Elasticsearch
// domain.
type ElasticsearchVersionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchVersionStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ElasticsearchVersionStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := *s.Options

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Options", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies the Encryption At Rest Options.
type EncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Encryption At Rest.
	Enabled *bool `type:"boolean"`

	// Specifies the KMS Key ID for Encryption At Rest options.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRestOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionAtRestOptions"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionAtRestOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Status of the Encryption At Rest options for the specified Elasticsearch
// domain.
type EncryptionAtRestOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Encryption At Rest options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *EncryptionAtRestOptions `type:"structure" required:"true"`

	// Specifies the status of the Encryption At Rest options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EncryptionAtRestOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionAtRestOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// InstanceCountLimits represents the limits on number of instances that be
// created in Amazon Elasticsearch for given InstanceType.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// Maximum number of Instances that can be instantiated for given InstanceType.
	MaximumInstanceCount *int64 `type:"integer"`

	// Minimum number of Instances that can be instantiated for given InstanceType.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceCountLimits) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaximumInstanceCount != nil {
		v := *s.MaximumInstanceCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaximumInstanceCount", protocol.Int64Value(v), metadata)
	}
	if s.MinimumInstanceCount != nil {
		v := *s.MinimumInstanceCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MinimumInstanceCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// InstanceLimits represents the list of instance related attributes that are
// available for given InstanceType.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// InstanceCountLimits represents the limits on number of instances that be
	// created in Amazon Elasticsearch for given InstanceType.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceLimits) MarshalFields(e protocol.FieldEncoder) error {
	if s.InstanceCountLimits != nil {
		v := s.InstanceCountLimits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InstanceCountLimits", v, metadata)
	}
	return nil
}

// Limits for given InstanceType and for each of it's role. Limits contains
// following StorageTypes, InstanceLimits and AdditionalLimits
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given InstanceType and for
	// each of it's InstanceRole .
	AdditionalLimits []AdditionalLimit `type:"list"`

	// InstanceLimits represents the list of instance related attributes that are
	// available for given InstanceType.
	InstanceLimits *InstanceLimits `type:"structure"`

	// StorageType represents the list of storage related types and attributes that
	// are available for given InstanceType.
	StorageTypes []StorageType `type:"list"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Limits) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdditionalLimits != nil {
		v := s.AdditionalLimits

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalLimits", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.InstanceLimits != nil {
		v := s.InstanceLimits

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InstanceLimits", v, metadata)
	}
	if s.StorageTypes != nil {
		v := s.StorageTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "StorageTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Log Publishing option that is set for given domain. Attributes and their
// details:
//    * CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to which
//    log needs to be published.
//
//    * Enabled: Whether the log publishing for given log type is enabled or
//    not
type LogPublishingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the Cloudwatch log group to which log needs to be published.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies whether given log publishing option is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s LogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogPublishingOption) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudWatchLogsLogGroupArn != nil {
		v := *s.CloudWatchLogsLogGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudWatchLogsLogGroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The log publishing options configured for the Elasticsearch domain.
	Options map[string]LogPublishingOption `type:"map"`

	// The status of the log publishing options for the Elasticsearch domain. See
	// OptionStatus for the status information that's included.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation
func (s LogPublishingOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LogPublishingOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Options", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies the node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Specify true to enable node-to-node encryption.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s NodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeToNodeEncryptionOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Status of the node-to-node encryption options for the specified Elasticsearch
// domain.
type NodeToNodeEncryptionOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the node-to-node encryption options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *NodeToNodeEncryptionOptions `type:"structure" required:"true"`

	// Specifies the status of the node-to-node encryption options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s NodeToNodeEncryptionOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeToNodeEncryptionOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Provides the current status of the entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells the creation date for the entity.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the Elasticsearch domain.
	//
	// State is a required field
	State OptionState `type:"string" required:"true" enum:"true"`

	// Timestamp which tells the last updated time for the entity.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// Specifies the latest version for the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OptionStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PendingDeletion != nil {
		v := *s.PendingDeletion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PendingDeletion", protocol.BoolValue(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdateDate != nil {
		v := *s.UpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.UpdateVersion != nil {
		v := *s.UpdateVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdateVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains the specific price and frequency of a recurring charges for a reserved
// Elasticsearch instance, or for a reserved Elasticsearch instance offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RecurringCharge) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecurringChargeAmount != nil {
		v := *s.RecurringChargeAmount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecurringChargeAmount", protocol.Float64Value(v), metadata)
	}
	if s.RecurringChargeFrequency != nil {
		v := *s.RecurringChargeFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecurringChargeFrequency", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details of a reserved Elasticsearch instance.
type ReservedElasticsearchInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the Elasticsearch instance is reserved.
	Duration *int64 `type:"integer"`

	// The number of Elasticsearch instances that have been reserved.
	ElasticsearchInstanceCount *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType ESPartitionInstanceType `type:"string" enum:"true"`

	// The upfront fixed charge you will paid to purchase the specific reserved
	// Elasticsearch instance offering.
	FixedPrice *float64 `type:"double"`

	// The payment option as defined in the reserved Elasticsearch instance offering.
	PaymentOption ReservedElasticsearchInstancePaymentOption `type:"string" enum:"true"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge `type:"list"`

	// The customer-specified identifier to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The unique identifier for the reservation.
	ReservedElasticsearchInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved Elasticsearch instance.
	State *string `type:"string"`

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedElasticsearchInstance) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReservedElasticsearchInstance) MarshalFields(e protocol.FieldEncoder) error {
	if s.CurrencyCode != nil {
		v := *s.CurrencyCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CurrencyCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Int64Value(v), metadata)
	}
	if s.ElasticsearchInstanceCount != nil {
		v := *s.ElasticsearchInstanceCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ElasticsearchInstanceCount", protocol.Int64Value(v), metadata)
	}
	if len(s.ElasticsearchInstanceType) > 0 {
		v := s.ElasticsearchInstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ElasticsearchInstanceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FixedPrice != nil {
		v := *s.FixedPrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FixedPrice", protocol.Float64Value(v), metadata)
	}
	if len(s.PaymentOption) > 0 {
		v := s.PaymentOption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PaymentOption", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RecurringCharges != nil {
		v := s.RecurringCharges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecurringCharges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ReservationName != nil {
		v := *s.ReservationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReservedElasticsearchInstanceId != nil {
		v := *s.ReservedElasticsearchInstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedElasticsearchInstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReservedElasticsearchInstanceOfferingId != nil {
		v := *s.ReservedElasticsearchInstanceOfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedElasticsearchInstanceOfferingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UsagePrice != nil {
		v := *s.UsagePrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UsagePrice", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Details of a reserved Elasticsearch instance offering.
type ReservedElasticsearchInstanceOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the Elasticsearch
	// instance.
	Duration *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType ESPartitionInstanceType `type:"string" enum:"true"`

	// The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch
	// instance offering.
	FixedPrice *float64 `type:"double"`

	// Payment option for the reserved Elasticsearch instance offering
	PaymentOption ReservedElasticsearchInstancePaymentOption `type:"string" enum:"true"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge `type:"list"`

	// The Elasticsearch reserved instance offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The rate you are charged for each hour the domain that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedElasticsearchInstanceOffering) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReservedElasticsearchInstanceOffering) MarshalFields(e protocol.FieldEncoder) error {
	if s.CurrencyCode != nil {
		v := *s.CurrencyCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CurrencyCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Duration != nil {
		v := *s.Duration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Duration", protocol.Int64Value(v), metadata)
	}
	if len(s.ElasticsearchInstanceType) > 0 {
		v := s.ElasticsearchInstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ElasticsearchInstanceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FixedPrice != nil {
		v := *s.FixedPrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FixedPrice", protocol.Float64Value(v), metadata)
	}
	if len(s.PaymentOption) > 0 {
		v := s.PaymentOption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PaymentOption", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RecurringCharges != nil {
		v := s.RecurringCharges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecurringCharges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ReservedElasticsearchInstanceOfferingId != nil {
		v := *s.ReservedElasticsearchInstanceOfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReservedElasticsearchInstanceOfferingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UsagePrice != nil {
		v := *s.UsagePrice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UsagePrice", protocol.Float64Value(v), metadata)
	}
	return nil
}

// The current options of an Elasticsearch domain service software options.
type ServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// Timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time `type:"timestamp"`

	// True if you are able to cancel your service software version update. False
	// if you are not able to cancel your service software version.
	Cancellable *bool `type:"boolean"`

	// The current service software version that is present on the domain.
	CurrentVersion *string `type:"string"`

	// The description of the UpdateStatus.
	Description *string `type:"string"`

	// The new service software version if one is available.
	NewVersion *string `type:"string"`

	// True if you are able to update you service software version. False if you
	// are not able to update your service software version.
	UpdateAvailable *bool `type:"boolean"`

	// The status of your service software update. This field can take the following
	// values: ELIGIBLE, PENDING_UPDATE, IN_PROGRESS, COMPLETED, and NOT_ELIGIBLE.
	UpdateStatus DeploymentStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceSoftwareOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutomatedUpdateDate != nil {
		v := *s.AutomatedUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AutomatedUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Cancellable != nil {
		v := *s.Cancellable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Cancellable", protocol.BoolValue(v), metadata)
	}
	if s.CurrentVersion != nil {
		v := *s.CurrentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CurrentVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NewVersion != nil {
		v := *s.NewVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NewVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdateAvailable != nil {
		v := *s.UpdateAvailable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdateAvailable", protocol.BoolValue(v), metadata)
	}
	if len(s.UpdateStatus) > 0 {
		v := s.UpdateStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdateStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SnapshotOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutomatedSnapshotStartHour != nil {
		v := *s.AutomatedSnapshotStartHour

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AutomatedSnapshotStartHour", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// Specifies the status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SnapshotOptionsStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// StorageTypes represents the list of storage related types and their attributes
// that are available for given InstanceType.
type StorageType struct {
	_ struct{} `type:"structure"`

	// SubType of the given storage type. List of available sub-storage options:
	// For "instance" storageType we wont have any storageSubType, in case of "ebs"
	// storageType we will have following valid storageSubTypes standard gp2 io1
	// Refer VolumeType for more information regarding above EBS storage options.
	StorageSubTypeName *string `type:"string"`

	// List of limits that are applicable for given storage type.
	StorageTypeLimits []StorageTypeLimit `type:"list"`

	// Type of the storage. List of available storage options: instance Inbuilt
	// storage available for the given Instance ebs Elastic block storage that would
	// be attached to the given Instance
	StorageTypeName *string `type:"string"`
}

// String returns the string representation
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageType) MarshalFields(e protocol.FieldEncoder) error {
	if s.StorageSubTypeName != nil {
		v := *s.StorageSubTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageSubTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StorageTypeLimits != nil {
		v := s.StorageTypeLimits

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "StorageTypeLimits", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.StorageTypeName != nil {
		v := *s.StorageTypeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageTypeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Limits that are applicable for given storage type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for given storage type. If StorageType
	// is ebs, following storage options are applicable MinimumVolumeSize Minimum
	// amount of volume size that is applicable for given storage type.It can be
	// empty if it is not applicable. MaximumVolumeSize Maximum amount of volume
	// size that is applicable for given storage type.It can be empty if it is not
	// applicable. MaximumIops Maximum amount of Iops that is applicable for given
	// storage type.It can be empty if it is not applicable. MinimumIops Minimum
	// amount of Iops that is applicable for given storage type.It can be empty
	// if it is not applicable.
	LimitName *string `type:"string"`

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []string `type:"list"`
}

// String returns the string representation
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageTypeLimit) MarshalFields(e protocol.FieldEncoder) error {
	if s.LimitName != nil {
		v := *s.LimitName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LimitName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LimitValues != nil {
		v := s.LimitValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LimitValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies a key value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the TagKey, the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specifies the TagValue, the value assigned to the corresponding tag key.
	// Tag values can be null and do not have to be unique in a tag set. For example,
	// you can have a key value pair in a tag set of project : Trinity and cost-center
	// : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// History of the last 10 Upgrades and Upgrade Eligibility Checks.
type UpgradeHistory struct {
	_ struct{} `type:"structure"`

	// UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time `type:"timestamp"`

	// A list of UpgradeStepItem s representing information about each step performed
	// as pard of a specific Upgrade or Upgrade Eligibility Check.
	StepsList []UpgradeStepItem `type:"list"`

	// A string that describes the update briefly
	UpgradeName *string `type:"string"`

	// The overall status of the update. The status can take one of the following
	// values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStatus UpgradeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpgradeHistory) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpgradeHistory) MarshalFields(e protocol.FieldEncoder) error {
	if s.StartTimestamp != nil {
		v := *s.StartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.StepsList != nil {
		v := s.StepsList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "StepsList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UpgradeName != nil {
		v := *s.UpgradeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpgradeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.UpgradeStatus) > 0 {
		v := s.UpgradeStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpgradeStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.
type UpgradeStepItem struct {
	_ struct{} `type:"structure"`

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []string `type:"list"`

	// The Floating point value representing progress percentage of a particular
	// step.
	ProgressPercent *float64 `type:"double"`

	// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through:
	//    * PreUpgradeCheck
	//
	//    * Snapshot
	//
	//    * Upgrade
	UpgradeStep UpgradeStep `type:"string" enum:"true"`

	// The status of a particular step during an upgrade. The status can take one
	// of the following values:
	//    * In Progress
	//
	//    * Succeeded
	//
	//    * Succeeded with Issues
	//
	//    * Failed
	UpgradeStepStatus UpgradeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpgradeStepItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpgradeStepItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.Issues != nil {
		v := s.Issues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Issues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ProgressPercent != nil {
		v := *s.ProgressPercent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProgressPercent", protocol.Float64Value(v), metadata)
	}
	if len(s.UpgradeStep) > 0 {
		v := s.UpgradeStep

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpgradeStep", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.UpgradeStepStatus) > 0 {
		v := s.UpgradeStepStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpgradeStepStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCDerivedInfo struct {
	_ struct{} `type:"structure"`

	// The availability zones for the Elasticsearch domain. Exists only if the domain
	// was created with VPCOptions.
	AvailabilityZones []string `type:"list"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []string `type:"list"`

	// The VPC Id for the Elasticsearch domain. Exists only if the domain was created
	// with VPCOptions.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s VPCDerivedInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCDerivedInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AvailabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VPCId != nil {
		v := *s.VPCId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VPCId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Status of the VPC options for the specified Elasticsearch domain.
type VPCDerivedInfoStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the VPC options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *VPCDerivedInfo `type:"structure" required:"true"`

	// Specifies the status of the VPC options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s VPCDerivedInfoStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCDerivedInfoStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Options != nil {
		v := s.Options

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Options", v, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []string `type:"list"`
}

// String returns the string representation
func (s VPCOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Specifies the zone awareness configuration for the domain cluster, such as
// the number of availability zones.
type ZoneAwarenessConfig struct {
	_ struct{} `type:"structure"`

	// An integer value to indicate the number of availability zones for a domain
	// when zone awareness is enabled. This should be equal to number of subnets
	// if VPC endpoints is enabled
	AvailabilityZoneCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ZoneAwarenessConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ZoneAwarenessConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZoneCount != nil {
		v := *s.AvailabilityZoneCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZoneCount", protocol.Int64Value(v), metadata)
	}
	return nil
}
