// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// A map of arguments used to configure the DevEndpoint.
	Arguments map[string]string `type:"map"`

	// The name to be assigned to the new DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The path to one or more Java .jar files in an S3 bucket that should be loaded
	// in your DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an Amazon S3 bucket that should
	// be loaded in your DevEndpoint. Multiple values must be complete paths separated
	// by a comma.
	//
	// You can only use pure Python libraries with a DevEndpoint. Libraries that
	// rely on C extensions, such as the pandas (http://pandas.pydata.org/) Python
	// data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for running
	// your ETL scripts on development endpoints.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Development endpoints that are created without specifying a Glue version
	// default to Glue 0.9.
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	GlueVersion *string `min:"1" type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) to allocate to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The number of workers of a defined workerType that are allocated to the development
	// endpoint.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility because the recommended attribute
	// to use is public keys.
	PublicKey *string `type:"string"`

	// A list of public keys to be used by the development endpoints for authentication.
	// The use of this attribute is preferred over a single public key because the
	// public keys allow you to have a different private key per client.
	//
	// If you previously created an endpoint with a public key, you must remove
	// that key to be able to set a list of public keys. Call the UpdateDevEndpoint
	// API with the public key content in the deletePublicKeys attribute, and the
	// list of new keys in the addPublicKeys attribute.
	PublicKeys []string `type:"list"`

	// The IAM role for the DevEndpoint.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// Security group IDs for the security groups to be used by the new DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The subnet ID for the new DevEndpoint to use.
	SubnetId *string `type:"string"`

	// The tags to use with this DevEndpoint. You may use tags to limit access to
	// the DevEndpoint. For more information about tags in AWS Glue, see AWS Tags
	// in AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]string `type:"map"`

	// The type of predefined worker that is allocated to the development endpoint.
	// Accepts a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	// Known issue: when a development endpoint is created with the G.2X WorkerType
	// configuration, the Spark drivers for the development endpoint will run on
	// 4 vCPU, 16 GB of memory, and a 64 GB disk.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDevEndpointInput"}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDevEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The map of arguments used to configure this DevEndpoint.
	//
	// Valid arguments are:
	//
	//    * "--enable-glue-datacatalog": ""
	//
	//    * "GLUE_PYTHON_VERSION": "3"
	//
	//    * "GLUE_PYTHON_VERSION": "2"
	//
	// You can specify a version of Python support for development endpoints by
	// using the Arguments parameter in the CreateDevEndpoint or UpdateDevEndpoint
	// APIs. If no arguments are provided, the version defaults to Python 2.
	Arguments map[string]string `type:"map"`

	// The AWS Availability Zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name assigned to the new DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java .jar files in an S3 bucket that will be loaded in
	// your DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// The paths to one or more Python libraries in an S3 bucket that will be loaded
	// in your DevEndpoint.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for running
	// your ETL scripts on development endpoints.
	GlueVersion *string `min:"1" type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The number of workers of a defined workerType that are allocated to the development
	// endpoint.
	NumberOfWorkers *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the role assigned to the new DevEndpoint.
	RoleArn *string `type:"string"`

	// The name of the SecurityConfiguration structure being used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The security groups assigned to the new DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The current status of the new DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID assigned to the new DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The type of predefined worker that is allocated to the development endpoint.
	// May be a value of Standard, G.1X, or G.2X.
	WorkerType WorkerType `type:"string" enum:"true"`

	// The address of the YARN endpoint used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDevEndpoint = "CreateDevEndpoint"

// CreateDevEndpointRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates a new development endpoint.
//
//    // Example sending a request using CreateDevEndpointRequest.
//    req := client.CreateDevEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Client) CreateDevEndpointRequest(input *CreateDevEndpointInput) CreateDevEndpointRequest {
	op := &aws.Operation{
		Name:       opCreateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevEndpointInput{}
	}

	req := c.newRequest(op, input, &CreateDevEndpointOutput{})
	return CreateDevEndpointRequest{Request: req, Input: input, Copy: c.CreateDevEndpointRequest}
}

// CreateDevEndpointRequest is the request type for the
// CreateDevEndpoint API operation.
type CreateDevEndpointRequest struct {
	*aws.Request
	Input *CreateDevEndpointInput
	Copy  func(*CreateDevEndpointInput) CreateDevEndpointRequest
}

// Send marshals and sends the CreateDevEndpoint API request.
func (r CreateDevEndpointRequest) Send(ctx context.Context) (*CreateDevEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDevEndpointResponse{
		CreateDevEndpointOutput: r.Request.Data.(*CreateDevEndpointOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDevEndpointResponse is the response type for the
// CreateDevEndpoint API operation.
type CreateDevEndpointResponse struct {
	*CreateDevEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDevEndpoint request.
func (r *CreateDevEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
