// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type QueryInput struct {
	_ struct{} `type:"structure"`

	// Enables filtered searches based on document attributes. You can only provide
	// one attribute filter; however, the AndAllFilters, NotFilter, and OrAllFilters
	// parameters contain a list of other filters.
	//
	// The AttributeFilter parameter enables you to create a set of filtering rules
	// that a document must satisfy to be included in the query results.
	AttributeFilter *AttributeFilter `type:"structure"`

	// An array of documents attributes. Amazon Kendra returns a count for each
	// attribute key specified. You can use this information to help narrow the
	// search for your user.
	Facets []Facet `type:"list"`

	// The unique identifier of the index to search. The identifier is returned
	// in the response from the operation.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// Query results are returned in pages the size of the PageSize parameter. By
	// default, Amazon Kendra returns the first page of results. Use this parameter
	// to get result pages after the first one.
	PageNumber *int64 `type:"integer"`

	// Sets the number of results that are returned in each page of results. The
	// default page size is 100.
	PageSize *int64 `type:"integer"`

	// Sets the type of query. Only results for the specified query type are returned.
	QueryResultTypeFilter QueryResultType `type:"string" enum:"true"`

	// The text to search for.
	//
	// QueryText is a required field
	QueryText *string `min:"1" type:"string" required:"true"`

	// An array of document attributes to include in the response. No other document
	// attributes are included in the response. By default all document attributes
	// are included in the response.
	RequestedDocumentAttributes []string `min:"1" type:"list"`
}

// String returns the string representation
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryInput"}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if s.QueryText == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryText"))
	}
	if s.QueryText != nil && len(*s.QueryText) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryText", 1))
	}
	if s.RequestedDocumentAttributes != nil && len(s.RequestedDocumentAttributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RequestedDocumentAttributes", 1))
	}
	if s.AttributeFilter != nil {
		if err := s.AttributeFilter.Validate(); err != nil {
			invalidParams.AddNested("AttributeFilter", err.(aws.ErrInvalidParams))
		}
	}
	if s.Facets != nil {
		for i, v := range s.Facets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Facets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type QueryOutput struct {
	_ struct{} `type:"structure"`

	// Contains the facet results. A FacetResult contains the counts for each attribute
	// key that was specified in the Facets input parameter.
	FacetResults []FacetResult `type:"list"`

	// The unique identifier for the search. You use QueryId to identify the search
	// when using the feedback API.
	QueryId *string `min:"1" type:"string"`

	// The results of the search.
	ResultItems []QueryResultItem `type:"list"`

	// The number of items returned by the search. Use this to determine when you
	// have requested the last set of results.
	TotalNumberOfResults *int64 `type:"integer"`
}

// String returns the string representation
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

const opQuery = "Query"

// QueryRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Searches an active index. Use this API to search your documents using query.
// The Query operation enables to do faceted search and to filter results based
// on document attributes.
//
// It also enables you to provide user context that Amazon Kendra uses to enforce
// document access control in the search results.
//
// Amazon Kendra searches your index for text content and question and answer
// (FAQ) content. By default the response contains three types of results.
//
//    * Relevant passages
//
//    * Matching FAQs
//
//    * Relevant documents
//
// You can specify that the query return only one type of result using the QueryResultTypeConfig
// parameter.
//
//    // Example sending a request using QueryRequest.
//    req := client.QueryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/Query
func (c *Client) QueryRequest(input *QueryInput) QueryRequest {
	op := &aws.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryInput{}
	}

	req := c.newRequest(op, input, &QueryOutput{})
	return QueryRequest{Request: req, Input: input, Copy: c.QueryRequest}
}

// QueryRequest is the request type for the
// Query API operation.
type QueryRequest struct {
	*aws.Request
	Input *QueryInput
	Copy  func(*QueryInput) QueryRequest
}

// Send marshals and sends the Query API request.
func (r QueryRequest) Send(ctx context.Context) (*QueryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &QueryResponse{
		QueryOutput: r.Request.Data.(*QueryOutput),
		response:    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// QueryResponse is the response type for the
// Query API operation.
type QueryResponse struct {
	*QueryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Query request.
func (r *QueryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
