// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An address book with attributes.
type AddressBook struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AddressBook) String() string {
	return awsutil.Prettify(s)
}

// Information related to an address book.
type AddressBookData struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The description of the address book.
	Description *string `min:"1" type:"string"`

	// The name of the address book.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AddressBookData) String() string {
	return awsutil.Prettify(s)
}

// The audio message. There is a 1 MB limit on the audio file input and the
// only supported format is MP3. To convert your MP3 audio files to an Alexa-friendly,
//
// required codec version (MPEG version 2) and bit rate (48 kbps), you might
// use converter software. One option for this is a command-line tool, FFmpeg.
// For more information, see FFmpeg (https://www.ffmpeg.org/). The following
// command converts the provided <input-file> to an MP3 file that is played
// in the announcement:
//
// ffmpeg -i <input-file> -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000 <output-file.mp3>
type Audio struct {
	_ struct{} `type:"structure"`

	// The locale of the audio message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale Locale `type:"string" required:"true" enum:"true"`

	// The location of the audio file. Currently, S3 URLs are supported. Only S3
	// locations comprised of safe characters are valid. For more information, see
	// Safe Characters (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters).
	//
	// Location is a required field
	Location *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Audio) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Audio) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Audio"}
	if len(s.Locale) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Locale"))
	}

	if s.Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Usage report with specified parameters.
type BusinessReport struct {
	_ struct{} `type:"structure"`

	// The time of report delivery.
	DeliveryTime *time.Time `type:"timestamp"`

	// The download link where a user can download the report.
	DownloadUrl *string `type:"string"`

	// The failure code.
	FailureCode BusinessReportFailureCode `type:"string" enum:"true"`

	// The S3 location of the output reports.
	S3Location *BusinessReportS3Location `type:"structure"`

	// The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
	Status BusinessReportStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s BusinessReport) String() string {
	return awsutil.Prettify(s)
}

// The content range of the report.
type BusinessReportContentRange struct {
	_ struct{} `type:"structure"`

	// The interval of the content range.
	Interval BusinessReportInterval `type:"string" enum:"true"`
}

// String returns the string representation
func (s BusinessReportContentRange) String() string {
	return awsutil.Prettify(s)
}

// The recurrence of the reports.
type BusinessReportRecurrence struct {
	_ struct{} `type:"structure"`

	// The start date.
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s BusinessReportRecurrence) String() string {
	return awsutil.Prettify(s)
}

// The S3 location of the output reports.
type BusinessReportS3Location struct {
	_ struct{} `type:"structure"`

	// The S3 bucket name of the output reports.
	BucketName *string `type:"string"`

	// The path of the business report.
	Path *string `type:"string"`
}

// String returns the string representation
func (s BusinessReportS3Location) String() string {
	return awsutil.Prettify(s)
}

// The schedule of the usage report.
type BusinessReportSchedule struct {
	_ struct{} `type:"structure"`

	// The content range of the reports.
	ContentRange *BusinessReportContentRange `type:"structure"`

	// The format of the generated report (individual CSV files or zipped files
	// of individual files).
	Format BusinessReportFormat `type:"string" enum:"true"`

	// The details of the last business report delivery for a specified time interval.
	LastBusinessReport *BusinessReport `type:"structure"`

	// The recurrence of the reports.
	Recurrence *BusinessReportRecurrence `type:"structure"`

	// The S3 bucket name of the output reports.
	S3BucketName *string `type:"string"`

	// The S3 key where the report is delivered.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the business report schedule.
	ScheduleArn *string `type:"string"`

	// The name identifier of the schedule.
	ScheduleName *string `type:"string"`
}

// String returns the string representation
func (s BusinessReportSchedule) String() string {
	return awsutil.Prettify(s)
}

// The skill store category that is shown. Alexa skills are assigned a specific
// skill category during creation, such as News, Social, and Sports.
type Category struct {
	_ struct{} `type:"structure"`

	// The ID of the skill store category.
	CategoryId *int64 `min:"1" type:"long"`

	// The name of the skill store category.
	CategoryName *string `type:"string"`
}

// String returns the string representation
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// The default conference provider that is used if no other scheduled meetings
// are detected.
type ConferencePreference struct {
	_ struct{} `type:"structure"`

	// The ARN of the default conference provider.
	DefaultConferenceProviderArn *string `type:"string"`
}

// String returns the string representation
func (s ConferencePreference) String() string {
	return awsutil.Prettify(s)
}

// An entity that provides a conferencing solution. Alexa for Business acts
// as the voice interface and mediator that connects users to their preferred
// conference provider. Examples of conference providers include Amazon Chime,
// Zoom, Cisco, and Polycom.
type ConferenceProvider struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created conference provider.
	Arn *string `type:"string"`

	// The IP endpoint and protocol for calling.
	IPDialIn *IPDialIn `type:"structure"`

	// The meeting settings for the conference provider.
	MeetingSetting *MeetingSetting `type:"structure"`

	// The name of the conference provider.
	Name *string `min:"1" type:"string"`

	// The information for PSTN conferencing.
	PSTNDialIn *PSTNDialIn `type:"structure"`

	// The type of conference providers.
	Type ConferenceProviderType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ConferenceProvider) String() string {
	return awsutil.Prettify(s)
}

// A contact with attributes.
type Contact struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact, used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact, used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact. The phone number type defaults to WORK.
	// You can either specify PhoneNumber or PhoneNumbers. We recommend that you
	// use PhoneNumbers, which lets you specify the phone number type and multiple
	// numbers.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []SipAddress `type:"list"`
}

// String returns the string representation
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// Information related to a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact.
	ContactArn *string `type:"string"`

	// The name of the contact to display on the console.
	DisplayName *string `min:"1" type:"string"`

	// The first name of the contact, used to call the contact on the device.
	FirstName *string `min:"1" type:"string"`

	// The last name of the contact, used to call the contact on the device.
	LastName *string `min:"1" type:"string"`

	// The phone number of the contact. The phone number type defaults to WORK.
	// You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers,
	// which lets you specify the phone number type and multiple numbers.
	PhoneNumber *string `type:"string" sensitive:"true"`

	// The list of phone numbers for the contact.
	PhoneNumbers []PhoneNumber `type:"list"`

	// The list of SIP addresses for the contact.
	SipAddresses []SipAddress `type:"list"`
}

// String returns the string representation
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// The content definition. This can contain only one text, SSML, or audio list
// object.
type Content struct {
	_ struct{} `type:"structure"`

	// The list of audio messages.
	AudioList []Audio `type:"list"`

	// The list of SSML messages.
	SsmlList []Ssml `type:"list"`

	// The list of text messages.
	TextList []Text `type:"list"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Content"}
	if s.AudioList != nil {
		for i, v := range s.AudioList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SsmlList != nil {
		for i, v := range s.SsmlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SsmlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TextList != nil {
		for i, v := range s.TextList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextList", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Creates settings for the end of meeting reminder feature that are applied
// to a room profile. The end of meeting reminder enables Alexa to remind users
// when a meeting is ending.
type CreateEndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A range of 3 to 15 minutes that determines when the reminder begins.
	//
	// ReminderAtMinutes is a required field
	ReminderAtMinutes []int64 `min:"1" type:"list" required:"true"`

	// The type of sound that users hear during the end of meeting reminder.
	//
	// ReminderType is a required field
	ReminderType EndOfMeetingReminderType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateEndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndOfMeetingReminder) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEndOfMeetingReminder"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.ReminderAtMinutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReminderAtMinutes"))
	}
	if s.ReminderAtMinutes != nil && len(s.ReminderAtMinutes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReminderAtMinutes", 1))
	}
	if len(s.ReminderType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ReminderType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Creates settings for the instant booking feature that are applied to a room
// profile. When users start their meeting with Alexa, Alexa automatically books
// the room for the configured duration if the room is available.
type CreateInstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	//
	// DurationInMinutes is a required field
	DurationInMinutes *int64 `type:"integer" required:"true"`

	// Whether instant booking is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s CreateInstantBooking) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstantBooking) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInstantBooking"}

	if s.DurationInMinutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("DurationInMinutes"))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Creates meeting room settings of a room profile.
type CreateMeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Creates settings for the end of meeting reminder feature that are applied
	// to a room profile. The end of meeting reminder enables Alexa to remind users
	// when a meeting is ending.
	EndOfMeetingReminder *CreateEndOfMeetingReminder `type:"structure"`

	// Settings to automatically book a room for a configured duration if it's free
	// when joining a meeting with Alexa.
	InstantBooking *CreateInstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into to make the room available for
	// others. Users can check in by joining the meeting with Alexa or an AVS device,
	// or by saying “Alexa, check in.”
	RequireCheckIn *CreateRequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateMeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingRoomConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMeetingRoomConfiguration"}
	if s.EndOfMeetingReminder != nil {
		if err := s.EndOfMeetingReminder.Validate(); err != nil {
			invalidParams.AddNested("EndOfMeetingReminder", err.(aws.ErrInvalidParams))
		}
	}
	if s.InstantBooking != nil {
		if err := s.InstantBooking.Validate(); err != nil {
			invalidParams.AddNested("InstantBooking", err.(aws.ErrInvalidParams))
		}
	}
	if s.RequireCheckIn != nil {
		if err := s.RequireCheckIn.Validate(); err != nil {
			invalidParams.AddNested("RequireCheckIn", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Creates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to
// prompt the user to check in; otherwise, the room will be released.
type CreateRequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	//
	// ReleaseAfterMinutes is a required field
	ReleaseAfterMinutes *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateRequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRequireCheckIn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRequireCheckIn"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if s.ReleaseAfterMinutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReleaseAfterMinutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details about the developer that published the skill.
type DeveloperInfo struct {
	_ struct{} `type:"structure"`

	// The name of the developer.
	DeveloperName *string `type:"string"`

	// The email of the developer.
	Email *string `min:"1" type:"string"`

	// The URL of the privacy policy.
	PrivacyPolicy *string `type:"string"`

	// The website of the developer.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DeveloperInfo) String() string {
	return awsutil.Prettify(s)
}

// A device with attributes.
type Device struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device. If the status is not READY, check the DeviceStatusInfo
	// value for details.
	DeviceStatus DeviceStatus `type:"string" enum:"true"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// Detailed information about a device's network profile.
	NetworkProfileInfo *DeviceNetworkProfileInfo `type:"structure"`

	// The room ARN of a device.
	RoomArn *string `type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// Device attributes.
type DeviceData struct {
	_ struct{} `type:"structure"`

	// The ARN of a device.
	DeviceArn *string `type:"string"`

	// The name of a device.
	DeviceName *string `min:"2" type:"string"`

	// The serial number of a device.
	DeviceSerialNumber *string `type:"string"`

	// The status of a device.
	DeviceStatus DeviceStatus `type:"string" enum:"true"`

	// Detailed information about a device's status.
	DeviceStatusInfo *DeviceStatusInfo `type:"structure"`

	// The type of a device.
	DeviceType *string `type:"string"`

	// The MAC address of a device.
	MacAddress *string `type:"string"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The room ARN associated with a device.
	RoomArn *string `type:"string"`

	// The name of the room associated with a device.
	RoomName *string `min:"1" type:"string"`

	// The software version of a device.
	SoftwareVersion *string `type:"string"`
}

// String returns the string representation
func (s DeviceData) String() string {
	return awsutil.Prettify(s)
}

// The list of device events.
type DeviceEvent struct {
	_ struct{} `type:"structure"`

	// The time (in epoch) when the event occurred.
	Timestamp *time.Time `type:"timestamp"`

	// The type of device event.
	Type DeviceEventType `type:"string" enum:"true"`

	// The value of the event.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DeviceEvent) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a device's network profile.
type DeviceNetworkProfileInfo struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with a device.
	CertificateArn *string `type:"string"`

	// The time (in epoch) when the certificate expires.
	CertificateExpirationTime *time.Time `type:"timestamp"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`
}

// String returns the string representation
func (s DeviceNetworkProfileInfo) String() string {
	return awsutil.Prettify(s)
}

// Details of a device’s status.
type DeviceStatusDetail struct {
	_ struct{} `type:"structure"`

	// The device status detail code.
	Code DeviceStatusDetailCode `type:"string" enum:"true"`

	// The list of available features on the device.
	Feature Feature `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeviceStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about a device's status.
type DeviceStatusInfo struct {
	_ struct{} `type:"structure"`

	// The latest available information about the connection status of a device.
	ConnectionStatus ConnectionStatus `type:"string" enum:"true"`

	// One or more device status detail descriptions.
	DeviceStatusDetails []DeviceStatusDetail `type:"list"`
}

// String returns the string representation
func (s DeviceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type EndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool `type:"boolean"`

	// A range of 3 to 15 minutes that determines when the reminder begins.
	ReminderAtMinutes []int64 `min:"1" type:"list"`

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType EndOfMeetingReminderType `type:"string" enum:"true"`
}

// String returns the string representation
func (s EndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// A filter name and value pair that is used to return a more specific list
// of results. Filters can be used to match a set of resources by various criteria.
type Filter struct {
	_ struct{} `type:"structure"`

	// The key of a filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The values of a filter.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details of the gateway.
type Gateway struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway.
	Arn *string `type:"string"`

	// The description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string `type:"string"`

	// The name of the gateway.
	Name *string `min:"1" type:"string"`

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Gateway) String() string {
	return awsutil.Prettify(s)
}

// The details of the gateway group.
type GatewayGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group.
	Arn *string `type:"string"`

	// The description of the gateway group.
	Description *string `type:"string"`

	// The name of the gateway group.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GatewayGroup) String() string {
	return awsutil.Prettify(s)
}

// The summary of a gateway group.
type GatewayGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway group.
	Arn *string `type:"string"`

	// The description of the gateway group.
	Description *string `type:"string"`

	// The name of the gateway group.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GatewayGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// The summary of a gateway.
type GatewaySummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway.
	Arn *string `type:"string"`

	// The description of the gateway.
	Description *string `type:"string"`

	// The ARN of the gateway group that the gateway is associated to.
	GatewayGroupArn *string `type:"string"`

	// The name of the gateway.
	Name *string `min:"1" type:"string"`

	// The software version of the gateway. The gateway automatically updates its
	// software version during normal operation.
	SoftwareVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GatewaySummary) String() string {
	return awsutil.Prettify(s)
}

// The IP endpoint and protocol for calling.
type IPDialIn struct {
	_ struct{} `type:"structure"`

	// The protocol, including SIP, SIPS, and H323.
	//
	// CommsProtocol is a required field
	CommsProtocol CommsProtocol `type:"string" required:"true" enum:"true"`

	// The IP address.
	//
	// Endpoint is a required field
	Endpoint *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IPDialIn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPDialIn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IPDialIn"}
	if len(s.CommsProtocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CommsProtocol"))
	}

	if s.Endpoint == nil {
		invalidParams.Add(aws.NewErrParamRequired("Endpoint"))
	}
	if s.Endpoint != nil && len(*s.Endpoint) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Endpoint", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Settings for the instant booking feature that are applied to a room profile.
// When users start their meeting with Alexa, Alexa automatically books the
// room for the configured duration if the room is available.
type InstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int64 `type:"integer"`

	// Whether instant booking is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InstantBooking) String() string {
	return awsutil.Prettify(s)
}

// Meeting room settings of a room profile.
type MeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *EndOfMeetingReminder `type:"structure"`

	// Settings to automatically book the room if available for a configured duration
	// when joining a meeting with Alexa.
	InstantBooking *InstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into. This makes the room available
	// for others. Users can check in by joining the meeting with Alexa or an AVS
	// device, or by saying “Alexa, check in.”
	RequireCheckIn *RequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s MeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The values that indicate whether a pin is always required (YES), never required
// (NO), or OPTIONAL.
//
//    * If YES, Alexa will always ask for a meeting pin.
//
//    * If NO, Alexa will never ask for a meeting pin.
//
//    * If OPTIONAL, Alexa will ask if you have a meeting pin and if the customer
//    responds with yes, it will ask for the meeting pin.
type MeetingSetting struct {
	_ struct{} `type:"structure"`

	// The values that indicate whether the pin is always required.
	//
	// RequirePin is a required field
	RequirePin RequirePin `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s MeetingSetting) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingSetting) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MeetingSetting"}
	if len(s.RequirePin) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RequirePin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The network profile associated with a device.
type NetworkProfile struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// The current password of the Wi-Fi network.
	CurrentPassword *string `min:"5" type:"string" sensitive:"true"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod NetworkEapMethod `type:"string" enum:"true"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The next, or subsequent, password of the Wi-Fi network. This password is
	// asynchronously transmitted to the device and is used when the password of
	// the network changes to NextPassword.
	NextPassword *string `type:"string" sensitive:"true"`

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType NetworkSecurityType `type:"string" enum:"true"`

	// The SSID of the Wi-Fi network.
	Ssid *string `min:"1" type:"string"`

	// The root certificates of your authentication server, which is installed on
	// your devices and used to trust your authentication server during EAP negotiation.
	TrustAnchors []string `min:"1" type:"list"`
}

// String returns the string representation
func (s NetworkProfile) String() string {
	return awsutil.Prettify(s)
}

// The data associated with a network profile.
type NetworkProfileData struct {
	_ struct{} `type:"structure"`

	// The ARN of the Private Certificate Authority (PCA) created in AWS Certificate
	// Manager (ACM). This is used to issue certificates to the devices.
	CertificateAuthorityArn *string `type:"string"`

	// Detailed information about a device's network profile.
	Description *string `type:"string"`

	// The authentication standard that is used in the EAP framework. Currently,
	// EAP_TLS is supported.
	EapMethod NetworkEapMethod `type:"string" enum:"true"`

	// The ARN of the network profile associated with a device.
	NetworkProfileArn *string `type:"string"`

	// The name of the network profile associated with a device.
	NetworkProfileName *string `min:"1" type:"string"`

	// The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK,
	// WPA_PSK, WEP, or OPEN.
	SecurityType NetworkSecurityType `type:"string" enum:"true"`

	// The SSID of the Wi-Fi network.
	Ssid *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NetworkProfileData) String() string {
	return awsutil.Prettify(s)
}

// The information for public switched telephone network (PSTN) conferencing.
type PSTNDialIn struct {
	_ struct{} `type:"structure"`

	// The zip code.
	//
	// CountryCode is a required field
	CountryCode *string `type:"string" required:"true"`

	// The delay duration before Alexa enters the conference ID with dual-tone multi-frequency
	// (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is
	// how we send data over the telephone network.
	//
	// OneClickIdDelay is a required field
	OneClickIdDelay *string `min:"1" type:"string" required:"true"`

	// The delay duration before Alexa enters the conference pin with dual-tone
	// multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF
	// tone, which is how we send data over the telephone network.
	//
	// OneClickPinDelay is a required field
	OneClickPinDelay *string `min:"1" type:"string" required:"true"`

	// The phone number to call to join the conference.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PSTNDialIn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PSTNDialIn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PSTNDialIn"}

	if s.CountryCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("CountryCode"))
	}

	if s.OneClickIdDelay == nil {
		invalidParams.Add(aws.NewErrParamRequired("OneClickIdDelay"))
	}
	if s.OneClickIdDelay != nil && len(*s.OneClickIdDelay) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OneClickIdDelay", 1))
	}

	if s.OneClickPinDelay == nil {
		invalidParams.Add(aws.NewErrParamRequired("OneClickPinDelay"))
	}
	if s.OneClickPinDelay != nil && len(*s.OneClickPinDelay) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OneClickPinDelay", 1))
	}

	if s.PhoneNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The phone number for the contact containing the raw number and phone number
// type.
type PhoneNumber struct {
	_ struct{} `type:"structure"`

	// The raw value of the phone number.
	//
	// Number is a required field
	Number *string `type:"string" required:"true" sensitive:"true"`

	// The type of the phone number.
	//
	// Type is a required field
	Type PhoneNumberType `type:"string" required:"true" enum:"true" sensitive:"true"`
}

// String returns the string representation
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumber) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PhoneNumber"}

	if s.Number == nil {
		invalidParams.Add(aws.NewErrParamRequired("Number"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A room profile with attributes.
type Profile struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The ARN of the address book.
	AddressBookArn *string `type:"string"`

	// The distance unit of a room profile.
	DistanceUnit DistanceUnit `type:"string" enum:"true"`

	// Retrieves if the profile is default or not.
	IsDefault *bool `type:"boolean"`

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string `min:"1" type:"string"`

	// The max volume limit of a room profile.
	MaxVolumeLimit *int64 `type:"integer"`

	// Meeting room settings of a room profile.
	MeetingRoomConfiguration *MeetingRoomConfiguration `type:"structure"`

	// The PSTN setting of a room profile.
	PSTNEnabled *bool `type:"boolean"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The setup mode of a room profile.
	SetupModeDisabled *bool `type:"boolean"`

	// The temperature unit of a room profile.
	TemperatureUnit TemperatureUnit `type:"string" enum:"true"`

	// The time zone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord WakeWord `type:"string" enum:"true"`
}

// String returns the string representation
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// The data of a room profile.
type ProfileData struct {
	_ struct{} `type:"structure"`

	// The address of a room profile.
	Address *string `min:"1" type:"string"`

	// The distance unit of a room profile.
	DistanceUnit DistanceUnit `type:"string" enum:"true"`

	// Retrieves if the profile data is default or not.
	IsDefault *bool `type:"boolean"`

	// The locale of a room profile. (This is currently available only to a limited
	// preview audience.)
	Locale *string `min:"1" type:"string"`

	// The ARN of a room profile.
	ProfileArn *string `type:"string"`

	// The name of a room profile.
	ProfileName *string `min:"1" type:"string"`

	// The temperature unit of a room profile.
	TemperatureUnit TemperatureUnit `type:"string" enum:"true"`

	// The time zone of a room profile.
	Timezone *string `min:"1" type:"string"`

	// The wake word of a room profile.
	WakeWord WakeWord `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProfileData) String() string {
	return awsutil.Prettify(s)
}

// Settings for the require check in feature that are applied to a room profile.
// Require check in allows a meeting room’s Alexa or AVS device to prompt
// the user to check in; otherwise, the room will be released.
type RequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	Enabled *bool `type:"boolean"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	ReleaseAfterMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s RequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// A room with attributes.
type Room struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Room) String() string {
	return awsutil.Prettify(s)
}

// The data of a room.
type RoomData struct {
	_ struct{} `type:"structure"`

	// The description of a room.
	Description *string `min:"1" type:"string"`

	// The profile ARN of a room.
	ProfileArn *string `type:"string"`

	// The profile name of a room.
	ProfileName *string `min:"1" type:"string"`

	// The provider calendar ARN of a room.
	ProviderCalendarId *string `type:"string"`

	// The ARN of a room.
	RoomArn *string `type:"string"`

	// The name of a room.
	RoomName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoomData) String() string {
	return awsutil.Prettify(s)
}

// A skill parameter associated with a room.
type RoomSkillParameter struct {
	_ struct{} `type:"structure"`

	// The parameter key of a room skill parameter. ParameterKey is an enumerated
	// type that only takes “DEFAULT” or “SCOPE” as valid values.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The parameter value of a room skill parameter.
	//
	// ParameterValue is a required field
	ParameterValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RoomSkillParameter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoomSkillParameter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RoomSkillParameter"}

	if s.ParameterKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParameterKey", 1))
	}

	if s.ParameterValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterValue"))
	}
	if s.ParameterValue != nil && len(*s.ParameterValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParameterValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The SIP address for the contact containing the URI and SIP address type.
type SipAddress struct {
	_ struct{} `type:"structure"`

	// The type of the SIP address.
	//
	// Type is a required field
	Type SipType `type:"string" required:"true" enum:"true" sensitive:"true"`

	// The URI for the SIP address.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SipAddress) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SipAddress) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SipAddress"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Uri == nil {
		invalidParams.Add(aws.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Granular information about the skill.
type SkillDetails struct {
	_ struct{} `type:"structure"`

	// The details about what the skill supports organized as bullet points.
	BulletPoints []string `type:"list"`

	// The details about the developer that published the skill.
	DeveloperInfo *DeveloperInfo `type:"structure"`

	// The URL of the end user license agreement.
	EndUserLicenseAgreement *string `type:"string"`

	// The generic keywords associated with the skill that can be used to find a
	// skill.
	GenericKeywords []string `type:"list"`

	// The phrase used to trigger the skill.
	InvocationPhrase *string `type:"string"`

	// The updates added in bullet points.
	NewInThisVersionBulletPoints []string `type:"list"`

	// The description of the product.
	ProductDescription *string `type:"string"`

	// The date when the skill was released.
	ReleaseDate *string `type:"string"`

	// The list of reviews for the skill, including Key and Value pair.
	Reviews map[string]string `type:"map"`

	// The types of skills.
	SkillTypes []string `type:"list"`
}

// String returns the string representation
func (s SkillDetails) String() string {
	return awsutil.Prettify(s)
}

// A skill group with attributes.
type SkillGroup struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SkillGroup) String() string {
	return awsutil.Prettify(s)
}

// The attributes of a skill group.
type SkillGroupData struct {
	_ struct{} `type:"structure"`

	// The description of a skill group.
	Description *string `min:"1" type:"string"`

	// The skill group ARN of a skill group.
	SkillGroupArn *string `type:"string"`

	// The skill group name of a skill group.
	SkillGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SkillGroupData) String() string {
	return awsutil.Prettify(s)
}

// The summary of skills.
type SkillSummary struct {
	_ struct{} `type:"structure"`

	// Whether the skill is enabled under the user's account, or if it requires
	// linking to be used.
	EnablementType EnablementType `type:"string" enum:"true"`

	// The ARN of the skill summary.
	SkillId *string `type:"string"`

	// The name of the skill.
	SkillName *string `min:"1" type:"string"`

	// Whether the skill is publicly available or is a private skill.
	SkillType SkillType `min:"1" type:"string" enum:"true"`

	// Linking support for a skill.
	SupportsLinking *bool `type:"boolean"`
}

// String returns the string representation
func (s SkillSummary) String() string {
	return awsutil.Prettify(s)
}

// The detailed information about an Alexa skill.
type SkillsStoreSkill struct {
	_ struct{} `type:"structure"`

	// The URL where the skill icon resides.
	IconUrl *string `type:"string"`

	// Sample utterances that interact with the skill.
	SampleUtterances []string `type:"list"`

	// Short description about the skill.
	ShortDescription *string `type:"string"`

	// Information about the skill.
	SkillDetails *SkillDetails `type:"structure"`

	// The ARN of the skill.
	SkillId *string `type:"string"`

	// The name of the skill.
	SkillName *string `min:"1" type:"string"`

	// Linking support for a skill.
	SupportsLinking *bool `type:"boolean"`
}

// String returns the string representation
func (s SkillsStoreSkill) String() string {
	return awsutil.Prettify(s)
}

// A smart home appliance that can connect to a central system. Any domestic
// device can be a smart appliance.
type SmartHomeAppliance struct {
	_ struct{} `type:"structure"`

	// The description of the smart home appliance.
	Description *string `type:"string"`

	// The friendly name of the smart home appliance.
	FriendlyName *string `type:"string"`

	// The name of the manufacturer of the smart home appliance.
	ManufacturerName *string `type:"string"`
}

// String returns the string representation
func (s SmartHomeAppliance) String() string {
	return awsutil.Prettify(s)
}

// An object representing a sort criteria.
type Sort struct {
	_ struct{} `type:"structure"`

	// The sort key of a sort object.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The sort value of a sort object.
	//
	// Value is a required field
	Value SortValue `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Sort"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if len(s.Value) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The SSML message. For more information, see SSML Reference (https://developer.amazon.com/docs/custom-skills/speech-synthesis-markup-language-ssml-reference.html).
type Ssml struct {
	_ struct{} `type:"structure"`

	// The locale of the SSML message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale Locale `type:"string" required:"true" enum:"true"`

	// The value of the SSML message in the correct SSML format. The audio tag is
	// not supported.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Ssml) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ssml) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ssml"}
	if len(s.Locale) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Locale"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A key-value pair that can be associated with a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of a tag. Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of a tag. Tag values are case sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The text message.
type Text struct {
	_ struct{} `type:"structure"`

	// The locale of the text message. Currently, en-US is supported.
	//
	// Locale is a required field
	Locale Locale `type:"string" required:"true" enum:"true"`

	// The value of the text message.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Text) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Text) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Text"}
	if len(s.Locale) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Locale"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Settings for the end of meeting reminder feature that are applied to a room
// profile. The end of meeting reminder enables Alexa to remind users when a
// meeting is ending.
type UpdateEndOfMeetingReminder struct {
	_ struct{} `type:"structure"`

	// Whether an end of meeting reminder is enabled or not.
	Enabled *bool `type:"boolean"`

	// Updates settings for the end of meeting reminder feature that are applied
	// to a room profile. The end of meeting reminder enables Alexa to remind users
	// when a meeting is ending.
	ReminderAtMinutes []int64 `min:"1" type:"list"`

	// The type of sound that users hear during the end of meeting reminder.
	ReminderType EndOfMeetingReminderType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateEndOfMeetingReminder) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndOfMeetingReminder) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEndOfMeetingReminder"}
	if s.ReminderAtMinutes != nil && len(s.ReminderAtMinutes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReminderAtMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Updates settings for the instant booking feature that are applied to a room
// profile. If instant booking is enabled, Alexa automatically reserves a room
// if it is free when a user joins a meeting with Alexa.
type UpdateInstantBooking struct {
	_ struct{} `type:"structure"`

	// Duration between 15 and 240 minutes at increments of 15 that determines how
	// long to book an available room when a meeting is started with Alexa.
	DurationInMinutes *int64 `type:"integer"`

	// Whether instant booking is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateInstantBooking) String() string {
	return awsutil.Prettify(s)
}

// Updates meeting room settings of a room profile.
type UpdateMeetingRoomConfiguration struct {
	_ struct{} `type:"structure"`

	// Settings for the end of meeting reminder feature that are applied to a room
	// profile. The end of meeting reminder enables Alexa to remind users when a
	// meeting is ending.
	EndOfMeetingReminder *UpdateEndOfMeetingReminder `type:"structure"`

	// Settings to automatically book an available room available for a configured
	// duration when joining a meeting with Alexa.
	InstantBooking *UpdateInstantBooking `type:"structure"`

	// Settings for requiring a check in when a room is reserved. Alexa can cancel
	// a room reservation if it's not checked into to make the room available for
	// others. Users can check in by joining the meeting with Alexa or an AVS device,
	// or by saying “Alexa, check in.”
	RequireCheckIn *UpdateRequireCheckIn `type:"structure"`

	// Whether room utilization metrics are enabled or not.
	RoomUtilizationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateMeetingRoomConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMeetingRoomConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMeetingRoomConfiguration"}
	if s.EndOfMeetingReminder != nil {
		if err := s.EndOfMeetingReminder.Validate(); err != nil {
			invalidParams.AddNested("EndOfMeetingReminder", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Updates settings for the require check in feature that are applied to a room
// profile. Require check in allows a meeting room’s Alexa or AVS device to
// prompt the user to check in; otherwise, the room will be released.
type UpdateRequireCheckIn struct {
	_ struct{} `type:"structure"`

	// Whether require check in is enabled or not.
	Enabled *bool `type:"boolean"`

	// Duration between 5 and 20 minutes to determine when to release the room if
	// it's not checked into.
	ReleaseAfterMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateRequireCheckIn) String() string {
	return awsutil.Prettify(s)
}

// Information related to a user.
type UserData struct {
	_ struct{} `type:"structure"`

	// The email of a user.
	Email *string `min:"1" type:"string"`

	// The enrollment ARN of a user.
	EnrollmentId *string `type:"string"`

	// The enrollment status of a user.
	EnrollmentStatus EnrollmentStatus `type:"string" enum:"true"`

	// The first name of a user.
	FirstName *string `type:"string"`

	// The last name of a user.
	LastName *string `type:"string"`

	// The ARN of a user.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s UserData) String() string {
	return awsutil.Prettify(s)
}
