// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationautoscaling

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The date and time for the scheduled action to end.
	EndTime *time.Time `type:"timestamp"`

	// The identifier of the resource associated with the scheduled action. This
	// string consists of the resource type and unique identifier.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot Fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * EMR cluster - The resource type is instancegroup and the unique identifier
	//    is the cluster ID and instance group ID. Example: instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0.
	//
	//    * AppStream 2.0 fleet - The resource type is fleet and the unique identifier
	//    is the fleet name. Example: fleet/sample-fleet.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the table name. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the index name. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	//    * Amazon SageMaker endpoint variant - The resource type is variant and
	//    the unique identifier is the resource ID. Example: endpoint/my-end-point/variant/KMeansClustering.
	//
	//    * Custom resources are not supported with a resource type. This parameter
	//    must specify the OutputValue from the CloudFormation template stack used
	//    to access the resources. The unique identifier is defined by the service
	//    provider. More information is available in our GitHub repository (https://github.com/aws/aws-auto-scaling-custom-resource).
	//
	//    * Amazon Comprehend document classification endpoint - The resource type
	//    and unique identifier are specified using the endpoint ARN. Example: arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE.
	//
	//    * Lambda provisioned concurrency - The resource type is function and the
	//    unique identifier is the function name with a function version or alias
	//    name suffix that is not $LATEST. Example: function:my-function:prod or
	//    function:my-function:1.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension. This string consists of the service namespace, resource
	// type, and scaling property.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet request.
	//
	//    * elasticmapreduce:instancegroup:InstanceCount - The instance count of
	//    an EMR Instance Group.
	//
	//    * appstream:fleet:DesiredCapacity - The desired capacity of an AppStream
	//    2.0 fleet.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible
	//    edition.
	//
	//    * sagemaker:variant:DesiredInstanceCount - The number of EC2 instances
	//    for an Amazon SageMaker model endpoint variant.
	//
	//    * custom-resource:ResourceType:Property - The scalable dimension for a
	//    custom resource provided by your own application or service.
	//
	//    * comprehend:document-classifier-endpoint:DesiredInferenceUnits - The
	//    number of inference units for an Amazon Comprehend document classification
	//    endpoint.
	//
	//    * lambda:function:ProvisionedConcurrency - The provisioned concurrency
	//    for a Lambda function.
	//
	// ScalableDimension is a required field
	ScalableDimension ScalableDimension `type:"string" required:"true" enum:"true"`

	// The new minimum and maximum capacity. You can set both values or just one.
	// During the scheduled time, if the current capacity is below the minimum capacity,
	// Application Auto Scaling scales out to the minimum capacity. If the current
	// capacity is above the maximum capacity, Application Auto Scaling scales in
	// to the maximum capacity.
	ScalableTargetAction *ScalableTargetAction `type:"structure"`

	// The schedule for this action. The following formats are supported:
	//
	//    * At expressions - "at(yyyy-mm-ddThh:mm:ss)"
	//
	//    * Rate expressions - "rate(value unit)"
	//
	//    * Cron expressions - "cron(fields)"
	//
	// At expressions are useful for one-time schedules. Specify the time, in UTC.
	//
	// For rate expressions, value is a positive integer and unit is minute | minutes
	// | hour | hours | day | days.
	//
	// For more information about cron expressions, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `min:"1" type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The namespace of the AWS service that provides the resource or custom-resource
	// for a resource provided by your own application or service. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace ServiceNamespace `type:"string" required:"true" enum:"true"`

	// The date and time for the scheduled action to start.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PutScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScheduledActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutScheduledActionInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if len(s.ScalableDimension) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ScalableDimension"))
	}
	if s.Schedule != nil && len(*s.Schedule) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Schedule", 1))
	}

	if s.ScheduledActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduledActionName", 1))
	}
	if len(s.ServiceNamespace) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutScheduledAction = "PutScheduledAction"

// PutScheduledActionRequest returns a request value for making API operation for
// Application Auto Scaling.
//
// Creates or updates a scheduled action for an Application Auto Scaling scalable
// target.
//
// Each scalable target is identified by a service namespace, resource ID, and
// scalable dimension. A scheduled action applies to the scalable target identified
// by those three attributes. You cannot create a scheduled action until you
// have registered the resource as a scalable target using RegisterScalableTarget.
//
// To update an action, specify its name and the parameters that you want to
// change. If you don't specify start and end times, the old values are deleted.
// Any other parameters that you don't specify are not changed by this update
// request.
//
// You can view the scheduled actions using DescribeScheduledActions. If you
// are no longer using a scheduled action, you can delete it using DeleteScheduledAction.
//
// Learn more about how to work with scheduled actions in the Application Auto
// Scaling User Guide (https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
//
//    // Example sending a request using PutScheduledActionRequest.
//    req := client.PutScheduledActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/PutScheduledAction
func (c *Client) PutScheduledActionRequest(input *PutScheduledActionInput) PutScheduledActionRequest {
	op := &aws.Operation{
		Name:       opPutScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledActionInput{}
	}

	req := c.newRequest(op, input, &PutScheduledActionOutput{})
	return PutScheduledActionRequest{Request: req, Input: input, Copy: c.PutScheduledActionRequest}
}

// PutScheduledActionRequest is the request type for the
// PutScheduledAction API operation.
type PutScheduledActionRequest struct {
	*aws.Request
	Input *PutScheduledActionInput
	Copy  func(*PutScheduledActionInput) PutScheduledActionRequest
}

// Send marshals and sends the PutScheduledAction API request.
func (r PutScheduledActionRequest) Send(ctx context.Context) (*PutScheduledActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutScheduledActionResponse{
		PutScheduledActionOutput: r.Request.Data.(*PutScheduledActionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutScheduledActionResponse is the response type for the
// PutScheduledAction API operation.
type PutScheduledActionResponse struct {
	*PutScheduledActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutScheduledAction request.
func (r *PutScheduledActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
