// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the GetId action.
type GetIdInput struct {
	_ struct{} `type:"structure"`

	// A standard AWS account ID (9+ digits).
	AccountId *string `min:"1" type:"string"`

	// An identity pool ID in the format REGION:GUID.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	// The available provider names for Logins are as follows:
	//
	//    * Facebook: graph.facebook.com
	//
	//    * Amazon Cognito user pool: cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>,
	//    for example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
	//
	//    * Google: accounts.google.com
	//
	//    * Amazon: www.amazon.com
	//
	//    * Twitter: api.twitter.com
	//
	//    * Digits: www.digits.com
	Logins map[string]string `type:"map"`
}

// String returns the string representation
func (s GetIdInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIdInput"}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 1))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned in response to a GetId request.
type GetIdOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetIdOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetId = "GetId"

// GetIdRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Generates (or retrieves) a Cognito ID. Supplying multiple logins will create
// an implicit linked account.
//
// This is a public API. You do not need any credentials to call this API.
//
//    // Example sending a request using GetIdRequest.
//    req := client.GetIdRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/GetId
func (c *Client) GetIdRequest(input *GetIdInput) GetIdRequest {
	op := &aws.Operation{
		Name:       opGetId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdInput{}
	}

	req := c.newRequest(op, input, &GetIdOutput{})
	req.Config.Credentials = aws.AnonymousCredentials
	return GetIdRequest{Request: req, Input: input, Copy: c.GetIdRequest}
}

// GetIdRequest is the request type for the
// GetId API operation.
type GetIdRequest struct {
	*aws.Request
	Input *GetIdInput
	Copy  func(*GetIdInput) GetIdRequest
}

// Send marshals and sends the GetId API request.
func (r GetIdRequest) Send(ctx context.Context) (*GetIdResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIdResponse{
		GetIdOutput: r.Request.Data.(*GetIdOutput),
		response:    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIdResponse is the response type for the
// GetId API operation.
type GetIdResponse struct {
	*GetIdOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetId request.
func (r *GetIdResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
