// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes a quota for an AWS account, for example, the number of replication
// instances allowed.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the AWS DMS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// The SSL certificate that can be used to encrypt connections between the endpoints
// and the replication instance.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The date that the certificate was created.
	CertificateCreationDate *time.Time `type:"timestamp"`

	// A customer-assigned name for the certificate. Identifiers must begin with
	// a letter; must contain only ASCII letters, digits, and hyphens; and must
	// not end with a hyphen or contain two consecutive hyphens.
	CertificateIdentifier *string `type:"string"`

	// The owner of the certificate.
	CertificateOwner *string `type:"string"`

	// The contents of a .pem file, which contains an X.509 certificate.
	CertificatePem *string `type:"string"`

	// The location of an imported Oracle Wallet certificate for use with SSL.
	//
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The key length of the cryptographic algorithm being used.
	KeyLength *int64 `type:"integer"`

	// The signing algorithm for the certificate.
	SigningAlgorithm *string `type:"string"`

	// The beginning date that the certificate is valid.
	ValidFromDate *time.Time `type:"timestamp"`

	// The final date that the certificate is valid.
	ValidToDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

type Connection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The identifier of the endpoint. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The error message when the connection last failed.
	LastFailureMessage *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// The connection status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// The settings in JSON format for the DMS Transfer type source endpoint.
type DmsTransferSettings struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket to use.
	BucketName *string `type:"string"`

	// The IAM role that has permission to access the Amazon S3 bucket.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation
func (s DmsTransferSettings) String() string {
	return awsutil.Prettify(s)
}

type DynamoDbSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used by the service access IAM role.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDbSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DynamoDbSettings"}

	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ElasticsearchSettings struct {
	_ struct{} `type:"structure"`

	// The endpoint for the Elasticsearch cluster.
	//
	// EndpointUri is a required field
	EndpointUri *string `type:"string" required:"true"`

	// The maximum number of seconds that DMS retries failed API requests to the
	// Elasticsearch cluster.
	ErrorRetryDuration *int64 `type:"integer"`

	// The maximum percentage of records that can fail to be written before a full
	// load operation stops.
	FullLoadErrorPercentage *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) used by service to access the IAM role.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ElasticsearchSettings"}

	if s.EndpointUri == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointUri"))
	}

	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type Endpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
	CertificateArn *string `type:"string"`

	// The name of the database at the endpoint.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Possible settings include the following:
	//
	//    * ServiceAccessRoleArn - The IAM role that has permission to access the
	//    Amazon S3 bucket.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	//    * CompressionType - An optional parameter to use GZIP to compress the
	//    target files. To use GZIP, set this value to NONE (the default). To keep
	//    the files uncompressed, don't use this value.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string,BucketName=string,CompressionType=string
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string", "CompressionType": "none"|"gzip" }
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// The settings for the target DynamoDB database. For more information, see
	// the DynamoDBSettings structure.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The settings for the Elasticsearch source endpoint. For more information,
	// see the ElasticsearchSettings structure.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter; must
	// contain only ASCII letters, digits, and hyphens; and must not end with a
	// hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint. Valid values are source and target.
	EndpointType ReplicationEndpointTypeValue `type:"string" enum:"true"`

	// The expanded name for the engine name. For example, if the EngineName parameter
	// is "aurora," this value would be "Amazon Aurora MySQL."
	EngineDisplayName *string `type:"string"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// mysql, oracle, postgres, mariadb, aurora, aurora-postgresql, redshift, s3,
	// db2, azuredb, sybase, dynamodb, mongodb, and sqlserver.
	EngineName *string `type:"string"`

	// Value returned by a call to CreateEndpoint that can be used for cross-account
	// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint
	// with a cross-account.
	ExternalId *string `type:"string"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional connection attributes used to connect to the endpoint.
	ExtraConnectionAttributes *string `type:"string"`

	// The settings for the Amazon Kinesis source endpoint. For more information,
	// see the KinesisSettings structure.
	KinesisSettings *KinesisSettings `type:"structure"`

	// An AWS KMS key identifier that is used to encrypt the connection parameters
	// for the endpoint.
	//
	// If you don't specify a value for the KmsKeyId parameter, then AWS DMS uses
	// your default encryption key.
	//
	// AWS KMS creates the default encryption key for your AWS account. Your AWS
	// account has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// The settings for the MongoDB source endpoint. For more information, see the
	// MongoDbSettings structure.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The port value used to access the endpoint.
	Port *int64 `type:"integer"`

	// Settings for the Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// The settings for the S3 target endpoint. For more information, see the S3Settings
	// structure.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server at the endpoint.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service access IAM role.
	ServiceAccessRoleArn *string `type:"string"`

	// The SSL mode used to connect to the endpoint. The default value is none.
	SslMode DmsSslModeValue `type:"string" enum:"true"`

	// The status of the endpoint.
	Status *string `type:"string"`

	// The user name used to connect to the endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

type Event struct {
	_ struct{} `type:"structure"`

	// The date of the event.
	Date *time.Time `type:"timestamp"`

	// The event categories available for the specified source type.
	EventCategories []string `type:"list"`

	// The event message.
	Message *string `type:"string"`

	// The identifier of an event source.
	SourceIdentifier *string `type:"string"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | endpoint | replication-task
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

type EventCategoryGroup struct {
	_ struct{} `type:"structure"`

	// A list of event categories from a source type that you've chosen.
	EventCategories []string `type:"list"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoryGroup) String() string {
	return awsutil.Prettify(s)
}

type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The AWS DMS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the AWS DMS event notification subscription.
	CustomerAwsId *string `type:"string"`

	// Boolean value that indicates if the event subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A lists of event categories.
	EventCategoriesList []string `type:"list"`

	// The topic ARN of the AWS DMS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source Ids for the event subscription.
	SourceIdsList []string `type:"list"`

	// The type of AWS DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`

	// The status of the AWS DMS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that AWS DMS no longer has permission
	// to post to the SNS topic. The status "topic-not-exist" indicates that the
	// topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filter value.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type KinesisSettings struct {
	_ struct{} `type:"structure"`

	// The output format for the records created on the endpoint. The message format
	// is JSON.
	MessageFormat MessageFormatValue `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to
	// the Amazon Kinesis data stream.
	ServiceAccessRoleArn *string `type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
	StreamArn *string `type:"string"`
}

// String returns the string representation
func (s KinesisSettings) String() string {
	return awsutil.Prettify(s)
}

type MongoDbSettings struct {
	_ struct{} `type:"structure"`

	// The authentication mechanism you use to access the MongoDB source endpoint.
	//
	// Valid values: DEFAULT, MONGODB_CR, SCRAM_SHA_1
	//
	// DEFAULT – For MongoDB version 2.x, use MONGODB_CR. For MongoDB version
	// 3.x, use SCRAM_SHA_1. This setting is not used when authType=No.
	AuthMechanism AuthMechanismValue `type:"string" enum:"true"`

	// The MongoDB database name. This setting is not used when authType=NO.
	//
	// The default is admin.
	AuthSource *string `type:"string"`

	// The authentication type you use to access the MongoDB source endpoint.
	//
	// Valid values: NO, PASSWORD
	//
	// When NO is selected, user name and password parameters are not used and can
	// be empty.
	AuthType AuthTypeValue `type:"string" enum:"true"`

	// The database name on the MongoDB source endpoint.
	DatabaseName *string `type:"string"`

	// Indicates the number of documents to preview to determine the document organization.
	// Use this setting when NestingLevel is set to ONE.
	//
	// Must be a positive value greater than 0. Default value is 1000.
	DocsToInvestigate *string `type:"string"`

	// Specifies the document ID. Use this setting when NestingLevel is set to NONE.
	//
	// Default value is false.
	ExtractDocId *string `type:"string"`

	// The AWS KMS key identifier that is used to encrypt the content on the replication
	// instance. If you don't specify a value for the KmsKeyId parameter, then AWS
	// DMS uses your default encryption key. AWS KMS creates the default encryption
	// key for your AWS account. Your AWS account has a different default encryption
	// key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// Specifies either document or table mode.
	//
	// Valid values: NONE, ONE
	//
	// Default value is NONE. Specify NONE to use document mode. Specify ONE to
	// use table mode.
	NestingLevel NestingLevelValue `type:"string" enum:"true"`

	// The password for the user account you use to access the MongoDB source endpoint.
	Password *string `type:"string" sensitive:"true"`

	// The port value for the MongoDB source endpoint.
	Port *int64 `type:"integer"`

	// The name of the server on the MongoDB source endpoint.
	ServerName *string `type:"string"`

	// The user name you use to access the MongoDB source endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s MongoDbSettings) String() string {
	return awsutil.Prettify(s)
}

type OrderableReplicationInstance struct {
	_ struct{} `type:"structure"`

	// List of Availability Zones for this replication instance.
	AvailabilityZones []string `type:"list"`

	// The default amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	DefaultAllocatedStorage *int64 `type:"integer"`

	// The version of the replication engine.
	EngineVersion *string `type:"string"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	IncludedAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MinAllocatedStorage *int64 `type:"integer"`

	// The value returned when the specified EngineVersion of the replication instance
	// is in Beta or test mode. This indicates some features might not work as expected.
	//
	// AWS DMS supports the ReleaseStatus parameter in versions 3.1.4 and later.
	ReleaseStatus ReleaseStatusValues `type:"string" enum:"true"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The type of storage used by the replication instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s OrderableReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action will be applied. The maintenance
	// action will be applied to the resource during its first maintenance window
	// after this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action will be applied to
	// the resource. This date takes into account opt-in requests received from
	// the ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the
	// ForcedApplyDate. This value is blank if an opt-in request has not been received
	// and nothing has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action will be automatically applied. The maintenance
	// action will be applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

type RedshiftSettings struct {
	_ struct{} `type:"structure"`

	// A value that indicates to allow any date format, including invalid formats
	// such as 00/00/00 00:00:00, to be loaded without generating an error. You
	// can choose true or false (the default).
	//
	// This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE
	// with the DATEFORMAT parameter. If the date format for the data doesn't match
	// the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that
	// field.
	AcceptAnyDate *bool `type:"boolean"`

	// Code to run after connecting. This parameter should contain the code itself,
	// not the name of a file containing the code.
	AfterConnectScript *string `type:"string"`

	// The location where the comma-separated value (.csv) files are stored before
	// being uploaded to the S3 bucket.
	BucketFolder *string `type:"string"`

	// The name of the S3 bucket you want to use
	BucketName *string `type:"string"`

	// A value that sets the amount of time to wait (in milliseconds) before timing
	// out, beginning from when you initially establish a connection.
	ConnectionTimeout *int64 `type:"integer"`

	// The name of the Amazon Redshift data warehouse (service) that you are working
	// with.
	DatabaseName *string `type:"string"`

	// The date format that you are using. Valid values are auto (case-sensitive),
	// your date format string enclosed in quotes, or NULL. If this parameter is
	// left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using auto recognizes
	// most strings, even some that aren't supported when you use a date format
	// string.
	//
	// If your date and time values use formats different from each other, set this
	// to auto.
	DateFormat *string `type:"string"`

	// A value that specifies whether AWS DMS should migrate empty CHAR and VARCHAR
	// fields as NULL. A value of true sets empty CHAR and VARCHAR fields to null.
	// The default is false.
	EmptyAsNull *bool `type:"boolean"`

	// The type of server-side encryption that you want to use for your data. This
	// encryption type is part of the endpoint settings or the extra connections
	// attributes for Amazon S3. You can choose either SSE_S3 (the default) or SSE_KMS.
	// To use SSE_S3, create an AWS Identity and Access Management (IAM) role with
	// a policy that allows "arn:aws:s3:::*" to use the following actions: "s3:PutObject",
	// "s3:ListBucket"
	EncryptionMode EncryptionModeValue `type:"string" enum:"true"`

	// The number of threads used to upload a single file. This parameter accepts
	// a value from 1 through 64. It defaults to 10.
	FileTransferUploadStreams *int64 `type:"integer"`

	// The amount of time to wait (in milliseconds) before timing out, beginning
	// from when you begin loading.
	LoadTimeout *int64 `type:"integer"`

	// The maximum size (in KB) of any .csv file used to transfer data to Amazon
	// Redshift. This accepts a value from 1 through 1,048,576. It defaults to 32,768
	// KB (32 MB).
	MaxFileSize *int64 `type:"integer"`

	// The password for the user named in the username property.
	Password *string `type:"string" sensitive:"true"`

	// The port number for Amazon Redshift. The default value is 5439.
	Port *int64 `type:"integer"`

	// A value that specifies to remove surrounding quotation marks from strings
	// in the incoming data. All characters within the quotation marks, including
	// delimiters, are retained. Choose true to remove quotation marks. The default
	// is false.
	RemoveQuotes *bool `type:"boolean"`

	// A value that specifies to replaces the invalid characters specified in ReplaceInvalidChars,
	// substituting the specified characters instead. The default is "?".
	ReplaceChars *string `type:"string"`

	// A list of characters that you want to replace. Use with ReplaceChars.
	ReplaceInvalidChars *string `type:"string"`

	// The name of the Amazon Redshift cluster you are using.
	ServerName *string `type:"string"`

	// The AWS KMS key ID. If you are using SSE_KMS for the EncryptionMode, provide
	// this key ID. The key that you use needs an attached policy that enables IAM
	// user permissions and allows use of the key.
	ServerSideEncryptionKmsKeyId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon
	// Redshift service.
	ServiceAccessRoleArn *string `type:"string"`

	// The time format that you want to use. Valid values are auto (case-sensitive),
	// 'timeformat_string', 'epochsecs', or 'epochmillisecs'. It defaults to 10.
	// Using auto recognizes most strings, even some that aren't supported when
	// you use a time format string.
	//
	// If your date and time values use formats different from each other, set this
	// parameter to auto.
	TimeFormat *string `type:"string"`

	// A value that specifies to remove the trailing white space characters from
	// a VARCHAR string. This parameter applies only to columns with a VARCHAR data
	// type. Choose true to remove unneeded white space. The default is false.
	TrimBlanks *bool `type:"boolean"`

	// A value that specifies to truncate data in columns to the appropriate number
	// of characters, so that the data fits in the column. This parameter applies
	// only to columns with a VARCHAR or CHAR data type, and rows with a size of
	// 4 MB or less. Choose true to truncate data. The default is false.
	TruncateColumns *bool `type:"boolean"`

	// An Amazon Redshift user name for a registered user.
	Username *string `type:"string"`

	// The size of the write buffer to use in rows. Valid values range from 1 through
	// 2,048. The default is 1,024. Use this setting to tune performance.
	WriteBufferSize *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftSettings) String() string {
	return awsutil.Prettify(s)
}

type RefreshSchemasStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The last failure message for the schema.
	LastFailureMessage *string `type:"string"`

	// The date the schema was last refreshed.
	LastRefreshDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The status of the schema.
	Status RefreshSchemasStatusTypeValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s RefreshSchemasStatus) String() string {
	return awsutil.Prettify(s)
}

type ReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Boolean value indicating if minor version upgrades will be automatically
	// applied to the instance.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The DNS name servers for the replication instance.
	DnsNameServers *string `type:"string"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// The expiration date of the free replication instance that is part of the
	// Free DMS program.
	FreeUntil *time.Time `type:"timestamp"`

	// The time the replication instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// An AWS KMS key identifier that is used to encrypt the data on the replication
	// instance.
	//
	// If you don't specify a value for the KmsKeyId parameter, then AWS DMS uses
	// your default encryption key.
	//
	// AWS KMS creates the default encryption key for your AWS account. Your AWS
	// account has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// cannot set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The pending modification values.
	PendingModifiedValues *ReplicationPendingModifiedValues `type:"structure"`

	// The maintenance window times for the replication instance.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	ReplicationInstanceIdentifier *string `type:"string"`

	// The private IP address of the replication instance.
	ReplicationInstancePrivateIpAddress *string `deprecated:"true" type:"string"`

	// One or more private IP addresses for the replication instance.
	ReplicationInstancePrivateIpAddresses []string `type:"list"`

	// The public IP address of the replication instance.
	ReplicationInstancePublicIpAddress *string `deprecated:"true" type:"string"`

	// One or more public IP addresses for the replication instance.
	ReplicationInstancePublicIpAddresses []string `type:"list"`

	// The status of the replication instance.
	ReplicationInstanceStatus *string `type:"string"`

	// The subnet group for the replication instance.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`

	// The availability zone of the standby replication instance in a Multi-AZ deployment.
	SecondaryAvailabilityZone *string `type:"string"`

	// The VPC security group for the instance.
	VpcSecurityGroups []VpcSecurityGroupMembership `type:"list"`
}

// String returns the string representation
func (s ReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// Contains metadata for a replication instance task log.
type ReplicationInstanceTaskLog struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of the replication task log.
	ReplicationInstanceTaskLogSize *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The name of the replication task.
	ReplicationTaskName *string `type:"string"`
}

// String returns the string representation
func (s ReplicationInstanceTaskLog) String() string {
	return awsutil.Prettify(s)
}

type ReplicationPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// cannot set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance.
	//
	// Valid Values: dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large
	// | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge
	ReplicationInstanceClass *string `type:"string"`
}

// String returns the string representation
func (s ReplicationPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

type ReplicationSubnetGroup struct {
	_ struct{} `type:"structure"`

	// A description for the replication subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The identifier of the replication instance subnet group.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// The subnets that are in the subnet group.
	Subnets []Subnet `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ReplicationSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

type ReplicationTask struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want the CDC
	// operation to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	CdcStartPosition *string `type:"string"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:3018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 3018-02-09T12:12:12
	// “
	CdcStopPosition *string `type:"string"`

	// The last error (failure) message generated for the replication instance.
	LastFailureMessage *string `type:"string"`

	// The type of migration.
	MigrationType MigrationTypeValue `type:"string" enum:"true"`

	// Indicates the last checkpoint that occurred during a change data capture
	// (CDC) operation. You can provide this value to the CdcStartPosition parameter
	// to start a CDC operation that begins at that checkpoint.
	RecoveryCheckpoint *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The date the replication task was created.
	ReplicationTaskCreationDate *time.Time `type:"timestamp"`

	// The user-assigned replication task identifier or name.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// The settings for the replication task.
	ReplicationTaskSettings *string `type:"string"`

	// The date the replication task is scheduled to start.
	ReplicationTaskStartDate *time.Time `type:"timestamp"`

	// The statistics for the task, including elapsed time, tables loaded, and table
	// errors.
	ReplicationTaskStats *ReplicationTaskStats `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	SourceEndpointArn *string `type:"string"`

	// The status of the replication task.
	Status *string `type:"string"`

	// The reason the replication task was stopped.
	StopReason *string `type:"string"`

	// Table mappings specified in the task.
	TableMappings *string `type:"string"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	TargetEndpointArn *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTask) String() string {
	return awsutil.Prettify(s)
}

// The task assessment report in JSON format.
type ReplicationTaskAssessmentResult struct {
	_ struct{} `type:"structure"`

	// The task assessment results in JSON format.
	AssessmentResults *string `type:"string"`

	// The file containing the results of the task assessment.
	AssessmentResultsFile *string `type:"string"`

	// The status of the task assessment.
	AssessmentStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The replication task identifier of the task on which the task assessment
	// was run.
	ReplicationTaskIdentifier *string `type:"string"`

	// The date the task assessment was completed.
	ReplicationTaskLastAssessmentDate *time.Time `type:"timestamp"`

	// The URL of the S3 object containing the task assessment results.
	S3ObjectUrl *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTaskAssessmentResult) String() string {
	return awsutil.Prettify(s)
}

type ReplicationTaskStats struct {
	_ struct{} `type:"structure"`

	// The elapsed time of the task, in milliseconds.
	ElapsedTimeMillis *int64 `type:"long"`

	// The date the replication task was started either with a fresh start or a
	// target reload.
	FreshStartDate *time.Time `type:"timestamp"`

	// The date the replication task full load was completed.
	FullLoadFinishDate *time.Time `type:"timestamp"`

	// The percent complete for the full load migration task.
	FullLoadProgressPercent *int64 `type:"integer"`

	// The date the the replication task full load was started.
	FullLoadStartDate *time.Time `type:"timestamp"`

	// The date the replication task was started either with a fresh start or a
	// resume. For more information, see StartReplicationTaskType (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType).
	StartDate *time.Time `type:"timestamp"`

	// The date the replication task was stopped.
	StopDate *time.Time `type:"timestamp"`

	// The number of errors that have occurred during this task.
	TablesErrored *int64 `type:"integer"`

	// The number of tables loaded for this task.
	TablesLoaded *int64 `type:"integer"`

	// The number of tables currently loading for this task.
	TablesLoading *int64 `type:"integer"`

	// The number of tables queued for this task.
	TablesQueued *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTaskStats) String() string {
	return awsutil.Prettify(s)
}

type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// Detailed information about the pending maintenance action.
	PendingMaintenanceActionDetails []PendingMaintenanceAction `type:"list"`

	// The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
	// action applies to. For information about creating an ARN, see Constructing
	// an Amazon Resource Name (ARN) for AWS DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html)
	// in the DMS documentation.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// Settings for exporting data to Amazon S3.
type S3Settings struct {
	_ struct{} `type:"structure"`

	// An optional parameter to set a folder name in the S3 bucket. If provided,
	// tables are created in the path bucketFolder/schema_name/table_name/. If this
	// parameter is not specified, then the path used is schema_name/table_name/.
	BucketFolder *string `type:"string"`

	// The name of the S3 bucket.
	BucketName *string `type:"string"`

	// A value that enables a change data capture (CDC) load to write only INSERT
	// operations to .csv or columnar storage (.parquet) output files. By default
	// (the false setting), the first field in a .csv or .parquet record contains
	// the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether
	// the row was inserted, updated, or deleted at the source database for a CDC
	// load to the target.
	//
	// If CdcInsertsOnly is set to true or y, only INSERTs from the source database
	// are migrated to the .csv or .parquet file. For .csv format only, how these
	// INSERTs are recorded depends on the value of IncludeOpForFullLoad. If IncludeOpForFullLoad
	// is set to true, the first field of every CDC record is set to I to indicate
	// the INSERT operation at the source. If IncludeOpForFullLoad is set to false,
	// every CDC record is written without a first field to indicate the INSERT
	// operation at the source. For more information about how these settings work
	// together, see Indicating Source DB Operations in Migrated S3 Data (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps)
	// in the AWS Database Migration Service User Guide..
	//
	// AWS DMS supports this interaction between the CdcInsertsOnly and IncludeOpForFullLoad
	// parameters in versions 3.1.4 and later.
	CdcInsertsOnly *bool `type:"boolean"`

	// An optional parameter to use GZIP to compress the target files. Set to GZIP
	// to compress the target files. Set to NONE (the default) or do not use to
	// leave the files uncompressed. Applies to both .csv and .parquet file formats.
	CompressionType CompressionTypeValue `type:"string" enum:"true"`

	// The delimiter used to separate columns in the source files. The default is
	// a comma.
	CsvDelimiter *string `type:"string"`

	// The delimiter used to separate rows in the source files. The default is a
	// carriage return (\n).
	CsvRowDelimiter *string `type:"string"`

	// The format of the data that you want to use for output. You can choose one
	// of the following:
	//
	//    * csv : This is a row-based file format with comma-separated values (.csv).
	//
	//    * parquet : Apache Parquet (.parquet) is a columnar storage file format
	//    that features efficient compression and provides faster query response.
	DataFormat DataFormatValue `type:"string" enum:"true"`

	// The size of one data page in bytes. This parameter defaults to 1024 * 1024
	// bytes (1 MiB). This number is used for .parquet file format only.
	DataPageSize *int64 `type:"integer"`

	// The maximum size of an encoded dictionary page of a column. If the dictionary
	// page exceeds this, this column is stored using an encoding type of PLAIN.
	// This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of
	// a dictionary page before it reverts to PLAIN encoding. This size is used
	// for .parquet file format only.
	DictPageSizeLimit *int64 `type:"integer"`

	// A value that enables statistics for Parquet pages and row groups. Choose
	// true to enable statistics, false to disable. Statistics include NULL, DISTINCT,
	// MAX, and MIN values. This parameter defaults to true. This value is used
	// for .parquet file format only.
	EnableStatistics *bool `type:"boolean"`

	// The type of encoding you are using:
	//
	//    * RLE_DICTIONARY uses a combination of bit-packing and run-length encoding
	//    to store repeated values more efficiently. This is the default.
	//
	//    * PLAIN doesn't use encoding at all. Values are stored as they are.
	//
	//    * PLAIN_DICTIONARY builds a dictionary of the values encountered in a
	//    given column. The dictionary is stored in a dictionary page for each column
	//    chunk.
	EncodingType EncodingTypeValue `type:"string" enum:"true"`

	// The type of server-side encryption that you want to use for your data. This
	// encryption type is part of the endpoint settings or the extra connections
	// attributes for Amazon S3. You can choose either SSE_S3 (the default) or SSE_KMS.
	// To use SSE_S3, you need an AWS Identity and Access Management (IAM) role
	// with permission to allow "arn:aws:s3:::dms-*" to use the following actions:
	//
	//    * s3:CreateBucket
	//
	//    * s3:ListBucket
	//
	//    * s3:DeleteBucket
	//
	//    * s3:GetBucketLocation
	//
	//    * s3:GetObject
	//
	//    * s3:PutObject
	//
	//    * s3:DeleteObject
	//
	//    * s3:GetObjectVersion
	//
	//    * s3:GetBucketPolicy
	//
	//    * s3:PutBucketPolicy
	//
	//    * s3:DeleteBucketPolicy
	EncryptionMode EncryptionModeValue `type:"string" enum:"true"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// A value that enables a full load to write INSERT operations to the comma-separated
	// value (.csv) output files only to indicate how the rows were added to the
	// source database.
	//
	// AWS DMS supports the IncludeOpForFullLoad parameter in versions 3.1.4 and
	// later.
	//
	// For full load, records can only be inserted. By default (the false setting),
	// no information is recorded in these output files for a full load to indicate
	// that the rows were inserted at the source database. If IncludeOpForFullLoad
	// is set to true or y, the INSERT is recorded as an I annotation in the first
	// field of the .csv file. This allows the format of your target records from
	// a full load to be consistent with the target records from a CDC load.
	//
	// This setting works together with the CdcInsertsOnly parameter for output
	// to .csv files only. For more information about how these settings work together,
	// see Indicating Source DB Operations in Migrated S3 Data (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps)
	// in the AWS Database Migration Service User Guide..
	IncludeOpForFullLoad *bool `type:"boolean"`

	// A value that specifies the precision of any TIMESTAMP column values that
	// are written to an Amazon S3 object file in .parquet format.
	//
	// AWS DMS supports the ParquetTimestampInMillisecond parameter in versions
	// 3.1.4 and later.
	//
	// When ParquetTimestampInMillisecond is set to true or y, AWS DMS writes all
	// TIMESTAMP columns in a .parquet formatted file with millisecond precision.
	// Otherwise, DMS writes them with microsecond precision.
	//
	// Currently, Amazon Athena and AWS Glue can handle only millisecond precision
	// for TIMESTAMP values. Set this parameter to true for S3 endpoint object files
	// that are .parquet formatted only if you plan to query or process the data
	// with Athena or AWS Glue.
	//
	// AWS DMS writes any TIMESTAMP column values written to an S3 file in .csv
	// format with microsecond precision.
	//
	// Setting ParquetTimestampInMillisecond has no effect on the string format
	// of the timestamp column value that is inserted by setting the TimestampColumnName
	// parameter.
	ParquetTimestampInMillisecond *bool `type:"boolean"`

	// The version of the Apache Parquet format that you want to use: parquet_1_0
	// (the default) or parquet_2_0.
	ParquetVersion ParquetVersionValue `type:"string" enum:"true"`

	// The number of rows in a row group. A smaller row group size provides faster
	// reads. But as the number of row groups grows, the slower writes become. This
	// parameter defaults to 10,000 rows. This number is used for .parquet file
	// format only.
	//
	// If you choose a value larger than the maximum, RowGroupLength is set to the
	// max row group length in bytes (64 * 1024 * 1024).
	RowGroupLength *int64 `type:"integer"`

	// If you are using SSE_KMS for the EncryptionMode, provide the AWS KMS key
	// ID. The key that you use needs an attached policy that enables AWS Identity
	// and Access Management (IAM) user permissions and allows use of the key.
	//
	// Here is a CLI example: aws dms create-endpoint --endpoint-identifier value
	// --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=value,BucketFolder=value,BucketName=value,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=value
	ServerSideEncryptionKmsKeyId *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service access IAM role.
	ServiceAccessRoleArn *string `type:"string"`

	// A value that when nonblank causes AWS DMS to add a column with timestamp
	// information to the endpoint data for an Amazon S3 target.
	//
	// AWS DMS supports the TimestampColumnName parameter in versions 3.1.4 and
	// later.
	//
	// DMS includes an additional STRING column in the .csv or .parquet object files
	// of your migrated data when you set TimestampColumnName to a nonblank value.
	//
	// For a full load, each row of this timestamp column contains a timestamp for
	// when the data was transferred from the source to the target by DMS.
	//
	// For a change data capture (CDC) load, each row of the timestamp column contains
	// the timestamp for the commit of that row in the source database.
	//
	// The string format for this timestamp column value is yyyy-MM-dd HH:mm:ss.SSSSSS.
	// By default, the precision of this value is in microseconds. For a CDC load,
	// the rounding of the precision depends on the commit timestamp supported by
	// DMS for the source database.
	//
	// When the AddColumnName parameter is set to true, DMS also includes a name
	// for the timestamp column that you set with TimestampColumnName.
	TimestampColumnName *string `type:"string"`
}

// String returns the string representation
func (s S3Settings) String() string {
	return awsutil.Prettify(s)
}

type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The subnet identifier.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

type SupportedEndpointType struct {
	_ struct{} `type:"structure"`

	// The type of endpoint. Valid values are source and target.
	EndpointType ReplicationEndpointTypeValue `type:"string" enum:"true"`

	// The expanded name for the engine name. For example, if the EngineName parameter
	// is "aurora," this value would be "Amazon Aurora MySQL."
	EngineDisplayName *string `type:"string"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// mysql, oracle, postgres, mariadb, aurora, aurora-postgresql, redshift, s3,
	// db2, azuredb, sybase, dynamodb, mongodb, and sqlserver.
	EngineName *string `type:"string"`

	// Indicates if Change Data Capture (CDC) is supported.
	SupportsCDC *bool `type:"boolean"`
}

// String returns the string representation
func (s SupportedEndpointType) String() string {
	return awsutil.Prettify(s)
}

type TableStatistics struct {
	_ struct{} `type:"structure"`

	// The Data Definition Language (DDL) used to build and modify the structure
	// of your tables.
	Ddls *int64 `type:"long"`

	// The number of delete actions performed on a table.
	Deletes *int64 `type:"long"`

	// The number of rows that failed conditional checks during the Full Load operation
	// (valid only for DynamoDB as a target migrations).
	FullLoadCondtnlChkFailedRows *int64 `type:"long"`

	// The number of rows that failed to load during the Full Load operation (valid
	// only for DynamoDB as a target migrations).
	FullLoadErrorRows *int64 `type:"long"`

	// The number of rows added during the Full Load operation.
	FullLoadRows *int64 `type:"long"`

	// The number of insert actions performed on a table.
	Inserts *int64 `type:"long"`

	// The last time the table was updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The schema name.
	SchemaName *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The state of the tables described.
	//
	// Valid states: Table does not exist | Before load | Full load | Table completed
	// | Table cancelled | Table error | Table all | Table updates | Table is being
	// reloaded
	TableState *string `type:"string"`

	// The number of update actions performed on a table.
	Updates *int64 `type:"long"`

	// The number of records that failed validation.
	ValidationFailedRecords *int64 `type:"long"`

	// The number of records that have yet to be validated.
	ValidationPendingRecords *int64 `type:"long"`

	// The validation state of the table.
	//
	// The parameter can have the following values
	//
	//    * Not enabled—Validation is not enabled for the table in the migration
	//    task.
	//
	//    * Pending records—Some records in the table are waiting for validation.
	//
	//    * Mismatched records—Some records in the table do not match between
	//    the source and target.
	//
	//    * Suspended records—Some records in the table could not be validated.
	//
	//    * No primary key—The table could not be validated because it had no
	//    primary key.
	//
	//    * Table error—The table was not validated because it was in an error
	//    state and some data was not migrated.
	//
	//    * Validated—All rows in the table were validated. If the table is updated,
	//    the status can change from Validated.
	//
	//    * Error—The table could not be validated because of an unexpected error.
	ValidationState *string `type:"string"`

	// Additional details about the state of validation.
	ValidationStateDetails *string `type:"string"`

	// The number of records that could not be validated.
	ValidationSuspendedRecords *int64 `type:"long"`
}

// String returns the string representation
func (s TableStatistics) String() string {
	return awsutil.Prettify(s)
}

type TableToReload struct {
	_ struct{} `type:"structure"`

	// The schema name of the table to be reloaded.
	SchemaName *string `type:"string"`

	// The table name of the table to be reloaded.
	TableName *string `type:"string"`
}

// String returns the string representation
func (s TableToReload) String() string {
	return awsutil.Prettify(s)
}

type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and cannot be prefixed with "aws:" or "dms:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and cannot be prefixed with "aws:" or
	// "dms:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The VPC security group Id.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}
